// Code generated by smithy-go-codegen DO NOT EDIT.

package codecatalyst

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about the URLs that can be used with a Git client to clone a
// source repository.
func (c *Client) GetSourceRepositoryCloneUrls(ctx context.Context, params *GetSourceRepositoryCloneUrlsInput, optFns ...func(*Options)) (*GetSourceRepositoryCloneUrlsOutput, error) {
	if params == nil {
		params = &GetSourceRepositoryCloneUrlsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSourceRepositoryCloneUrls", params, optFns, c.addOperationGetSourceRepositoryCloneUrlsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSourceRepositoryCloneUrlsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSourceRepositoryCloneUrlsInput struct {

	// The name of the project in the space.
	//
	// This member is required.
	ProjectName *string

	// The name of the source repository.
	//
	// This member is required.
	SourceRepositoryName *string

	// The name of the space.
	//
	// This member is required.
	SpaceName *string

	noSmithyDocumentSerde
}

type GetSourceRepositoryCloneUrlsOutput struct {

	// The HTTPS URL to use when cloning the source repository.
	//
	// This member is required.
	Https *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSourceRepositoryCloneUrlsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSourceRepositoryCloneUrls{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSourceRepositoryCloneUrls{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addBearerAuthSignerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpGetSourceRepositoryCloneUrlsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSourceRepositoryCloneUrls(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSourceRepositoryCloneUrls(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSourceRepositoryCloneUrls",
	}
}
