// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets configuration information about a continuous deployment policy.
func (c *Client) GetContinuousDeploymentPolicyConfig(ctx context.Context, params *GetContinuousDeploymentPolicyConfigInput, optFns ...func(*Options)) (*GetContinuousDeploymentPolicyConfigOutput, error) {
	if params == nil {
		params = &GetContinuousDeploymentPolicyConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetContinuousDeploymentPolicyConfig", params, optFns, c.addOperationGetContinuousDeploymentPolicyConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetContinuousDeploymentPolicyConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetContinuousDeploymentPolicyConfigInput struct {

	// The identifier of the continuous deployment policy whose configuration you are
	// getting.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

type GetContinuousDeploymentPolicyConfigOutput struct {

	// Contains the configuration for a continuous deployment policy.
	ContinuousDeploymentPolicyConfig *types.ContinuousDeploymentPolicyConfig

	// The version identifier for the current version of the continuous deployment
	// policy.
	ETag *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetContinuousDeploymentPolicyConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestxml_serializeOpGetContinuousDeploymentPolicyConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpGetContinuousDeploymentPolicyConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetContinuousDeploymentPolicyConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetContinuousDeploymentPolicyConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetContinuousDeploymentPolicyConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cloudfront",
		OperationName: "GetContinuousDeploymentPolicyConfig",
	}
}
