// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Summary information about the DataIntegration association.
type DataIntegrationAssociationSummary struct {

	// The identifier for the client that is associated with the DataIntegration
	// association.
	ClientId *string

	// The Amazon Resource Name (ARN) of the DataIntegration.
	DataIntegrationArn *string

	// The Amazon Resource Name (ARN) of the DataIntegration association.
	DataIntegrationAssociationArn *string

	noSmithyDocumentSerde
}

// Summary information about the DataIntegration.
type DataIntegrationSummary struct {

	// The Amazon Resource Name (ARN) of the DataIntegration.
	Arn *string

	// The name of the DataIntegration.
	Name *string

	// The URI of the data source.
	SourceURI *string

	noSmithyDocumentSerde
}

// The event filter.
type EventFilter struct {

	// The source of the events.
	//
	// This member is required.
	Source *string

	noSmithyDocumentSerde
}

// The event integration.
type EventIntegration struct {

	// The event integration description.
	Description *string

	// The Amazon EventBridge bus for the event integration.
	EventBridgeBus *string

	// The event integration filter.
	EventFilter *EventFilter

	// The Amazon Resource Name (ARN) of the event integration.
	EventIntegrationArn *string

	// The name of the event integration.
	Name *string

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The event integration association.
type EventIntegrationAssociation struct {

	// The metadata associated with the client.
	ClientAssociationMetadata map[string]string

	// The identifier for the client that is associated with the event integration.
	ClientId *string

	// The name of the EventBridge rule.
	EventBridgeRuleName *string

	// The Amazon Resource Name (ARN) for the event integration association.
	EventIntegrationAssociationArn *string

	// The identifier for the event integration association.
	EventIntegrationAssociationId *string

	// The name of the event integration.
	EventIntegrationName *string

	noSmithyDocumentSerde
}

// The configuration for what files should be pulled from the source.
type FileConfiguration struct {

	// Identifiers for the source folders to pull all files from recursively.
	//
	// This member is required.
	Folders []string

	// Restrictions for what files should be pulled from the source.
	Filters map[string][]string

	noSmithyDocumentSerde
}

// The name of the data and how often it should be pulled from the source.
type ScheduleConfiguration struct {

	// How often the data should be pulled from data source.
	//
	// This member is required.
	ScheduleExpression *string

	// The start date for objects to import in the first flow run as an Unix/epoch
	// timestamp in milliseconds or in ISO-8601 format.
	FirstExecutionFrom *string

	// The name of the object to pull from the data source.
	Object *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
