// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// A structure that contains the details of an alternate contact associated with an
// Amazon Web Services account
type AlternateContact struct {

	// The type of alternate contact.
	AlternateContactType AlternateContactType

	// The email address associated with this alternate contact.
	EmailAddress *string

	// The name associated with this alternate contact.
	Name *string

	// The phone number associated with this alternate contact.
	PhoneNumber *string

	// The title associated with this alternate contact.
	Title *string

	noSmithyDocumentSerde
}

// Contains the details of the primary contact information associated with an
// Amazon Web Services account.
type ContactInformation struct {

	// The first line of the primary contact address.
	//
	// This member is required.
	AddressLine1 *string

	// The city of the primary contact address.
	//
	// This member is required.
	City *string

	// The ISO-3166 two-letter country code for the primary contact address.
	//
	// This member is required.
	CountryCode *string

	// The full name of the primary contact address.
	//
	// This member is required.
	FullName *string

	// The phone number of the primary contact information. The number will be
	// validated and, in some countries, checked for activation.
	//
	// This member is required.
	PhoneNumber *string

	// The postal code of the primary contact address.
	//
	// This member is required.
	PostalCode *string

	// The second line of the primary contact address, if any.
	AddressLine2 *string

	// The third line of the primary contact address, if any.
	AddressLine3 *string

	// The name of the company associated with the primary contact information, if any.
	CompanyName *string

	// The district or county of the primary contact address, if any.
	DistrictOrCounty *string

	// The state or region of the primary contact address. This field is required in
	// selected countries.
	StateOrRegion *string

	// The URL of the website associated with the primary contact information, if any.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

// This is a structure that expresses the Region for a given account, consisting of
// a name and opt-in status.
type Region struct {

	// The Region code of a given Region (for example, us-east-1).
	RegionName *string

	// One of potential statuses a Region can undergo (Enabled, Enabling, Disabled,
	// Disabling, Enabled_By_Default).
	RegionOptStatus RegionOptStatus

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by the Amazon Web Services
// service in a specified field.
type ValidationExceptionField struct {

	// A message about the validation exception.
	//
	// This member is required.
	Message *string

	// The field name where the invalid entry was detected.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
