
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_PDFOUTLINE
#define _H_PDFOUTLINE

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSDictionary.h>


/* Outline of a PDFDocument.  */
@interface PDFOutline : NSObject
{
   NSArray* items;
   void*    xpdfOutlineItems;
   void*    xpdfDoc;
}

- (id) initWithOutlineItems: (void*)xpdfItems ofDocument: (void*)doc;
- (void) dealloc;

- (NSArray*) items;
@end


@interface PDFOutlineItem : NSObject
{
   NSString*  title;
   NSArray*   kids;
   void*      xpdfOutlineItem;
   void*      xpdfDoc;
}

- (id) initWithOutlineItem: (void*)xpdfItem ofDocument: (void*)doc;
- (void) dealloc;

- (NSString*) title;
- (int) destinationPage;

- (BOOL) hasKids;
- (NSArray*) kids;
- (int) countKids;

@end

#endif
