;;
;; Emacs startup file for gnus package
;;
;; First condition checks that the compiled code for gnus is installed
;; in a subdirectory of the respective emacs flavour site-lisp
;; directory. Two cases when such code is not installed are 1) if the
;; package is not fully installed, and 2) the emacs flavour is not
;; intented to be used with this version of Gnus (e.g. the most recent
;; GNU Emacs 23 contains newer Gnus than is included in this package).
;;
(if (file-exists-p (concat "/usr/share/"
			   (symbol-name debian-emacs-flavor)
			   "/site-lisp/gnus/gnus.elc"))
    (progn
      (provide 'gnus-init)
      (setq load-path (debian-pkg-add-load-path-item
		       (concat "/usr/share/"
			       (symbol-name 
				debian-emacs-flavor)
			       "/site-lisp/gnus")))
      ;; Make sure that the uncompiled files are also in the
      ;; load-path, though near the end.
      (setq load-path (nconc load-path 
			     (list "/usr/share/emacs/site-lisp/gnus/lisp")))

      (cond ((string-match "XEmacs" emacs-version))
	    ((string-match "Lucid"  emacs-version))
	    ((and (boundp 'epoch::version)
		  (stringp (symbol-value 'epoch::version))))
	    (t
	     (setq smiley-data-directory "/usr/share/pixmaps/smilies"
		   gnus-xmas-glyph-directory "/usr/share/pixmaps/gnus"
		   )))

      ))
