/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <qa_gr_fxpt_nco.h>
#include <gr_fxpt_nco.h>
#include <gr_nco.h>
#include <cppunit/TestAssert.h>
#include <iostream>
#include <stdio.h>
#include <unistd.h>
#include <math.h>

static const float SIN_COS_TOLERANCE = 1e-5;

static double max_d(double a, double b)
{
  return fabs(a) > fabs(b) ? a : b;
}

void
qa_gr_fxpt_nco::t0 ()
{
  gr_nco<float,float>	ref_nco;
  gr_fxpt_nco		new_nco;
  double max_error = 0, max_phase_error = 0;

  //ref_nco.set_freq ((float)(2 * M_PI / 5003));
  //new_nco.set_freq ((float)(2 * M_PI / 5003));
  ref_nco.set_freq ((float)(2 * M_PI / 4096));
  new_nco.set_freq ((float)(2 * M_PI / 4096));

  CPPUNIT_ASSERT_DOUBLES_EQUAL (ref_nco.get_freq(), new_nco.get_freq(), SIN_COS_TOLERANCE);

  for (int i = 0; i < 100000; i++){
    float ref_sin = ref_nco.sin ();
    float new_sin = new_nco.sin ();
    //printf ("i = %6d\n", i);
    CPPUNIT_ASSERT_DOUBLES_EQUAL (ref_sin, new_sin, SIN_COS_TOLERANCE);

    max_error = max_d (max_error, ref_sin-new_sin);

    float ref_cos = ref_nco.cos ();
    float new_cos = new_nco.cos ();
    CPPUNIT_ASSERT_DOUBLES_EQUAL (ref_cos, new_cos, SIN_COS_TOLERANCE);

    max_error = max_d (max_error, ref_cos-new_cos);

    ref_nco.step ();
    new_nco.step ();

    CPPUNIT_ASSERT_DOUBLES_EQUAL (ref_nco.get_phase(), new_nco.get_phase(), SIN_COS_TOLERANCE);

    max_phase_error = max_d (max_phase_error, ref_nco.get_phase()-new_nco.get_phase());
  }
  // printf ("Fxpt  max error %.9f, max phase error %.9f\n", max_error, max_phase_error);
}

void
qa_gr_fxpt_nco::t1 ()
{
}

void
qa_gr_fxpt_nco::t2 ()
{
}

void
qa_gr_fxpt_nco::t3 ()
{
}
