# GNU Enterprise Application Server - List Object
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: geasConfiguration.py 7976 2005-09-23 04:01:29Z johannes $

import os.path

from gnue import paths
from gnue.common.apps.i18n import translate as _        # for epydoc
from gnue.common.formatting import GTypecast


ConfigOptions = (

  { 'Name'       : 'database',
    'Type'       : 'Setting',
    'Comment'    : _("Depreciated: Name of the database connection appserver "
                     "is using. Use connection instead."),
    'Description': _("Depreciated: Name of the database connection appserver "
                     "is using. Use connection instead."),
    'Typecast'   : GTypecast.text,
    'Default'    : ''},

  { 'Name'       : 'connection',
    'Type'       : 'Setting',
    'Comment'    : _("Name of the database connection appserver is using"),
    'Description': _("Name of the database connection appserver is using"),
    'Typecast'   : GTypecast.text,
    'Default'    : 'gnue' },

  { 'Name'       : 'rpctype',
    'Type'       : 'Setting',
    'Comment'    : _('RPC Interface Type appserver is providing'),
    'Description': _('RPC Interface Type appserver is providing'),
    'Typecast'   : GTypecast.text,
    'Default'    : 'xmlrpc' },

  { 'Name'       : 'rpcport',
    'Type'       : 'Setting',
    'Comment'    : _('Port (if needed) for RPC Interface'),
    'Description': _('Port (if needed) for RPC Interface'),
    'Typecast'   : GTypecast.whole,
    'Default'    : '8765' },

  { 'Name'       : 'allowed_hosts',
    'Type'       : 'Setting',
    'Comment'    : _('Hosts which are allowed to access appserver'),
    'Description': _('Hosts which are allowed to access appserver'),
    'Typecast'   : GTypecast.text,
    'Default'    : '' },

  { 'Name'       : 'bindto',
    'Type'       : 'Setting',
    'Comment'    : _('Hostname of the interface to bind services to'),
    'Description': _('Hostname of the interface to bind services to'),
    'Typecast'   : GTypecast.text,
    'Default'    : '' },

  { 'Name'       : 'null_first_asc',
    'Type'       : 'Setting',
    'Comment'    : _('Null values appear first in ascending sort'),
    'Description': _('Null values appear first in ascending sort'),
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'null_first_dsc',
    'Type'       : 'Setting',
    'Comment'    : _('Null values appear first in descending sort'),
    'Description': _('Null values appear first in descending sort'),
    'Typecast'   : GTypecast.boolean,
    'Default'    : True },

  { 'Name'       : 'modulepath',
    'Type'       : 'Setting',
    'Comment'    : _('Semicolon-separated list of paths to load modules from'),
    'Description': _('Semicolon-separated list of paths to load modules from'),
    'Typecast'   : GTypecast.text,
    'Default'    : os.path.join (paths.data, "share", "gnue", "appserver") },

  { 'Name'       : 'uuidtype',
    'Type'       : 'Setting',
    'Comment'    : _("Type of UUID to use. Can be 'time' or 'random'"),
    'Description': _("Type of UUID to use. Can be 'time' or 'random'"),
    'Typecast'   : GTypecast.text,
    'Default'    : 'time' },

  { 'Name'       : 'httpdir',
    'Type'       : 'Setting',
    'Comment'    : _('Directory for webfrontend http documents'),
    'Description': _('Directory for webfrontend http documents'),
    'Typecast'   : GTypecast.text,
    'Default'    : "/this_dir_shouldn't exist." }, # default should be overridden
  { 'Name'       : 'servertype',
    'Type'       : 'Setting',
    'Comment'    : _("Type of the HTTP server to use. Can be 'threading' or " \
                     "'forking'"),
    'Description': _("Type of the HTTP server to use. Can be 'threading' or " \
                     "'forking'"),
    'Typecast'   : GTypecast.text,
    'Default'    : 'forking' },
)
