# GNU Enterprise Application Server - Testing unit 
#
# Copyright 2003-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: test.py 6851 2005-01-03 20:59:28Z jcater $
#

from gnue.appserver.test import testApp

if __name__ == '__main__':
  app = testApp ()
  sm  = app.getSessionManager ()

  print "Already loaded modules:", sm.modules.keys ()
  print "Already loaded classes:", sm.classes.keys ()

  print "Modules:", sm.modules.values ()

  print '\nModule "address":'
  m = sm.modules ["address"]
  m._session.setcontext ('address')
  # m = sm.modules ["gnue"]
  print "%s: %s\n" % (m.gnue_name, m.gnue_comment)

  print "Classes in 'address':"
  for k in m.classes.keys ():
    print k
    cl = m.classes [k]
    for p in cl.properties.keys ():
      print cl.fullName + "." + p
    print "-" * 50

  print "Procedures of 'address_person':"
  ap = m.classes ['address_person']
  for pr in ap.procedures.values ():
    print "%s coded in %s" % (pr.fullName, pr.gnue_language)
    print "Type of result:", repr (pr.gnue_type)
    if pr.isCalculated:
      print "(%s usable as calculated property '%s')" % (pr.fullName,
                                                         pr.calcFullName)

    for para in pr.parameters.values ():
      print "Parameter: %s of type %s" % (para.fullName, para.gnue_type)

  print "Number of modules: %d\n" % len (sm.modules)

  print "All modules via keys ():"
  for k in sm.modules.keys ():
    m = sm.modules [k]
    print k, ":", m.gnue_comment

  print
  print "All modules via values ():"
  for m in sm.modules.values ():
    print m.gnue_name + ": " + m.gnue_comment

  print
  print "All modules via items ():"
  for i in sm.modules.items ():
    print i

  print
  print 'Is there a module "address": %d' % sm.modules.has_key ("address")
  print 'Is there a module "foo": %d' % sm.modules.has_key ("foo")

  x = sm.classes ['gnue_class']
  print "gnue_class.gnue_id      nullable: %s" % \
    x.properties ['gnue_id'].gnue_nullable
  print "gnue_class.gnue_comment nullable: %s" % \
    x.properties ['gnue_comment'].gnue_nullable
