# GNU Enterprise Application Server - Class Repository
#
# Copyright 2003-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: __init__.py 6958 2005-02-04 10:14:03Z johannes $

import os, sys

from Module import *
from Class  import *
from Namespace import *
from Definition import *
from gnue import paths
from gnue.appserver.language import Session
from gnue.common.apps import errors, i18n


# -----------------------------------------------------------------------------
# Global module and class list
# -----------------------------------------------------------------------------

def init (server):
  
  # First, load the hardwired default repository
  basedir = os.path.join (paths.data, "share", "gnue", "appserver")
  defaultRepository = os.path.join (basedir, "repository.ini")

  session = Session.InternalSession (server)

  # Create a boot-catalogue from the ini-file
  bootcat = RepositoryDefinition (defaultRepository)

  # Boot the class repository using this boot-catalogue
  server.modules = ModuleDict (session, bootcat)
  server.classes = ClassDict (session, server.modules, None, bootcat)
  server.modules.classdict = server.classes

  for module in server.modules.values ():
    module.replaceReferences (server.classes)

  # and finally refresh the repository from the datasource
  server.modules.reload ()
  server.classes.reload ()

  for module in server.modules.values ():
    module.validate ()

  gDebug (1, "Classrepository loaded")
  return
