# GNU Enterprise Application Server - List Object
#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: geasList.py 5103 2004-02-12 15:34:33Z reinhard $

import geasInstance
import string

# =============================================================================
# List class
# =============================================================================

class geasList:

  # ---------------------------------------------------------------------------
  # Initalize
  # ---------------------------------------------------------------------------

  def __init__ (self, session, classdef, recordset, propertylist):
    self.__session = session
    self.__classdef = classdef
    self.__recordset = recordset
    self.__prefetch = propertylist      # property names to be prefetched

  # ---------------------------------------------------------------------------
  # Get the first instance in the list
  # ---------------------------------------------------------------------------

  def firstInstance (self):
    record = self.__recordset.firstRecord ()
    if record is not None:
      return geasInstance.geasInstance (self.__session, record, self.__classdef)
    else:
      return None

  # ---------------------------------------------------------------------------
  # Get the next instance in the list
  # ---------------------------------------------------------------------------

  def nextInstance (self):
    record = self.__recordset.nextRecord ()
    if record is not None:
      return geasInstance.geasInstance (self.__session, record, self.__classdef)
    else:
      return None

  # ---------------------------------------------------------------------------
  # Get the length of the list (the number of entries)
  # ---------------------------------------------------------------------------

  def count (self):
    return self.__recordset.count ()

  # ---------------------------------------------------------------------------
  # Fetch data from the database backend
  # ---------------------------------------------------------------------------

  def fetch (self, start, count):
    # negative value for start means starting from the end of the list
    if start < 0:
      start = self.count () + start
    result = []
    c = 0
    instance = self.firstInstance ()
    while (instance != None) and (c < start + count):
      if c >= start:
        result.append (instance.get (self.__prefetch))
      c += 1
      instance = self.nextInstance ()
    return result
