# GNU Enterprise Application Server - Gnue Schema Definition Generator
#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: geasGsdGen.py 5384 2004-03-19 20:03:37Z reinhard $

import sys

from gnue.common.apps import i18n
from gnue.common.apps.GClientApp import *

from gnue.appserver import VERSION
from gnue.appserver.geasSessionManager import geasSessionManager 
from gnue.appserver.classrep.SchemaSupport import *
from gnue.appserver.classrep.Namespace import *

# =============================================================================
# Generate GNUe Schema Definition files from appservers class repository 
# =============================================================================

class geasGsdGen (GClientApp):

  NAME    = "geasGsdGen"
  VERSION = VERSION
  COMMAND = "gnue-gsdgen"
  USAGE   = "%s %s" % (GClientApp.USAGE, " [classname] [classname] [...]")
  SUMMARY = _(
"""A tool to create GNUe Schema Definition (gsd) files from 
the appservers class repository.""")

  COMMAND_OPTIONS = [

    ['output', 'o', 'output-file', True, None, "file",
      _('Name of the resulting gsd-file')],

    ['export', 'e', 'export', True, None, "type",
      _('What to export: "schema", "data", "both". Default is "both"')],

    ['database', None, 'database', 1, None, 'name', _(
"""Set the Database to use for loading and storing data to <name>.
gnue-appserver will search for it in connections.conf.""")]]

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------
  def __init__ (self, connections = None):

    ConfigOptions = {}

    GClientApp.__init__ (self, connections, 'appserver', ConfigOptions)

    self.configurationManager.registerAlias ('gConfig', 'appserver')

    # overwrite configuration settings by command line parameters
    cparser = self.configurationManager._loadedConfigs ['gnue.conf']

    if self.OPTIONS ["database"] != None:
      cparser.set ('appserver', 'database', self.OPTIONS ["database"])

  # ---------------------------------------------------------------------------
  # Print a message to stdout, if output is sent to a file
  # ---------------------------------------------------------------------------
  def __message (self, text):
    if self.__filename:
      print text

  # ---------------------------------------------------------------------------
  # Main program
  # ---------------------------------------------------------------------------
  def run (self):
    self.__filename = self.OPTIONS ['output']
    self.__type     = self.OPTIONS ['export']
    args = [unicode (a, i18n.encoding) for a in self.ARGUMENTS]

    self.__message (_("Loading class repository ..."))
    sm = geasSessionManager (self.connections)
    sSupport = SchemaSupport (sm.modules, sm.classes)

    self.__message (_("Generating schema definition ..."))
    try:
      sSupport.writeSchemaToFile (self.__filename, args, self.__type)

    except Exception:
      msg = "%s\n" % str (sys.exc_info () [1])
      sys.stderr.write (msg)
      sys.exit (1)

    self.__message (_("Generation run complete."))

if __name__ == "__main__":
  geasGsdGen ().run ()
