
/* DO NOT EDIT THIS FILE -- it is autogenerated -- edit table.m4 instead */





/* ------------------------------------------------------ */
/* This routine stores/updates one record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in.
 */
void 
pgendStoreOneAccountOnly (PGBackend *be,
                                    Account *ptr,
                                    sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, Account=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncAccount", update);
      sqlBuild_Set_Str (be->builder, "accountName", xaccAccountGetName(ptr));
   sqlBuild_Set_Str (be->builder, "accountCode", xaccAccountGetCode(ptr));
   sqlBuild_Set_Str (be->builder, "description", xaccAccountGetDescription(ptr));
   sqlBuild_Set_Str (be->builder, "type", xaccAccountTypeEnumAsString(xaccAccountGetType(ptr)));
   sqlBuild_Set_Str (be->builder, "commodity", gnc_commodity_get_unique_name(xaccAccountGetCommodity(ptr)));
   sqlBuild_Set_Int32 (be->builder, "version", xaccAccountGetVersion(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Set_GUID (be->builder, "bookGUID", qof_entity_get_guid((QofEntity*)xaccAccountGetBook(ptr)));
   sqlBuild_Set_GUID (be->builder, "parentGUID", xaccAccountGetGUID(xaccAccountGetParentAccount(ptr)));
   sqlBuild_Where_GUID (be->builder, "accountGUID", xaccAccountGetGUID(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores/updates one record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in.
 */
void 
pgendStoreOneBookOnly (PGBackend *be,
                                    QofBook *ptr,
                                    sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, QofBook=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncBook", update);
      sqlBuild_Set_Char (be->builder, "book_open", qof_book_get_open_marker(ptr));
   sqlBuild_Set_Int32 (be->builder, "version", qof_book_get_version(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", qof_book_get_idata(ptr));
   sqlBuild_Where_GUID (be->builder, "bookGUID", qof_book_get_guid(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores/updates one record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in.
 */
void 
pgendStoreOneCommodityOnly (PGBackend *be,
                                    gnc_commodity *ptr,
                                    sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, gnc_commodity=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncCommodity", update);
      sqlBuild_Set_Str (be->builder, "namespace", gnc_commodity_get_namespace(ptr));
   sqlBuild_Set_Str (be->builder, "fullname", gnc_commodity_get_fullname(ptr));
   sqlBuild_Set_Str (be->builder, "mnemonic", gnc_commodity_get_mnemonic(ptr));
   sqlBuild_Set_Str (be->builder, "code", gnc_commodity_get_cusip(ptr));
   sqlBuild_Set_Int32 (be->builder, "fraction", gnc_commodity_get_fraction(ptr));
   sqlBuild_Where_Str (be->builder, "commodity", gnc_commodity_get_unique_name(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores/updates one record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in.
 */
void 
pgendStoreOneSessionOnly (PGBackend *be,
                                    void *ptr,
                                    sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, void=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncSession", update);
      sqlBuild_Set_Str (be->builder, "session_mode", pgendSessionGetMode(be));
   sqlBuild_Set_Str (be->builder, "hostname", pgendGetHostname(be));
   sqlBuild_Set_Str (be->builder, "login_name", pgendGetUsername(be));
   sqlBuild_Set_Str (be->builder, "gecos", pgendGetUserGecos(be));
   sqlBuild_Set_Str (be->builder, "time_on", "NOW");
   sqlBuild_Set_Str (be->builder, "time_off", "INFINITY");
   sqlBuild_Where_GUID (be->builder, "sessionGUID", be->sessionGuid);


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores/updates one record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in.
 */
void 
pgendStoreOneSplitOnly (PGBackend *be,
                                    Split *ptr,
                                    sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, Split=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncSplit", update);
      sqlBuild_Set_GUID (be->builder, "accountGUID", xaccAccountGetGUID(xaccSplitGetAccount(ptr)));
   sqlBuild_Set_GUID (be->builder, "transGUID", xaccTransGetGUID(xaccSplitGetParent(ptr)));
   sqlBuild_Set_Str (be->builder, "memo", xaccSplitGetMemo(ptr));
   sqlBuild_Set_Str (be->builder, "action", xaccSplitGetAction(ptr));
   sqlBuild_Set_Char (be->builder, "reconciled", xaccSplitGetReconcile(ptr));
   sqlBuild_Set_Date (be->builder, "date_reconciled", xaccSplitRetDateReconciledTS(ptr));
   sqlBuild_Set_Int64 (be->builder, "amount", gnc_numeric_num(xaccSplitGetAmount(ptr)));
   sqlBuild_Set_Int64 (be->builder, "value", gnc_numeric_num(xaccSplitGetValue(ptr)));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Where_GUID (be->builder, "splitGuid", xaccSplitGetGUID(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores/updates one record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in.
 */
void 
pgendStoreOneTransactionOnly (PGBackend *be,
                                    Transaction *ptr,
                                    sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, Transaction=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncTransaction", update);
      sqlBuild_Set_Str (be->builder, "num", xaccTransGetNum(ptr));
   sqlBuild_Set_Str (be->builder, "description", xaccTransGetDescription(ptr));
   sqlBuild_Set_Str (be->builder, "currency", gnc_commodity_get_unique_name(xaccTransGetCurrency(ptr)));
   sqlBuild_Set_Str (be->builder, "last_modified", "NOW");
   sqlBuild_Set_Date (be->builder, "date_entered", xaccTransRetDateEnteredTS(ptr));
   sqlBuild_Set_Date (be->builder, "date_posted", xaccTransRetDatePostedTS(ptr));
   sqlBuild_Set_Int32 (be->builder, "version", xaccTransGetVersion(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Where_GUID (be->builder, "transGUID", xaccTransGetGUID(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores/updates one record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in.
 */
void 
pgendStoreOnePriceOnly (PGBackend *be,
                                    GNCPrice *ptr,
                                    sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, GNCPrice=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncPrice", update);
      sqlBuild_Set_Str (be->builder, "commodity", gnc_commodity_get_unique_name(gnc_price_get_commodity(ptr)));
   sqlBuild_Set_Str (be->builder, "currency", gnc_commodity_get_unique_name(gnc_price_get_currency(ptr)));
   sqlBuild_Set_Date (be->builder, "time", gnc_price_get_time(ptr));
   sqlBuild_Set_Str (be->builder, "source", gnc_price_get_source(ptr));
   sqlBuild_Set_Str (be->builder, "type", gnc_price_get_type(ptr));
   sqlBuild_Set_Int64 (be->builder, "valueNum", gnc_numeric_num(gnc_price_get_value(ptr)));
   sqlBuild_Set_Int64 (be->builder, "valueDenom", gnc_numeric_denom(gnc_price_get_value(ptr)));
   sqlBuild_Set_Int32 (be->builder, "version", gnc_price_get_version(ptr));
   sqlBuild_Set_GUID (be->builder, "bookGUID", qof_book_get_guid(gnc_price_get_book(ptr)));
   sqlBuild_Where_GUID (be->builder, "priceGUID", gnc_price_get_guid(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}




/* ------------------------------------------------------ */
/* This routine stores one autdit record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in. 
 */
void 
pgendStoreAuditAccount (PGBackend *be,
                                  Account *ptr,
                                  sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, Account=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncAccount" "Trail", SQL_INSERT);
#define sqlBuild_Where_Str sqlBuild_Set_Str
#define sqlBuild_Where_GUID sqlBuild_Set_GUID
#define sqlBuild_Where_Int32 sqlBuild_Set_Int32
      sqlBuild_Set_Str (be->builder, "accountName", xaccAccountGetName(ptr));
   sqlBuild_Set_Str (be->builder, "accountCode", xaccAccountGetCode(ptr));
   sqlBuild_Set_Str (be->builder, "description", xaccAccountGetDescription(ptr));
   sqlBuild_Set_Str (be->builder, "type", xaccAccountTypeEnumAsString(xaccAccountGetType(ptr)));
   sqlBuild_Set_Str (be->builder, "commodity", gnc_commodity_get_unique_name(xaccAccountGetCommodity(ptr)));
   sqlBuild_Set_Int32 (be->builder, "version", xaccAccountGetVersion(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Set_GUID (be->builder, "bookGUID", qof_entity_get_guid((QofEntity*)xaccAccountGetBook(ptr)));
   sqlBuild_Set_GUID (be->builder, "parentGUID", xaccAccountGetGUID(xaccAccountGetParentAccount(ptr)));
   sqlBuild_Where_GUID (be->builder, "accountGUID", xaccAccountGetGUID(ptr));

#undef sqlBuild_Where_Str
#undef sqlBuild_Where_GUID
#undef sqlBuild_Where_Int32
   sqlBuild_Set_Str (be->builder, "date_changed", "NOW");
   /* sqlBuild_Set_GUID (be->builder, "sessionGUID", be->sessionGuid); */
   sqlBuild_Set_Str (be->builder, "sessionGUID", be->session_guid_str);
   sqlBuild_Set_Char (be->builder, "change", update);
   sqlBuild_Set_Char (be->builder, "objtype", 'a');

   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores one autdit record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in. 
 */
void 
pgendStoreAuditBook (PGBackend *be,
                                  QofBook *ptr,
                                  sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, QofBook=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncBook" "Trail", SQL_INSERT);
#define sqlBuild_Where_Str sqlBuild_Set_Str
#define sqlBuild_Where_GUID sqlBuild_Set_GUID
#define sqlBuild_Where_Int32 sqlBuild_Set_Int32
      sqlBuild_Set_Char (be->builder, "book_open", qof_book_get_open_marker(ptr));
   sqlBuild_Set_Int32 (be->builder, "version", qof_book_get_version(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", qof_book_get_idata(ptr));
   sqlBuild_Where_GUID (be->builder, "bookGUID", qof_book_get_guid(ptr));

#undef sqlBuild_Where_Str
#undef sqlBuild_Where_GUID
#undef sqlBuild_Where_Int32
   sqlBuild_Set_Str (be->builder, "date_changed", "NOW");
   /* sqlBuild_Set_GUID (be->builder, "sessionGUID", be->sessionGuid); */
   sqlBuild_Set_Str (be->builder, "sessionGUID", be->session_guid_str);
   sqlBuild_Set_Char (be->builder, "change", update);
   sqlBuild_Set_Char (be->builder, "objtype", 'b');

   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores one autdit record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in. 
 */
void 
pgendStoreAuditCommodity (PGBackend *be,
                                  gnc_commodity *ptr,
                                  sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, gnc_commodity=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncCommodity" "Trail", SQL_INSERT);
#define sqlBuild_Where_Str sqlBuild_Set_Str
#define sqlBuild_Where_GUID sqlBuild_Set_GUID
#define sqlBuild_Where_Int32 sqlBuild_Set_Int32
      sqlBuild_Set_Str (be->builder, "namespace", gnc_commodity_get_namespace(ptr));
   sqlBuild_Set_Str (be->builder, "fullname", gnc_commodity_get_fullname(ptr));
   sqlBuild_Set_Str (be->builder, "mnemonic", gnc_commodity_get_mnemonic(ptr));
   sqlBuild_Set_Str (be->builder, "code", gnc_commodity_get_cusip(ptr));
   sqlBuild_Set_Int32 (be->builder, "fraction", gnc_commodity_get_fraction(ptr));
   sqlBuild_Where_Str (be->builder, "commodity", gnc_commodity_get_unique_name(ptr));

#undef sqlBuild_Where_Str
#undef sqlBuild_Where_GUID
#undef sqlBuild_Where_Int32
   sqlBuild_Set_Str (be->builder, "date_changed", "NOW");
   /* sqlBuild_Set_GUID (be->builder, "sessionGUID", be->sessionGuid); */
   sqlBuild_Set_Str (be->builder, "sessionGUID", be->session_guid_str);
   sqlBuild_Set_Char (be->builder, "change", update);
   sqlBuild_Set_Char (be->builder, "objtype", 'c');

   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores one autdit record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in. 
 */
void 
pgendStoreAuditSplit (PGBackend *be,
                                  Split *ptr,
                                  sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, Split=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncSplit" "Trail", SQL_INSERT);
#define sqlBuild_Where_Str sqlBuild_Set_Str
#define sqlBuild_Where_GUID sqlBuild_Set_GUID
#define sqlBuild_Where_Int32 sqlBuild_Set_Int32
      sqlBuild_Set_GUID (be->builder, "accountGUID", xaccAccountGetGUID(xaccSplitGetAccount(ptr)));
   sqlBuild_Set_GUID (be->builder, "transGUID", xaccTransGetGUID(xaccSplitGetParent(ptr)));
   sqlBuild_Set_Str (be->builder, "memo", xaccSplitGetMemo(ptr));
   sqlBuild_Set_Str (be->builder, "action", xaccSplitGetAction(ptr));
   sqlBuild_Set_Char (be->builder, "reconciled", xaccSplitGetReconcile(ptr));
   sqlBuild_Set_Date (be->builder, "date_reconciled", xaccSplitRetDateReconciledTS(ptr));
   sqlBuild_Set_Int64 (be->builder, "amount", gnc_numeric_num(xaccSplitGetAmount(ptr)));
   sqlBuild_Set_Int64 (be->builder, "value", gnc_numeric_num(xaccSplitGetValue(ptr)));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Where_GUID (be->builder, "splitGuid", xaccSplitGetGUID(ptr));

#undef sqlBuild_Where_Str
#undef sqlBuild_Where_GUID
#undef sqlBuild_Where_Int32
   sqlBuild_Set_Str (be->builder, "date_changed", "NOW");
   /* sqlBuild_Set_GUID (be->builder, "sessionGUID", be->sessionGuid); */
   sqlBuild_Set_Str (be->builder, "sessionGUID", be->session_guid_str);
   sqlBuild_Set_Char (be->builder, "change", update);
   sqlBuild_Set_Char (be->builder, "objtype", 'e');

   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores one autdit record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in. 
 */
void 
pgendStoreAuditTransaction (PGBackend *be,
                                  Transaction *ptr,
                                  sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, Transaction=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncTransaction" "Trail", SQL_INSERT);
#define sqlBuild_Where_Str sqlBuild_Set_Str
#define sqlBuild_Where_GUID sqlBuild_Set_GUID
#define sqlBuild_Where_Int32 sqlBuild_Set_Int32
      sqlBuild_Set_Str (be->builder, "num", xaccTransGetNum(ptr));
   sqlBuild_Set_Str (be->builder, "description", xaccTransGetDescription(ptr));
   sqlBuild_Set_Str (be->builder, "currency", gnc_commodity_get_unique_name(xaccTransGetCurrency(ptr)));
   sqlBuild_Set_Str (be->builder, "last_modified", "NOW");
   sqlBuild_Set_Date (be->builder, "date_entered", xaccTransRetDateEnteredTS(ptr));
   sqlBuild_Set_Date (be->builder, "date_posted", xaccTransRetDatePostedTS(ptr));
   sqlBuild_Set_Int32 (be->builder, "version", xaccTransGetVersion(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Where_GUID (be->builder, "transGUID", xaccTransGetGUID(ptr));

#undef sqlBuild_Where_Str
#undef sqlBuild_Where_GUID
#undef sqlBuild_Where_Int32
   sqlBuild_Set_Str (be->builder, "date_changed", "NOW");
   /* sqlBuild_Set_GUID (be->builder, "sessionGUID", be->sessionGuid); */
   sqlBuild_Set_Str (be->builder, "sessionGUID", be->session_guid_str);
   sqlBuild_Set_Char (be->builder, "change", update);
   sqlBuild_Set_Char (be->builder, "objtype", 't');

   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}



/* ------------------------------------------------------ */
/* This routine stores one autdit record in the database.
 * It does not do any traversals, it does not lock.  
 * It just pokes the data in. 
 */
void 
pgendStoreAuditPrice (PGBackend *be,
                                  GNCPrice *ptr,
                                  sqlBuild_QType update)
{
   const char *buf;
   ENTER ("be=%p, GNCPrice=%p", be, ptr);
   if (!be || !ptr) return;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncPrice" "Trail", SQL_INSERT);
#define sqlBuild_Where_Str sqlBuild_Set_Str
#define sqlBuild_Where_GUID sqlBuild_Set_GUID
#define sqlBuild_Where_Int32 sqlBuild_Set_Int32
      sqlBuild_Set_Str (be->builder, "commodity", gnc_commodity_get_unique_name(gnc_price_get_commodity(ptr)));
   sqlBuild_Set_Str (be->builder, "currency", gnc_commodity_get_unique_name(gnc_price_get_currency(ptr)));
   sqlBuild_Set_Date (be->builder, "time", gnc_price_get_time(ptr));
   sqlBuild_Set_Str (be->builder, "source", gnc_price_get_source(ptr));
   sqlBuild_Set_Str (be->builder, "type", gnc_price_get_type(ptr));
   sqlBuild_Set_Int64 (be->builder, "valueNum", gnc_numeric_num(gnc_price_get_value(ptr)));
   sqlBuild_Set_Int64 (be->builder, "valueDenom", gnc_numeric_denom(gnc_price_get_value(ptr)));
   sqlBuild_Set_Int32 (be->builder, "version", gnc_price_get_version(ptr));
   sqlBuild_Set_GUID (be->builder, "bookGUID", qof_book_get_guid(gnc_price_get_book(ptr)));
   sqlBuild_Where_GUID (be->builder, "priceGUID", gnc_price_get_guid(ptr));

#undef sqlBuild_Where_Str
#undef sqlBuild_Where_GUID
#undef sqlBuild_Where_Int32
   sqlBuild_Set_Str (be->builder, "date_changed", "NOW");
   /* sqlBuild_Set_GUID (be->builder, "sessionGUID", be->sessionGuid); */
   sqlBuild_Set_Str (be->builder, "sessionGUID", be->session_guid_str);
   sqlBuild_Set_Char (be->builder, "change", update);
   sqlBuild_Set_Char (be->builder, "objtype", 'p');

   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, );

   /* flush the buffers, check the status */
   FINISH_QUERY(be->connection);
   LEAVE (" ");
}




/* ------------------------------------------------------ */
/* This routine returns a positive int if the indicated object
 * differs from that in the SQL database.  It returns negative
 * number if theres an error.
 * It does not do any traversals, it does not lock.  
 */
int
pgendCompareOneAccountOnly (PGBackend *be, Account *ptr)
{
   const char *buf;
   PGresult *result;
   int i=0, nrows=0, ndiffs=0;

   ENTER ("be=%p, Account=%p", be, ptr);
   if (!be || !ptr) return -1;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncAccount", SQL_SELECT);
      sqlBuild_Set_Str (be->builder, "accountName", xaccAccountGetName(ptr));
   sqlBuild_Set_Str (be->builder, "accountCode", xaccAccountGetCode(ptr));
   sqlBuild_Set_Str (be->builder, "description", xaccAccountGetDescription(ptr));
   sqlBuild_Set_Str (be->builder, "type", xaccAccountTypeEnumAsString(xaccAccountGetType(ptr)));
   sqlBuild_Set_Str (be->builder, "commodity", gnc_commodity_get_unique_name(xaccAccountGetCommodity(ptr)));
   sqlBuild_Set_Int32 (be->builder, "version", xaccAccountGetVersion(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Set_GUID (be->builder, "bookGUID", qof_entity_get_guid((QofEntity*)xaccAccountGetBook(ptr)));
   sqlBuild_Set_GUID (be->builder, "parentGUID", xaccAccountGetGUID(xaccAccountGetParentAccount(ptr)));
   sqlBuild_Where_GUID (be->builder, "accountGUID", xaccAccountGetGUID(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, -1);

   i=0; nrows=0;
   do {
      GET_RESULTS (be->connection, result);
      IF_ONE_ROW (result, nrows, i) {

         /* Compare queried values to input values. */
             COMP_STR ("accountName", xaccAccountGetName(ptr), ndiffs);
    COMP_STR ("accountCode", xaccAccountGetCode(ptr), ndiffs);
    COMP_STR ("description", xaccAccountGetDescription(ptr), ndiffs);
    COMP_STR ("type", xaccAccountTypeEnumAsString(xaccAccountGetType(ptr)), ndiffs);
    COMP_STR ("commodity", gnc_commodity_get_unique_name(xaccAccountGetCommodity(ptr)), ndiffs);
    COMP_INT32 ("version", xaccAccountGetVersion(ptr), ndiffs);
    COMP_INT32 ("iguid", ptr->idata, ndiffs);
    COMP_GUID ("bookGUID", qof_entity_get_guid((QofEntity*)xaccAccountGetBook(ptr)), ndiffs);
    COMP_GUID ("parentGUID", xaccAccountGetGUID(xaccAccountGetParentAccount(ptr)), ndiffs);

      }

      PQclear (result);
      i++;
   } while (result);

   if (0 == nrows) ndiffs = -1;
   LEAVE ("ndiffs=%d", ndiffs);
   return ndiffs;
}



/* ------------------------------------------------------ */
/* This routine returns a positive int if the indicated object
 * differs from that in the SQL database.  It returns negative
 * number if theres an error.
 * It does not do any traversals, it does not lock.  
 */
int
pgendCompareOneBookOnly (PGBackend *be, QofBook *ptr)
{
   const char *buf;
   PGresult *result;
   int i=0, nrows=0, ndiffs=0;

   ENTER ("be=%p, QofBook=%p", be, ptr);
   if (!be || !ptr) return -1;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncBook", SQL_SELECT);
      sqlBuild_Set_Char (be->builder, "book_open", qof_book_get_open_marker(ptr));
   sqlBuild_Set_Int32 (be->builder, "version", qof_book_get_version(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", qof_book_get_idata(ptr));
   sqlBuild_Where_GUID (be->builder, "bookGUID", qof_book_get_guid(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, -1);

   i=0; nrows=0;
   do {
      GET_RESULTS (be->connection, result);
      IF_ONE_ROW (result, nrows, i) {

         /* Compare queried values to input values. */
             COMP_CHAR ("book_open", qof_book_get_open_marker(ptr), ndiffs);
    COMP_INT32 ("version", qof_book_get_version(ptr), ndiffs);
    COMP_INT32 ("iguid", qof_book_get_idata(ptr), ndiffs);

      }

      PQclear (result);
      i++;
   } while (result);

   if (0 == nrows) ndiffs = -1;
   LEAVE ("ndiffs=%d", ndiffs);
   return ndiffs;
}



/* ------------------------------------------------------ */
/* This routine returns a positive int if the indicated object
 * differs from that in the SQL database.  It returns negative
 * number if theres an error.
 * It does not do any traversals, it does not lock.  
 */
int
pgendCompareOneCommodityOnly (PGBackend *be, gnc_commodity *ptr)
{
   const char *buf;
   PGresult *result;
   int i=0, nrows=0, ndiffs=0;

   ENTER ("be=%p, gnc_commodity=%p", be, ptr);
   if (!be || !ptr) return -1;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncCommodity", SQL_SELECT);
      sqlBuild_Set_Str (be->builder, "namespace", gnc_commodity_get_namespace(ptr));
   sqlBuild_Set_Str (be->builder, "fullname", gnc_commodity_get_fullname(ptr));
   sqlBuild_Set_Str (be->builder, "mnemonic", gnc_commodity_get_mnemonic(ptr));
   sqlBuild_Set_Str (be->builder, "code", gnc_commodity_get_cusip(ptr));
   sqlBuild_Set_Int32 (be->builder, "fraction", gnc_commodity_get_fraction(ptr));
   sqlBuild_Where_Str (be->builder, "commodity", gnc_commodity_get_unique_name(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, -1);

   i=0; nrows=0;
   do {
      GET_RESULTS (be->connection, result);
      IF_ONE_ROW (result, nrows, i) {

         /* Compare queried values to input values. */
             COMP_STR ("namespace", gnc_commodity_get_namespace(ptr), ndiffs);
    COMP_STR ("fullname", gnc_commodity_get_fullname(ptr), ndiffs);
    COMP_STR ("mnemonic", gnc_commodity_get_mnemonic(ptr), ndiffs);
    COMP_STR ("code", gnc_commodity_get_cusip(ptr), ndiffs);
    COMP_INT32 ("fraction", gnc_commodity_get_fraction(ptr), ndiffs);

      }

      PQclear (result);
      i++;
   } while (result);

   if (0 == nrows) ndiffs = -1;
   LEAVE ("ndiffs=%d", ndiffs);
   return ndiffs;
}



/* ------------------------------------------------------ */
/* This routine returns a positive int if the indicated object
 * differs from that in the SQL database.  It returns negative
 * number if theres an error.
 * It does not do any traversals, it does not lock.  
 */
int
pgendCompareOneSplitOnly (PGBackend *be, Split *ptr)
{
   const char *buf;
   PGresult *result;
   int i=0, nrows=0, ndiffs=0;

   ENTER ("be=%p, Split=%p", be, ptr);
   if (!be || !ptr) return -1;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncSplit", SQL_SELECT);
      sqlBuild_Set_GUID (be->builder, "accountGUID", xaccAccountGetGUID(xaccSplitGetAccount(ptr)));
   sqlBuild_Set_GUID (be->builder, "transGUID", xaccTransGetGUID(xaccSplitGetParent(ptr)));
   sqlBuild_Set_Str (be->builder, "memo", xaccSplitGetMemo(ptr));
   sqlBuild_Set_Str (be->builder, "action", xaccSplitGetAction(ptr));
   sqlBuild_Set_Char (be->builder, "reconciled", xaccSplitGetReconcile(ptr));
   sqlBuild_Set_Date (be->builder, "date_reconciled", xaccSplitRetDateReconciledTS(ptr));
   sqlBuild_Set_Int64 (be->builder, "amount", gnc_numeric_num(xaccSplitGetAmount(ptr)));
   sqlBuild_Set_Int64 (be->builder, "value", gnc_numeric_num(xaccSplitGetValue(ptr)));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Where_GUID (be->builder, "splitGuid", xaccSplitGetGUID(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, -1);

   i=0; nrows=0;
   do {
      GET_RESULTS (be->connection, result);
      IF_ONE_ROW (result, nrows, i) {

         /* Compare queried values to input values. */
             COMP_GUID ("accountGUID", xaccAccountGetGUID(xaccSplitGetAccount(ptr)), ndiffs);
    COMP_GUID ("transGUID", xaccTransGetGUID(xaccSplitGetParent(ptr)), ndiffs);
    COMP_STR ("memo", xaccSplitGetMemo(ptr), ndiffs);
    COMP_STR ("action", xaccSplitGetAction(ptr), ndiffs);
    COMP_CHAR ("reconciled", xaccSplitGetReconcile(ptr), ndiffs);
    COMP_DATE ("date_reconciled", xaccSplitRetDateReconciledTS(ptr), ndiffs);
    COMP_INT64 ("amount", gnc_numeric_num(xaccSplitGetAmount(ptr)), ndiffs);
    COMP_INT64 ("value", gnc_numeric_num(xaccSplitGetValue(ptr)), ndiffs);
    COMP_INT32 ("iguid", ptr->idata, ndiffs);

      }

      PQclear (result);
      i++;
   } while (result);

   if (0 == nrows) ndiffs = -1;
   LEAVE ("ndiffs=%d", ndiffs);
   return ndiffs;
}



/* ------------------------------------------------------ */
/* This routine returns a positive int if the indicated object
 * differs from that in the SQL database.  It returns negative
 * number if theres an error.
 * It does not do any traversals, it does not lock.  
 */
int
pgendCompareOneTransactionOnly (PGBackend *be, Transaction *ptr)
{
   const char *buf;
   PGresult *result;
   int i=0, nrows=0, ndiffs=0;

   ENTER ("be=%p, Transaction=%p", be, ptr);
   if (!be || !ptr) return -1;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncTransaction", SQL_SELECT);
      sqlBuild_Set_Str (be->builder, "num", xaccTransGetNum(ptr));
   sqlBuild_Set_Str (be->builder, "description", xaccTransGetDescription(ptr));
   sqlBuild_Set_Str (be->builder, "currency", gnc_commodity_get_unique_name(xaccTransGetCurrency(ptr)));
   sqlBuild_Set_Str (be->builder, "last_modified", "NOW");
   sqlBuild_Set_Date (be->builder, "date_entered", xaccTransRetDateEnteredTS(ptr));
   sqlBuild_Set_Date (be->builder, "date_posted", xaccTransRetDatePostedTS(ptr));
   sqlBuild_Set_Int32 (be->builder, "version", xaccTransGetVersion(ptr));
   sqlBuild_Set_Int32 (be->builder, "iguid", ptr->idata);
   sqlBuild_Where_GUID (be->builder, "transGUID", xaccTransGetGUID(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, -1);

   i=0; nrows=0;
   do {
      GET_RESULTS (be->connection, result);
      IF_ONE_ROW (result, nrows, i) {

         /* Compare queried values to input values. */
             COMP_STR ("num", xaccTransGetNum(ptr), ndiffs);
    COMP_STR ("description", xaccTransGetDescription(ptr), ndiffs);
    COMP_COMMODITY ("currency", gnc_commodity_get_unique_name(xaccTransGetCurrency(ptr)), ndiffs);
    COMP_NOW ("last_modified", "NOW", ndiffs);
    COMP_DATE ("date_entered", xaccTransRetDateEnteredTS(ptr), ndiffs);
    COMP_DATE ("date_posted", xaccTransRetDatePostedTS(ptr), ndiffs);
    COMP_INT32 ("version", xaccTransGetVersion(ptr), ndiffs);
    COMP_INT32 ("iguid", ptr->idata, ndiffs);

      }

      PQclear (result);
      i++;
   } while (result);

   if (0 == nrows) ndiffs = -1;
   LEAVE ("ndiffs=%d", ndiffs);
   return ndiffs;
}



/* ------------------------------------------------------ */
/* This routine returns a positive int if the indicated object
 * differs from that in the SQL database.  It returns negative
 * number if theres an error.
 * It does not do any traversals, it does not lock.  
 */
int
pgendCompareOnePriceOnly (PGBackend *be, GNCPrice *ptr)
{
   const char *buf;
   PGresult *result;
   int i=0, nrows=0, ndiffs=0;

   ENTER ("be=%p, GNCPrice=%p", be, ptr);
   if (!be || !ptr) return -1;

   /* build the sql query */
   sqlBuild_Table (be->builder, "gncPrice", SQL_SELECT);
      sqlBuild_Set_Str (be->builder, "commodity", gnc_commodity_get_unique_name(gnc_price_get_commodity(ptr)));
   sqlBuild_Set_Str (be->builder, "currency", gnc_commodity_get_unique_name(gnc_price_get_currency(ptr)));
   sqlBuild_Set_Date (be->builder, "time", gnc_price_get_time(ptr));
   sqlBuild_Set_Str (be->builder, "source", gnc_price_get_source(ptr));
   sqlBuild_Set_Str (be->builder, "type", gnc_price_get_type(ptr));
   sqlBuild_Set_Int64 (be->builder, "valueNum", gnc_numeric_num(gnc_price_get_value(ptr)));
   sqlBuild_Set_Int64 (be->builder, "valueDenom", gnc_numeric_denom(gnc_price_get_value(ptr)));
   sqlBuild_Set_Int32 (be->builder, "version", gnc_price_get_version(ptr));
   sqlBuild_Set_GUID (be->builder, "bookGUID", qof_book_get_guid(gnc_price_get_book(ptr)));
   sqlBuild_Where_GUID (be->builder, "priceGUID", gnc_price_get_guid(ptr));


   buf = sqlBuild_Query (be->builder);
   SEND_QUERY (be,buf, -1);

   i=0; nrows=0;
   do {
      GET_RESULTS (be->connection, result);
      IF_ONE_ROW (result, nrows, i) {

         /* Compare queried values to input values. */
             COMP_COMMODITY ("commodity", gnc_commodity_get_unique_name(gnc_price_get_commodity(ptr)), ndiffs);
    COMP_COMMODITY ("currency", gnc_commodity_get_unique_name(gnc_price_get_currency(ptr)), ndiffs);
    COMP_DATE ("time", gnc_price_get_time(ptr), ndiffs);
    COMP_STR ("source", gnc_price_get_source(ptr), ndiffs);
    COMP_STR ("type", gnc_price_get_type(ptr), ndiffs);
    COMP_INT64 ("valueNum", gnc_numeric_num(gnc_price_get_value(ptr)), ndiffs);
    COMP_INT64 ("valueDenom", gnc_numeric_denom(gnc_price_get_value(ptr)), ndiffs);
    COMP_INT32 ("version", gnc_price_get_version(ptr), ndiffs);
    COMP_GUID ("bookGUID", qof_book_get_guid(gnc_price_get_book(ptr)), ndiffs);

      }

      PQclear (result);
      i++;
   } while (result);

   if (0 == nrows) ndiffs = -1;
   LEAVE ("ndiffs=%d", ndiffs);
   return ndiffs;
}




/* ------------------------------------------------------ */
/* This routine inserts or updates, as appropriate
 * It does not do any traversals, it does not lock.  
 * It just updates.
 */
void 
pgendPutOneAccountOnly (PGBackend *be, Account *ptr)
{
   int ndiffs;
   ndiffs = pgendCompareOneAccountOnly (be, ptr);

   /* update the record if there are differences ... */
   if (0<ndiffs) 
   {
      pgendStoreOneAccountOnly (be, ptr, SQL_UPDATE);
      pgendStoreAuditAccount (be, ptr, SQL_UPDATE);
   }
   /* insert the record if it doesnt exist */
   if (0>ndiffs)
   {
      pgendStoreOneAccountOnly (be, ptr, SQL_INSERT);
      pgendStoreAuditAccount (be, ptr, SQL_INSERT);
   }
}



/* ------------------------------------------------------ */
/* This routine inserts or updates, as appropriate
 * It does not do any traversals, it does not lock.  
 * It just updates.
 */
void 
pgendPutOneBookOnly (PGBackend *be, QofBook *ptr)
{
   int ndiffs;
   ndiffs = pgendCompareOneBookOnly (be, ptr);

   /* update the record if there are differences ... */
   if (0<ndiffs) 
   {
      pgendStoreOneBookOnly (be, ptr, SQL_UPDATE);
      pgendStoreAuditBook (be, ptr, SQL_UPDATE);
   }
   /* insert the record if it doesnt exist */
   if (0>ndiffs)
   {
      pgendStoreOneBookOnly (be, ptr, SQL_INSERT);
      pgendStoreAuditBook (be, ptr, SQL_INSERT);
   }
}



/* ------------------------------------------------------ */
/* This routine inserts or updates, as appropriate
 * It does not do any traversals, it does not lock.  
 * It just updates.
 */
void 
pgendPutOneCommodityOnly (PGBackend *be, gnc_commodity *ptr)
{
   int ndiffs;
   ndiffs = pgendCompareOneCommodityOnly (be, ptr);

   /* update the record if there are differences ... */
   if (0<ndiffs) 
   {
      pgendStoreOneCommodityOnly (be, ptr, SQL_UPDATE);
      pgendStoreAuditCommodity (be, ptr, SQL_UPDATE);
   }
   /* insert the record if it doesnt exist */
   if (0>ndiffs)
   {
      pgendStoreOneCommodityOnly (be, ptr, SQL_INSERT);
      pgendStoreAuditCommodity (be, ptr, SQL_INSERT);
   }
}



/* ------------------------------------------------------ */
/* This routine inserts or updates, as appropriate
 * It does not do any traversals, it does not lock.  
 * It just updates.
 */
void 
pgendPutOneSplitOnly (PGBackend *be, Split *ptr)
{
   int ndiffs;
   ndiffs = pgendCompareOneSplitOnly (be, ptr);

   /* update the record if there are differences ... */
   if (0<ndiffs) 
   {
      pgendStoreOneSplitOnly (be, ptr, SQL_UPDATE);
      pgendStoreAuditSplit (be, ptr, SQL_UPDATE);
   }
   /* insert the record if it doesnt exist */
   if (0>ndiffs)
   {
      pgendStoreOneSplitOnly (be, ptr, SQL_INSERT);
      pgendStoreAuditSplit (be, ptr, SQL_INSERT);
   }
}



/* ------------------------------------------------------ */
/* This routine inserts or updates, as appropriate
 * It does not do any traversals, it does not lock.  
 * It just updates.
 */
void 
pgendPutOneTransactionOnly (PGBackend *be, Transaction *ptr)
{
   int ndiffs;
   ndiffs = pgendCompareOneTransactionOnly (be, ptr);

   /* update the record if there are differences ... */
   if (0<ndiffs) 
   {
      pgendStoreOneTransactionOnly (be, ptr, SQL_UPDATE);
      pgendStoreAuditTransaction (be, ptr, SQL_UPDATE);
   }
   /* insert the record if it doesnt exist */
   if (0>ndiffs)
   {
      pgendStoreOneTransactionOnly (be, ptr, SQL_INSERT);
      pgendStoreAuditTransaction (be, ptr, SQL_INSERT);
   }
}



/* ------------------------------------------------------ */
/* This routine inserts or updates, as appropriate
 * It does not do any traversals, it does not lock.  
 * It just updates.
 */
void 
pgendPutOnePriceOnly (PGBackend *be, GNCPrice *ptr)
{
   int ndiffs;
   ndiffs = pgendCompareOnePriceOnly (be, ptr);

   /* update the record if there are differences ... */
   if (0<ndiffs) 
   {
      pgendStoreOnePriceOnly (be, ptr, SQL_UPDATE);
      pgendStoreAuditPrice (be, ptr, SQL_UPDATE);
   }
   /* insert the record if it doesnt exist */
   if (0>ndiffs)
   {
      pgendStoreOnePriceOnly (be, ptr, SQL_INSERT);
      pgendStoreAuditPrice (be, ptr, SQL_INSERT);
   }
}




/* ------------------------------------------------------ */
/* This routine compares the version number of the object in 
 * the engine and the sql database. It returns a negative 
 * number if the sql version is older (or the item is not 
 * present in the sql db). It returns a positive number
 * if the sql version is newer.  It returns zero if the
 * two are equal.
 */
int 
pgendAccountCompareVersion (PGBackend *be, Account *ptr)
{
   char *p;
   int sql_version = 0;

   p = be->buff; *p = 0;
   p = stpcpy (p, "SELECT version FROM gncAccount WHERE accountGUID = '");
   p = guid_to_string_buff (qof_entity_get_guid(QOF_ENTITY(ptr)), p);
   p = stpcpy (p, "';");
   SEND_QUERY (be,be->buff, -1);
   sql_version = GPOINTER_TO_INT(pgendGetResults (be, get_version_cb, (gpointer) -1));

   if (-1 == sql_version) return -1;
   return (sql_version - xaccAccountGetVersion(ptr));
}



/* ------------------------------------------------------ */
/* This routine compares the version number of the object in 
 * the engine and the sql database. It returns a negative 
 * number if the sql version is older (or the item is not 
 * present in the sql db). It returns a positive number
 * if the sql version is newer.  It returns zero if the
 * two are equal.
 */
int 
pgendBookCompareVersion (PGBackend *be, QofBook *ptr)
{
   char *p;
   int sql_version = 0;

   p = be->buff; *p = 0;
   p = stpcpy (p, "SELECT version FROM gncBook WHERE bookGUID = '");
   p = guid_to_string_buff (qof_entity_get_guid(QOF_ENTITY(ptr)), p);
   p = stpcpy (p, "';");
   SEND_QUERY (be,be->buff, -1);
   sql_version = GPOINTER_TO_INT(pgendGetResults (be, get_version_cb, (gpointer) -1));

   if (-1 == sql_version) return -1;
   return (sql_version - qof_book_get_version(ptr));
}



/* ------------------------------------------------------ */
/* This routine compares the version number of the object in 
 * the engine and the sql database. It returns a negative 
 * number if the sql version is older (or the item is not 
 * present in the sql db). It returns a positive number
 * if the sql version is newer.  It returns zero if the
 * two are equal.
 */
int 
pgendTransactionCompareVersion (PGBackend *be, Transaction *ptr)
{
   char *p;
   int sql_version = 0;

   p = be->buff; *p = 0;
   p = stpcpy (p, "SELECT version FROM gncTransaction WHERE transGUID = '");
   p = guid_to_string_buff (qof_entity_get_guid(QOF_ENTITY(ptr)), p);
   p = stpcpy (p, "';");
   SEND_QUERY (be,be->buff, -1);
   sql_version = GPOINTER_TO_INT(pgendGetResults (be, get_version_cb, (gpointer) -1));

   if (-1 == sql_version) return -1;
   return (sql_version - xaccTransGetVersion(ptr));
}



/* ------------------------------------------------------ */
/* This routine compares the version number of the object in 
 * the engine and the sql database. It returns a negative 
 * number if the sql version is older (or the item is not 
 * present in the sql db). It returns a positive number
 * if the sql version is newer.  It returns zero if the
 * two are equal.
 */
int 
pgendPriceCompareVersion (PGBackend *be, GNCPrice *ptr)
{
   char *p;
   int sql_version = 0;

   p = be->buff; *p = 0;
   p = stpcpy (p, "SELECT version FROM gncPrice WHERE priceGUID = '");
   p = guid_to_string_buff (qof_entity_get_guid(QOF_ENTITY(ptr)), p);
   p = stpcpy (p, "';");
   SEND_QUERY (be,be->buff, -1);
   sql_version = GPOINTER_TO_INT(pgendGetResults (be, get_version_cb, (gpointer) -1));

   if (-1 == sql_version) return -1;
   return (sql_version - gnc_price_get_version(ptr));
}




/* ------------------------------------------------------ */
/* This routine looks at the audit trail to see if the
 * indicated object has been deleted. If it has been,
 * it returns the version number of the deleted object;
 * otherwise it returns -1.
 */ 
int
pgendAccountGetDeletedVersion (PGBackend *be, Account *ptr)
{
   char *p;
   int sql_version = -1;

   p = be->buff; *p = 0;
   p = stpcpy (p, "SELECT version FROM gncAccount" "Trail WHERE accountGUID = '");
   p = guid_to_string_buff (qof_entity_get_guid(QOF_ENTITY(ptr)), p);
   p = stpcpy (p, "' AND change = 'd';");
   SEND_QUERY (be,be->buff, -1);
   sql_version = GPOINTER_TO_INT(pgendGetResults (be, get_version_cb, (gpointer) -1));

   return sql_version;
}



/* ------------------------------------------------------ */
/* This routine looks at the audit trail to see if the
 * indicated object has been deleted. If it has been,
 * it returns the version number of the deleted object;
 * otherwise it returns -1.
 */ 
int
pgendBookGetDeletedVersion (PGBackend *be, QofBook *ptr)
{
   char *p;
   int sql_version = -1;

   p = be->buff; *p = 0;
   p = stpcpy (p, "SELECT version FROM gncBook" "Trail WHERE bookGUID = '");
   p = guid_to_string_buff (qof_entity_get_guid(QOF_ENTITY(ptr)), p);
   p = stpcpy (p, "' AND change = 'd';");
   SEND_QUERY (be,be->buff, -1);
   sql_version = GPOINTER_TO_INT(pgendGetResults (be, get_version_cb, (gpointer) -1));

   return sql_version;
}



/* ------------------------------------------------------ */
/* This routine looks at the audit trail to see if the
 * indicated object has been deleted. If it has been,
 * it returns the version number of the deleted object;
 * otherwise it returns -1.
 */ 
int
pgendTransactionGetDeletedVersion (PGBackend *be, Transaction *ptr)
{
   char *p;
   int sql_version = -1;

   p = be->buff; *p = 0;
   p = stpcpy (p, "SELECT version FROM gncTransaction" "Trail WHERE transGUID = '");
   p = guid_to_string_buff (qof_entity_get_guid(QOF_ENTITY(ptr)), p);
   p = stpcpy (p, "' AND change = 'd';");
   SEND_QUERY (be,be->buff, -1);
   sql_version = GPOINTER_TO_INT(pgendGetResults (be, get_version_cb, (gpointer) -1));

   return sql_version;
}



/* ------------------------------------------------------ */
/* This routine looks at the audit trail to see if the
 * indicated object has been deleted. If it has been,
 * it returns the version number of the deleted object;
 * otherwise it returns -1.
 */ 
int
pgendPriceGetDeletedVersion (PGBackend *be, GNCPrice *ptr)
{
   char *p;
   int sql_version = -1;

   p = be->buff; *p = 0;
   p = stpcpy (p, "SELECT version FROM gncPrice" "Trail WHERE priceGUID = '");
   p = guid_to_string_buff (qof_entity_get_guid(QOF_ENTITY(ptr)), p);
   p = stpcpy (p, "' AND change = 'd';");
   SEND_QUERY (be,be->buff, -1);
   sql_version = GPOINTER_TO_INT(pgendGetResults (be, get_version_cb, (gpointer) -1));

   return sql_version;
}


