/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanui.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gtk/gtk.h>
#include "gnomescanui.h"
#include "gnomescanui-intl.h"

void		gsui_init_stock			(void);

/**
 * gnome_scan_ui_init:
 * 
 * Init GnomeScan UI translation and icons.
 **/
void
gnome_scan_ui_init ()
{
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);  
  gsui_init_stock ();
}

void
gsui_init_stock ()
{
  GtkIconFactory *factory;
  GtkIconSet *set;
  GtkIconSource *source;
  gchar *filename;
  gint i, n_stocks;

  /* GLOBAL GNOMESCANUI INIT */
  /* something that my not reside here, but where else ? */
  gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (),
				     ICONDIR);

  gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (),
				     LOGOSDIR);

  static const GtkStockItem stocks[] = {
    { "rotate-90",
      /* rotate left, counter clockwise */
      N_("Left"),
      0,
      0,
      GETTEXT_PACKAGE },
    { "rotate-270",
      /* rotate right, clockwise */
      N_("Right"),
      0,
      0,
      GETTEXT_PACKAGE },
    { "scan",
      N_("_Scan"),
      0,
      0,
      GETTEXT_PACKAGE },
    {
      "do-next",
      N_("_Next"),
      0,
      0,
      GETTEXT_PACKAGE },
    {
      "vchain",
      N_("Dependent"),
      0,
      0,
      GETTEXT_PACKAGE },
    {
      "vchain-broken",
      N_("Independent"),
      0,
      0,
      GETTEXT_PACKAGE }
  };

  n_stocks = G_N_ELEMENTS (stocks);

  gtk_stock_add_static (stocks, n_stocks);

  factory = gtk_icon_factory_new ();

  /* SVGS */
  for (i = 0; i < n_stocks - 2; i++) {
    set = gtk_icon_set_new ();
    source = gtk_icon_source_new ();
    filename = g_strconcat (ICONDIR, "/stock_", stocks[i].stock_id, ".svg", NULL);
    gtk_icon_source_set_filename (source, filename);
    gtk_icon_source_set_direction_wildcarded (source, TRUE);
    gtk_icon_source_set_size_wildcarded (source, TRUE);
    gtk_icon_source_set_state_wildcarded (source, TRUE);

    gtk_icon_set_add_source (set, source);

    gtk_icon_factory_add (factory,
			  stocks[i].stock_id,
			  set);
  }

  /* PNGS */
  for (i = n_stocks - 2; i < n_stocks; i++) {
    set = gtk_icon_set_new ();
    source = gtk_icon_source_new ();
    filename = g_strconcat (ICONDIR, "/stock_", stocks[i].stock_id, ".png", NULL);
    gtk_icon_source_set_filename (source, filename);
    gtk_icon_source_set_direction_wildcarded (source, TRUE);
    gtk_icon_source_set_state_wildcarded (source, TRUE);

    gtk_icon_set_add_source (set, source);

    gtk_icon_factory_add (factory,
			  stocks[i].stock_id,
			  set);
  }

  gtk_icon_factory_add_default (factory);
}
