#ifndef GNOME_HELPER_H
#define GNOME_HELPER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef WITH_GNOME
# include <gnome.h>
#else
# include <gtk/gtk.h>

#  define LIBGNOMEUI_MODULE NULL


  typedef struct {
      GObject object;

      void *_priv;
  } GnomeProgram;

/* might deserve problems when included in more than one module */

  inline GnomeProgram* gnome_program_init (const char *app_id,
					   const char *app_version,
					   const void *module_info,
					   int argc,
					   char **argv,
					   const char *first_property_name,
					   ...)
  {
    gtk_init(&argc, &argv);
    return NULL;
  }

/* alternative, even more hacky macro  ;-) */

/*
  #define gnome_program_init(app_id, app_version,\
			     module_info, argc,\
			     argv, vargs...) NULL;gtk_init(&argc, &argv)
*/
#endif



#endif /* GNOME_HELPER_H */
