/* puzzle-view.c generated by valac 0.38.0.11-8bd7f, the Vala compiler
 * generated from puzzle-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;
typedef struct _PuzzleViewPrivate PuzzleViewPrivate;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
enum  {
	PUZZLE_VIEW_DUMMY_PROPERTY,
	PUZZLE_VIEW_PUZZLE_PROPERTY,
	PUZZLE_VIEW_LAST_PROPERTY
};
static GParamSpec* puzzle_view_properties[PUZZLE_VIEW_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;

struct _PuzzleView {
	GtkDrawingArea parent_instance;
	PuzzleViewPrivate * priv;
};

struct _PuzzleViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _PuzzleViewPrivate {
	gint render_size;
	gint piece_x;
	gint piece_y;
	gboolean piece_unmoved;
	gchar _piece_id;
	gchar last_piece_id;
	gdouble kx;
	gdouble ky;
	RsvgHandle* tiles_handle;
	gchar* image_filepath;
	cairo_surface_t* surface;
	Puzzle* _puzzle;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer puzzle_view_parent_class = NULL;

GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
#define PUZZLE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PUZZLE_VIEW, PuzzleViewPrivate))
#define PUZZLE_VIEW_SPACE_OFFSET 4
#define PUZZLE_VIEW_SPACE_PADDING 5
#define PUZZLE_VIEW_THEME_OVERLAY_SIZE 8
#define PUZZLE_VIEW_THEME_TILE_SEGMENTS 27
#define PUZZLE_VIEW_THEME_TILE_CENTER 14
#define PUZZLE_VIEW_THEME_TILE_SIZE 34
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void puzzle_view_load_image (PuzzleView* self);
static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr);
static gint puzzle_view_get_tile_size (PuzzleView* self);
Puzzle* puzzle_view_get_puzzle (PuzzleView* self);
static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky);
static gchar puzzle_view_get_piece_id (PuzzleView* self);
gchar puzzle_get_piece_id (Puzzle* self, gchar* src, int src_length1, gint x, gint y);
gint puzzle_get_piece_nr (Puzzle* self, gint x, gint y);
static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_game_over (Puzzle* self);
static void puzzle_view_set_piece_id (PuzzleView* self, gchar value);
static gchar* _vala_array_dup7 (gchar* self, int length);
static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
gboolean puzzle_movable (Puzzle* self, gint id);
gboolean puzzle_mapcmp (Puzzle* self, gchar* m1, int m1_length1, gchar* m2, int m2_length1);
static gchar* _vala_array_dup8 (gchar* self, int length);
static gchar* _vala_array_dup9 (gchar* self, int length);
static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
gboolean puzzle_move_piece (Puzzle* self, gchar id, gint x1, gint y1, gint x2, gint y2);
static void puzzle_view_puzzle_changed_cb (PuzzleView* self);
void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value);
static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self);
static void puzzle_view_finalize (GObject * obj);
static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


PuzzleView* puzzle_view_construct (GType object_type) {
	PuzzleView * self = NULL;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) g_object_new (object_type, NULL);
#line 73 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 250);
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_load_image (self);
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return self;
#line 160 "puzzle-view.c"
}


PuzzleView* puzzle_view_new (void) {
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return puzzle_view_construct (TYPE_PUZZLE_VIEW);
#line 167 "puzzle-view.c"
}


static void puzzle_view_load_image (PuzzleView* self) {
	gchar* _tmp0_;
	GError * _inner_error_ = NULL;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "gnome-klotski.svg", NULL, NULL);
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_g_free0 (self->priv->image_filepath);
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->image_filepath = _tmp0_;
#line 182 "puzzle-view.c"
	{
		RsvgHandle* _tmp1_ = NULL;
		const gchar* _tmp2_;
		RsvgHandle* _tmp3_;
		RsvgHandle* _tmp4_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = self->priv->image_filepath;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = rsvg_handle_new_from_file (_tmp2_, &_inner_error_);
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = _tmp3_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "puzzle-view.c"
			goto __catch7_g_error;
		}
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = _tmp1_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = NULL;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_g_object_unref0 (self->priv->tiles_handle);
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		self->priv->tiles_handle = _tmp4_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_g_object_unref0 (_tmp1_);
#line 209 "puzzle-view.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		e = _inner_error_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_inner_error_ = NULL;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = stderr;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = e;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = _tmp6_->message;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		fprintf (_tmp5_, "%s %s\n", "Error in puzzle-view.vala load image:", _tmp7_);
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = stderr;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = self->priv->image_filepath;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		fprintf (_tmp8_, "%s %s\n", "image path:", _tmp9_);
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		exit (EXIT_FAILURE);
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_g_error_free0 (e);
#line 242 "puzzle-view.c"
	}
	__finally7:
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		g_clear_error (&_inner_error_);
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		return;
#line 253 "puzzle-view.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 261 "puzzle-view.c"
}


static gboolean puzzle_view_real_draw (GtkWidget* base, cairo_t* cr) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkStyleContext* _tmp27_;
	GdkRGBA fg = {0};
	GtkStyleContext* _tmp28_;
	GdkRGBA _tmp29_ = {0};
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp30_;
	GdkRGBA _tmp31_ = {0};
	GtkStyleContext* _tmp32_;
	cairo_t* _tmp33_;
	GdkRGBA _tmp34_;
	cairo_t* _tmp35_;
	gint width = 0;
	gint _tmp36_;
	gint height = 0;
	gint _tmp37_;
	cairo_t* _tmp38_;
	GdkRGBA _tmp39_;
	cairo_t* _tmp40_;
	gdouble kwidth = 0.0;
	Puzzle* _tmp41_;
	Puzzle* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	gdouble kheight = 0.0;
	Puzzle* _tmp46_;
	Puzzle* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	gdouble _tmp52_;
	gint _tmp53_;
	gdouble _tmp54_;
	cairo_t* _tmp55_;
	gdouble _tmp56_;
	gdouble _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	cairo_t* _tmp60_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_tile_size (self);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = self->priv->render_size;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ != _tmp2_) {
#line 327 "puzzle-view.c"
		RsvgHandle* _tmp3_;
		gint _tmp22_;
		gint _tmp23_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = self->priv->tiles_handle;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp3_ != NULL) {
#line 335 "puzzle-view.c"
			gint height = 0;
			gint _tmp4_;
			gint _tmp5_;
			gint width = 0;
			gint _tmp6_;
			gint _tmp7_;
			cairo_t* _tmp8_;
			cairo_surface_t* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			cairo_surface_t* _tmp12_;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp13_;
			cairo_t* _tmp14_;
			gdouble sfw = 0.0;
			gint _tmp15_;
			gdouble sfh = 0.0;
			gint _tmp16_;
			cairo_t* _tmp17_;
			gdouble _tmp18_;
			gdouble _tmp19_;
			RsvgHandle* _tmp20_;
			cairo_t* _tmp21_;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp4_ = puzzle_view_get_tile_size (self);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp5_ = _tmp4_;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			height = _tmp5_ * 2;
#line 108 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = puzzle_view_get_tile_size (self);
#line 108 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp7_ = _tmp6_;
#line 108 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			width = _tmp7_ * PUZZLE_VIEW_THEME_TILE_SEGMENTS;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp8_ = cr;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp9_ = cairo_get_target (_tmp8_);
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp10_ = width;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp11_ = height;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = cairo_surface_create_similar (_tmp9_, CAIRO_CONTENT_COLOR_ALPHA, _tmp10_, _tmp11_);
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_cairo_surface_destroy0 (self->priv->surface);
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			self->priv->surface = _tmp12_;
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = self->priv->surface;
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = cairo_create (_tmp13_);
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			c = _tmp14_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp15_ = width;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			sfw = ((gdouble) _tmp15_) / 918;
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp16_ = height;
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			sfh = ((gdouble) _tmp16_) / 68;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp17_ = c;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp18_ = sfw;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = sfh;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			cairo_scale (_tmp17_, _tmp18_, _tmp19_);
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = self->priv->tiles_handle;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp21_ = c;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			rsvg_handle_render_cairo (_tmp20_, _tmp21_);
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_cairo_destroy0 (c);
#line 415 "puzzle-view.c"
		}
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp22_ = puzzle_view_get_tile_size (self);
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp23_ = _tmp22_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		self->priv->render_size = _tmp23_;
#line 423 "puzzle-view.c"
	}
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	style = _tmp25_;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp26_ = style;
#line 125 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_save (_tmp26_);
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp27_ = style;
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_set_state (_tmp27_, GTK_STATE_FLAG_NORMAL);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp28_ = style;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_color (_tmp28_, GTK_STATE_FLAG_NORMAL, &_tmp29_);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	fg = _tmp29_;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp30_ = style;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_background_color (_tmp30_, GTK_STATE_FLAG_NORMAL, &_tmp31_);
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	bg = _tmp31_;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp32_ = style;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_restore (_tmp32_);
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp33_ = cr;
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp34_ = bg;
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp33_, &_tmp34_);
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp35_ = cr;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	cairo_paint (_tmp35_);
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp36_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	width = _tmp36_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp37_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	height = _tmp37_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp38_ = cr;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp39_ = fg;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp38_, &_tmp39_);
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp40_ = cr;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	cairo_set_line_width (_tmp40_, 1.0);
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp41_ = puzzle_view_get_puzzle (self);
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp42_ = _tmp41_;
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp43_ = _tmp42_->width;
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp44_ = puzzle_view_get_tile_size (self);
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp45_ = _tmp44_;
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	kwidth = ((_tmp43_ * _tmp45_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp46_ = puzzle_view_get_puzzle (self);
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp47_ = _tmp46_;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp48_ = _tmp47_->height;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp49_ = puzzle_view_get_tile_size (self);
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp50_ = _tmp49_;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	kheight = ((_tmp48_ * _tmp50_) + PUZZLE_VIEW_SPACE_PADDING) - 2.0;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp51_ = width;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp52_ = kwidth;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->kx = (_tmp51_ - _tmp52_) / 2.0;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp53_ = height;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp54_ = kheight;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->ky = (_tmp53_ - _tmp54_) / 2.0;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp55_ = cr;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp56_ = self->priv->kx;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp57_ = self->priv->ky;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp58_ = kwidth;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp59_ = kheight;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	cairo_rectangle (_tmp55_, _tmp56_, _tmp57_, _tmp58_, _tmp59_);
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp60_ = cr;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	cairo_stroke (_tmp60_);
#line 535 "puzzle-view.c"
	{
		gint y = 0;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		y = 0;
#line 540 "puzzle-view.c"
		{
			gboolean _tmp61_ = FALSE;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp61_ = TRUE;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			while (TRUE) {
#line 547 "puzzle-view.c"
				gint _tmp63_;
				Puzzle* _tmp64_;
				Puzzle* _tmp65_;
				gint _tmp66_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				if (!_tmp61_) {
#line 554 "puzzle-view.c"
					gint _tmp62_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
					_tmp62_ = y;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
					y = _tmp62_ + 1;
#line 560 "puzzle-view.c"
				}
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp61_ = FALSE;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp63_ = y;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp64_ = puzzle_view_get_puzzle (self);
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp65_ = _tmp64_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp66_ = _tmp65_->height;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				if (!(_tmp63_ < _tmp66_)) {
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
					break;
#line 576 "puzzle-view.c"
				}
				{
					gint x = 0;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
					x = 0;
#line 582 "puzzle-view.c"
					{
						gboolean _tmp67_ = FALSE;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
						_tmp67_ = TRUE;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
						while (TRUE) {
#line 589 "puzzle-view.c"
							gint _tmp69_;
							Puzzle* _tmp70_;
							Puzzle* _tmp71_;
							gint _tmp72_;
							cairo_t* _tmp73_;
							gint _tmp74_;
							gint _tmp75_;
							gdouble _tmp76_;
							gdouble _tmp77_;
							gchar _tmp78_;
							gchar _tmp79_;
							Puzzle* _tmp80_;
							Puzzle* _tmp81_;
							Puzzle* _tmp82_;
							Puzzle* _tmp83_;
							gchar* _tmp84_;
							gint _tmp84__length1;
							gint _tmp85_;
							gint _tmp86_;
							gchar _tmp87_;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							if (!_tmp67_) {
#line 612 "puzzle-view.c"
								gint _tmp68_;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp68_ = x;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								x = _tmp68_ + 1;
#line 618 "puzzle-view.c"
							}
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp67_ = FALSE;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp69_ = x;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp70_ = puzzle_view_get_puzzle (self);
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp71_ = _tmp70_;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp72_ = _tmp71_->width;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							if (!(_tmp69_ < _tmp72_)) {
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								break;
#line 634 "puzzle-view.c"
							}
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp73_ = cr;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp74_ = x;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp75_ = y;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp76_ = self->priv->kx;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp77_ = self->priv->ky;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							puzzle_view_draw_square (self, _tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp77_);
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp78_ = puzzle_view_get_piece_id (self);
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp79_ = _tmp78_;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp80_ = puzzle_view_get_puzzle (self);
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp81_ = _tmp80_;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp82_ = puzzle_view_get_puzzle (self);
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp83_ = _tmp82_;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp84_ = _tmp83_->map;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp84__length1 = _tmp83_->map_length1;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp85_ = x;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp86_ = y;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							_tmp87_ = puzzle_get_piece_id (_tmp81_, _tmp84_, _tmp84__length1, _tmp85_, _tmp86_);
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
							if (_tmp79_ == _tmp87_) {
#line 672 "puzzle-view.c"
								cairo_t* _tmp88_;
								GdkRGBA _tmp89_ = {0};
								cairo_t* _tmp90_;
								gint _tmp91_;
								gint _tmp92_;
								gint _tmp93_;
								gdouble _tmp94_;
								gint _tmp95_;
								gint _tmp96_;
								gint _tmp97_;
								gdouble _tmp98_;
								gint _tmp99_;
								gint _tmp100_;
								gint _tmp101_;
								gint _tmp102_;
								cairo_t* _tmp103_;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp88_ = cr;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp89_.red = 1.0;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp89_.green = 1.0;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp89_.blue = 1.0;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp89_.alpha = 0.2;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								gdk_cairo_set_source_rgba (_tmp88_, &_tmp89_);
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp90_ = cr;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp91_ = x;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp92_ = puzzle_view_get_tile_size (self);
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp93_ = _tmp92_;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp94_ = self->priv->kx;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp95_ = y;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp96_ = puzzle_view_get_tile_size (self);
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp97_ = _tmp96_;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp98_ = self->priv->ky;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp99_ = puzzle_view_get_tile_size (self);
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp100_ = _tmp99_;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp101_ = puzzle_view_get_tile_size (self);
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp102_ = _tmp101_;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								cairo_rectangle (_tmp90_, (_tmp91_ * _tmp93_) + _tmp94_, (_tmp95_ * _tmp97_) + _tmp98_, (gdouble) _tmp100_, (gdouble) _tmp102_);
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								_tmp103_ = cr;
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
								cairo_fill (_tmp103_);
#line 733 "puzzle-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (style);
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 747 "puzzle-view.c"
}


static void puzzle_view_draw_square (PuzzleView* self, cairo_t* cr, gint x, gint y, gdouble kx, gdouble ky) {
	GdkRectangle rect = {0};
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gdouble _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	GdkRGBA bg = {0};
	GtkStyleContext* _tmp16_;
	GdkRGBA _tmp17_ = {0};
	GtkStyleContext* _tmp18_;
	cairo_t* _tmp19_;
	GdkRectangle _tmp20_;
	cairo_t* _tmp21_;
	GdkRGBA _tmp22_;
	cairo_t* _tmp23_;
	Puzzle* _tmp24_;
	Puzzle* _tmp25_;
	Puzzle* _tmp26_;
	Puzzle* _tmp27_;
	gchar* _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	gint _tmp30_;
	gchar _tmp31_;
	Puzzle* _tmp50_;
	Puzzle* _tmp51_;
	Puzzle* _tmp52_;
	Puzzle* _tmp53_;
	gchar* _tmp54_;
	gint _tmp54__length1;
	gint _tmp55_;
	gint _tmp56_;
	gchar _tmp57_;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (cr != NULL);
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	memset (&rect, 0, sizeof (GdkRectangle));
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = x;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = puzzle_view_get_tile_size (self);
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = kx;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	rect.x = (((_tmp0_ * _tmp2_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp3_)) - 1;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = y;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp5_ = puzzle_view_get_tile_size (self);
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp6_ = _tmp5_;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp7_ = ky;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	rect.y = (((_tmp4_ * _tmp6_) + PUZZLE_VIEW_SPACE_OFFSET) + ((gint) _tmp7_)) - 1;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp8_ = puzzle_view_get_tile_size (self);
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp9_ = _tmp8_;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	rect.width = _tmp9_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp10_ = puzzle_view_get_tile_size (self);
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp11_ = _tmp10_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	rect.height = _tmp11_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	style = _tmp13_;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp14_ = style;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_save (_tmp14_);
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp15_ = style;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_set_state (_tmp15_, GTK_STATE_FLAG_NORMAL);
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp16_ = style;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_get_background_color (_tmp16_, GTK_STATE_FLAG_NORMAL, &_tmp17_);
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	bg = _tmp17_;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp18_ = style;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_style_context_restore (_tmp18_);
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp19_ = cr;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp20_ = rect;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_rectangle (_tmp19_, &_tmp20_);
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp21_ = cr;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp22_ = bg;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gdk_cairo_set_source_rgba (_tmp21_, &_tmp22_);
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp23_ = cr;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	cairo_fill (_tmp23_);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp24_ = puzzle_view_get_puzzle (self);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp25_ = _tmp24_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp26_ = puzzle_view_get_puzzle (self);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp27_ = _tmp26_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp28_ = _tmp27_->map;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp28__length1 = _tmp27_->map_length1;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp29_ = x;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp30_ = y;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp31_ = puzzle_get_piece_id (_tmp25_, _tmp28_, _tmp28__length1, _tmp29_, _tmp30_);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (_tmp31_ != ' ') {
#line 895 "puzzle-view.c"
		cairo_t* _tmp32_;
		GdkRectangle _tmp33_;
		cairo_t* _tmp34_;
		cairo_surface_t* _tmp35_;
		GdkRectangle _tmp36_;
		gint _tmp37_;
		Puzzle* _tmp38_;
		Puzzle* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		GdkRectangle _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		cairo_t* _tmp49_;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp32_ = cr;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp33_ = rect;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		gdk_cairo_rectangle (_tmp32_, &_tmp33_);
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp34_ = cr;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp35_ = self->priv->surface;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp36_ = rect;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp37_ = _tmp36_.x;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp38_ = puzzle_view_get_puzzle (self);
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp39_ = _tmp38_;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp40_ = x;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp41_ = y;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp42_ = puzzle_get_piece_nr (_tmp39_, _tmp40_, _tmp41_);
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp43_ = puzzle_view_get_tile_size (self);
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp44_ = _tmp43_;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp45_ = rect;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp46_ = _tmp45_.y;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp47_ = puzzle_view_get_tile_size (self);
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp48_ = _tmp47_;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		cairo_set_source_surface (_tmp34_, _tmp35_, (gdouble) (_tmp37_ - (_tmp42_ * _tmp44_)), (gdouble) (_tmp46_ - (_tmp48_ / 2)));
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp49_ = cr;
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		cairo_fill (_tmp49_);
#line 956 "puzzle-view.c"
	}
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp50_ = puzzle_view_get_puzzle (self);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp51_ = _tmp50_;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp52_ = puzzle_view_get_puzzle (self);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp53_ = _tmp52_;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp54_ = _tmp53_->map;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp54__length1 = _tmp53_->map_length1;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp55_ = x;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp56_ = y;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp57_ = puzzle_get_piece_id (_tmp51_, _tmp54_, _tmp54__length1, _tmp55_, _tmp56_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (_tmp57_ == '*') {
#line 978 "puzzle-view.c"
		gint value = 0;
		Puzzle* _tmp58_;
		Puzzle* _tmp59_;
		Puzzle* _tmp60_;
		Puzzle* _tmp61_;
		gchar* _tmp62_;
		gint _tmp62__length1;
		gint _tmp63_;
		gint _tmp64_;
		gchar _tmp65_;
		gint overlay_size = 0;
		gint _tmp66_;
		gint _tmp67_;
		gint overlay_offset = 0;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		cairo_t* _tmp71_;
		GdkRectangle _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		GdkRectangle _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		cairo_t* _tmp80_;
		cairo_surface_t* _tmp81_;
		GdkRectangle _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		gint _tmp86_;
		GdkRectangle _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		cairo_t* _tmp91_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		value = 22;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp58_ = puzzle_view_get_puzzle (self);
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp59_ = _tmp58_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp60_ = puzzle_view_get_puzzle (self);
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp61_ = _tmp60_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp62_ = _tmp61_->orig_map;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp62__length1 = _tmp61_->orig_map_length1;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp63_ = x;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp64_ = y;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp65_ = puzzle_get_piece_id (_tmp59_, _tmp62_, _tmp62__length1, _tmp63_, _tmp64_);
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp65_ == '.') {
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			value = 20;
#line 1041 "puzzle-view.c"
		}
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp66_ = puzzle_view_get_tile_size (self);
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp67_ = _tmp66_;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		overlay_size = (PUZZLE_VIEW_THEME_OVERLAY_SIZE * _tmp67_) / PUZZLE_VIEW_THEME_TILE_SIZE;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp68_ = puzzle_view_get_tile_size (self);
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp69_ = _tmp68_;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp70_ = overlay_size;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		overlay_offset = ((PUZZLE_VIEW_THEME_TILE_CENTER * _tmp69_) / PUZZLE_VIEW_THEME_TILE_SIZE) - (_tmp70_ / 2);
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp71_ = cr;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp72_ = rect;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp73_ = _tmp72_.x;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp74_ = overlay_offset;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp75_ = rect;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp76_ = _tmp75_.y;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp77_ = overlay_offset;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp78_ = overlay_size;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp79_ = overlay_size;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		cairo_rectangle (_tmp71_, (gdouble) (_tmp73_ + _tmp74_), (gdouble) (_tmp76_ + _tmp77_), (gdouble) _tmp78_, (gdouble) _tmp79_);
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp80_ = cr;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp81_ = self->priv->surface;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp82_ = rect;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp83_ = _tmp82_.x;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp84_ = value;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp85_ = puzzle_view_get_tile_size (self);
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp86_ = _tmp85_;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp87_ = rect;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp88_ = _tmp87_.y;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp89_ = puzzle_view_get_tile_size (self);
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp90_ = _tmp89_;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		cairo_set_source_surface (_tmp80_, _tmp81_, (gdouble) (_tmp83_ - (_tmp84_ * _tmp86_)), (gdouble) (_tmp88_ - (_tmp90_ / 2)));
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp91_ = cr;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		cairo_fill (_tmp91_);
#line 1105 "puzzle-view.c"
	}
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (style);
#line 1109 "puzzle-view.c"
}


static gchar* _vala_array_dup7 (gchar* self, int length) {
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1116 "puzzle-view.c"
}


static gboolean puzzle_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	GdkEventButton* _tmp0_;
	guint _tmp1_;
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = event;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_->button;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1135 "puzzle-view.c"
		Puzzle* _tmp2_;
		Puzzle* _tmp3_;
		gboolean _tmp4_;
		GdkEventButton* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GdkEventButton* _tmp10_;
		gdouble _tmp11_;
		gdouble _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar new_piece_id = '\0';
		Puzzle* _tmp15_;
		Puzzle* _tmp16_;
		Puzzle* _tmp17_;
		Puzzle* _tmp18_;
		gchar* _tmp19_;
		gint _tmp19__length1;
		gint _tmp20_;
		gint _tmp21_;
		gchar _tmp22_;
		gboolean _tmp23_ = FALSE;
		gchar _tmp24_;
		gchar _tmp25_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gchar _tmp31_;
		gchar _tmp38_;
		Puzzle* _tmp39_;
		Puzzle* _tmp40_;
		Puzzle* _tmp41_;
		Puzzle* _tmp42_;
		gchar* _tmp43_;
		gint _tmp43__length1;
		gchar* _tmp44_;
		gint _tmp44__length1;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = puzzle_view_get_puzzle (self);
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = _tmp2_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = puzzle_game_over (_tmp3_);
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp4_) {
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1188 "puzzle-view.c"
		}
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = event;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = _tmp5_->x;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = self->priv->kx;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = puzzle_view_get_tile_size (self);
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = _tmp8_;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_x = ((gint) (_tmp6_ - _tmp7_)) / _tmp9_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = event;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = _tmp10_->y;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp12_ = self->priv->ky;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp13_ = puzzle_view_get_tile_size (self);
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp14_ = _tmp13_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_y = ((gint) (_tmp11_ - _tmp12_)) / _tmp14_;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp15_ = puzzle_view_get_puzzle (self);
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp16_ = _tmp15_;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp17_ = puzzle_view_get_puzzle (self);
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp18_ = _tmp17_;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp19_ = _tmp18_->map;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp19__length1 = _tmp18_->map_length1;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp20_ = self->priv->piece_x;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp21_ = self->priv->piece_y;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp22_ = puzzle_get_piece_id (_tmp16_, _tmp19_, _tmp19__length1, _tmp20_, _tmp21_);
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		new_piece_id = _tmp22_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp24_ = puzzle_view_get_piece_id (self);
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp25_ = _tmp24_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp25_ != '\0') {
#line 1240 "puzzle-view.c"
			gboolean _tmp26_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp26_ = self->priv->piece_unmoved;
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = _tmp26_;
#line 1246 "puzzle-view.c"
		} else {
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = FALSE;
#line 1250 "puzzle-view.c"
		}
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp23_) {
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			puzzle_view_set_piece_id (self, '\0');
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1260 "puzzle-view.c"
		}
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp31_ = new_piece_id;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp31_ == ' ') {
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp30_ = TRUE;
#line 1268 "puzzle-view.c"
		} else {
			gchar _tmp32_;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp32_ = new_piece_id;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp30_ = _tmp32_ == '.';
#line 1275 "puzzle-view.c"
		}
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp30_) {
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp29_ = TRUE;
#line 1281 "puzzle-view.c"
		} else {
			gchar _tmp33_;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp33_ = new_piece_id;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp29_ = _tmp33_ == '-';
#line 1288 "puzzle-view.c"
		}
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp29_) {
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp28_ = TRUE;
#line 1294 "puzzle-view.c"
		} else {
			gchar _tmp34_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp34_ = new_piece_id;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp28_ = _tmp34_ == '#';
#line 1301 "puzzle-view.c"
		}
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp28_) {
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp27_ = TRUE;
#line 1307 "puzzle-view.c"
		} else {
			gchar _tmp35_;
			gchar _tmp36_;
			gchar _tmp37_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp35_ = new_piece_id;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp36_ = puzzle_view_get_piece_id (self);
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp37_ = _tmp36_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp27_ = _tmp35_ == _tmp37_;
#line 1320 "puzzle-view.c"
		}
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp27_) {
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1328 "puzzle-view.c"
		}
#line 227 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		self->priv->piece_unmoved = TRUE;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp38_ = new_piece_id;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_piece_id (self, _tmp38_);
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp39_ = puzzle_view_get_puzzle (self);
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp40_ = _tmp39_;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp41_ = puzzle_view_get_puzzle (self);
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp42_ = _tmp41_;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp43_ = _tmp42_->map;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp43__length1 = _tmp42_->map_length1;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp44_ = (_tmp43_ != NULL) ? _vala_array_dup7 (_tmp43_, _tmp43__length1) : ((gpointer) _tmp43_);
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp44__length1 = _tmp43__length1;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map = (g_free (_tmp40_->move_map), NULL);
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map = _tmp44_;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp40_->move_map_length1 = _tmp44__length1;
#line 1358 "puzzle-view.c"
	}
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1364 "puzzle-view.c"
}


static gchar* _vala_array_dup8 (gchar* self, int length) {
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1371 "puzzle-view.c"
}


static gchar* _vala_array_dup9 (gchar* self, int length) {
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return g_memdup (self, length * sizeof (gchar));
#line 1378 "puzzle-view.c"
}


static gboolean puzzle_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_;
	guint _tmp2_;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = event;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_->button;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (_tmp2_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 1398 "puzzle-view.c"
		gchar _tmp3_;
		gchar _tmp4_;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = puzzle_view_get_piece_id (self);
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = _tmp3_;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp0_ = _tmp4_ != '\0';
#line 1407 "puzzle-view.c"
	} else {
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp0_ = FALSE;
#line 1411 "puzzle-view.c"
	}
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (_tmp0_) {
#line 1415 "puzzle-view.c"
		gboolean _tmp5_;
		gboolean _tmp6_ = FALSE;
		Puzzle* _tmp7_;
		Puzzle* _tmp8_;
		gchar _tmp9_;
		gchar _tmp10_;
		gboolean _tmp11_;
#line 239 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = self->priv->piece_unmoved;
#line 239 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp5_) {
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1431 "puzzle-view.c"
		}
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = puzzle_view_get_puzzle (self);
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = _tmp7_;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = puzzle_view_get_piece_id (self);
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = _tmp9_;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = puzzle_movable (_tmp8_, (gint) _tmp10_);
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp11_) {
#line 1445 "puzzle-view.c"
			Puzzle* _tmp12_;
			Puzzle* _tmp13_;
			Puzzle* _tmp14_;
			Puzzle* _tmp15_;
			gchar* _tmp16_;
			gint _tmp16__length1;
			Puzzle* _tmp17_;
			Puzzle* _tmp18_;
			gchar* _tmp19_;
			gint _tmp19__length1;
			gboolean _tmp20_;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = puzzle_view_get_puzzle (self);
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = _tmp12_;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = puzzle_view_get_puzzle (self);
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp15_ = _tmp14_;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp16_ = _tmp15_->move_map;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp16__length1 = _tmp15_->move_map_length1;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp17_ = puzzle_view_get_puzzle (self);
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp18_ = _tmp17_;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = _tmp18_->map;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp19__length1 = _tmp18_->map_length1;
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = puzzle_mapcmp (_tmp13_, _tmp16_, _tmp16__length1, _tmp19_, _tmp19__length1);
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = _tmp20_;
#line 1481 "puzzle-view.c"
		} else {
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp6_ = FALSE;
#line 1485 "puzzle-view.c"
		}
#line 242 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp6_) {
#line 1489 "puzzle-view.c"
			gboolean _tmp21_ = FALSE;
			gchar _tmp22_;
			gboolean _tmp38_ = FALSE;
			Puzzle* _tmp39_;
			Puzzle* _tmp40_;
			gint _tmp41_;
			Puzzle* _tmp56_;
			Puzzle* _tmp57_;
			Puzzle* _tmp58_;
			Puzzle* _tmp59_;
			gchar* _tmp60_;
			gint _tmp60__length1;
			gchar* _tmp61_;
			gint _tmp61__length1;
			Puzzle* _tmp62_;
			Puzzle* _tmp63_;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp22_ = self->priv->last_piece_id;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			if (_tmp22_ == '\0') {
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp21_ = TRUE;
#line 1512 "puzzle-view.c"
			} else {
				gchar _tmp23_;
				gchar _tmp24_;
				gchar _tmp25_;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp23_ = self->priv->last_piece_id;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp24_ = puzzle_view_get_piece_id (self);
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp25_ = _tmp24_;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp21_ = _tmp23_ != _tmp25_;
#line 1525 "puzzle-view.c"
			}
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			if (_tmp21_) {
#line 1529 "puzzle-view.c"
				Puzzle* _tmp26_;
				Puzzle* _tmp27_;
				Puzzle* _tmp28_;
				Puzzle* _tmp29_;
				gchar* _tmp30_;
				gint _tmp30__length1;
				gchar* _tmp31_;
				gint _tmp31__length1;
				Puzzle* _tmp32_;
				Puzzle* _tmp33_;
				gint _tmp34_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp26_ = puzzle_view_get_puzzle (self);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp27_ = _tmp26_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp28_ = puzzle_view_get_puzzle (self);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp29_ = _tmp28_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp30_ = _tmp29_->lastmove_map;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp30__length1 = _tmp29_->lastmove_map_length1;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup8 (_tmp30_, _tmp30__length1) : ((gpointer) _tmp30_);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp31__length1 = _tmp30__length1;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map = (g_free (_tmp27_->undomove_map), NULL);
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map = _tmp31_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp27_->undomove_map_length1 = _tmp31__length1;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp32_ = puzzle_view_get_puzzle (self);
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp33_ = _tmp32_;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp34_ = _tmp33_->moves;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				if (_tmp34_ < 999) {
#line 1571 "puzzle-view.c"
					Puzzle* _tmp35_;
					Puzzle* _tmp36_;
					gint _tmp37_;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
					_tmp35_ = puzzle_view_get_puzzle (self);
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
					_tmp36_ = _tmp35_;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
					_tmp37_ = _tmp36_->moves;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
					_tmp36_->moves = _tmp37_ + 1;
#line 1583 "puzzle-view.c"
				}
			}
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp39_ = puzzle_view_get_puzzle (self);
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp40_ = _tmp39_;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp41_ = _tmp40_->moves;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			if (_tmp41_ > 0) {
#line 1594 "puzzle-view.c"
				Puzzle* _tmp42_;
				Puzzle* _tmp43_;
				Puzzle* _tmp44_;
				Puzzle* _tmp45_;
				gchar* _tmp46_;
				gint _tmp46__length1;
				Puzzle* _tmp47_;
				Puzzle* _tmp48_;
				gchar* _tmp49_;
				gint _tmp49__length1;
				gboolean _tmp50_;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp42_ = puzzle_view_get_puzzle (self);
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp43_ = _tmp42_;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp44_ = puzzle_view_get_puzzle (self);
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp45_ = _tmp44_;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp46_ = _tmp45_->undomove_map;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp46__length1 = _tmp45_->undomove_map_length1;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp47_ = puzzle_view_get_puzzle (self);
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp48_ = _tmp47_;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp49_ = _tmp48_->map;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp49__length1 = _tmp48_->map_length1;
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp50_ = puzzle_mapcmp (_tmp43_, _tmp46_, _tmp46__length1, _tmp49_, _tmp49__length1);
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp38_ = !_tmp50_;
#line 1630 "puzzle-view.c"
			} else {
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp38_ = FALSE;
#line 1634 "puzzle-view.c"
			}
#line 251 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			if (_tmp38_) {
#line 1638 "puzzle-view.c"
				Puzzle* _tmp51_;
				Puzzle* _tmp52_;
				gint _tmp53_;
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp51_ = puzzle_view_get_puzzle (self);
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp52_ = _tmp51_;
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp53_ = _tmp52_->moves;
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp52_->moves = _tmp53_ - 1;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				self->priv->last_piece_id = '\0';
#line 1652 "puzzle-view.c"
			} else {
				gchar _tmp54_;
				gchar _tmp55_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp54_ = puzzle_view_get_piece_id (self);
#line 257 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				_tmp55_ = _tmp54_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
				self->priv->last_piece_id = _tmp55_;
#line 1662 "puzzle-view.c"
			}
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp56_ = puzzle_view_get_puzzle (self);
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp57_ = _tmp56_;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp58_ = puzzle_view_get_puzzle (self);
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp59_ = _tmp58_;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp60_ = _tmp59_->map;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp60__length1 = _tmp59_->map_length1;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp61_ = (_tmp60_ != NULL) ? _vala_array_dup9 (_tmp60_, _tmp60__length1) : ((gpointer) _tmp60_);
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp61__length1 = _tmp60__length1;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map = (g_free (_tmp57_->lastmove_map), NULL);
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map = _tmp61_;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp57_->lastmove_map_length1 = _tmp61__length1;
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp62_ = puzzle_view_get_puzzle (self);
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp63_ = _tmp62_;
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			g_signal_emit_by_name (_tmp63_, "moved");
#line 1692 "puzzle-view.c"
		}
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_piece_id (self, '\0');
#line 1696 "puzzle-view.c"
	}
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1702 "puzzle-view.c"
}


static gboolean puzzle_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	PuzzleView * self;
	gboolean result = FALSE;
	gint new_piece_x = 0;
	gint new_piece_y = 0;
	gchar _tmp0_;
	gchar _tmp1_;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self = (PuzzleView*) base;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 273 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = puzzle_view_get_piece_id (self);
#line 273 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = _tmp0_;
#line 273 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (_tmp1_ != '\0') {
#line 1723 "puzzle-view.c"
		GdkEventMotion* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GdkEventMotion* _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gint _tmp15_;
		Puzzle* _tmp16_;
		Puzzle* _tmp17_;
		gint _tmp18_;
		Puzzle* _tmp27_;
		Puzzle* _tmp28_;
		gchar _tmp29_;
		gchar _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gboolean _tmp35_;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp2_ = event;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp3_ = _tmp2_->x;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp4_ = self->priv->kx;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp5_ = puzzle_view_get_tile_size (self);
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp6_ = _tmp5_;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		new_piece_x = ((gint) (_tmp3_ - _tmp4_)) / _tmp6_;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp7_ = event;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp8_ = _tmp7_->y;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp9_ = self->priv->ky;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = puzzle_view_get_tile_size (self);
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp11_ = _tmp10_;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		new_piece_y = ((gint) (_tmp8_ - _tmp9_)) / _tmp11_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp15_ = new_piece_x;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp16_ = puzzle_view_get_puzzle (self);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp17_ = _tmp16_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp18_ = _tmp17_->width;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp15_ >= _tmp18_) {
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = TRUE;
#line 1786 "puzzle-view.c"
		} else {
			GdkEventMotion* _tmp19_;
			gdouble _tmp20_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp19_ = event;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp20_ = _tmp19_->x;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp14_ = _tmp20_ < ((gdouble) 0);
#line 1796 "puzzle-view.c"
		}
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp14_) {
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = TRUE;
#line 1802 "puzzle-view.c"
		} else {
			gint _tmp21_;
			Puzzle* _tmp22_;
			Puzzle* _tmp23_;
			gint _tmp24_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp21_ = new_piece_y;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp22_ = puzzle_view_get_puzzle (self);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp23_ = _tmp22_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp24_ = _tmp23_->height;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp13_ = _tmp21_ >= _tmp24_;
#line 1818 "puzzle-view.c"
		}
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp13_) {
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = TRUE;
#line 1824 "puzzle-view.c"
		} else {
			GdkEventMotion* _tmp25_;
			gdouble _tmp26_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp25_ = event;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp26_ = _tmp25_->y;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp12_ = _tmp26_ < ((gdouble) 0);
#line 1834 "puzzle-view.c"
		}
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp12_) {
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			result = FALSE;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			return result;
#line 1842 "puzzle-view.c"
		}
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp27_ = puzzle_view_get_puzzle (self);
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp28_ = _tmp27_;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp29_ = puzzle_view_get_piece_id (self);
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp30_ = _tmp29_;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp31_ = self->priv->piece_x;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp32_ = self->priv->piece_y;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp33_ = new_piece_x;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp34_ = new_piece_y;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp35_ = puzzle_move_piece (_tmp28_, _tmp30_, _tmp31_, _tmp32_, _tmp33_, _tmp34_);
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		if (_tmp35_) {
#line 1864 "puzzle-view.c"
			gint _tmp36_;
			gint _tmp37_;
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_unmoved = FALSE;
#line 282 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp36_ = new_piece_x;
#line 282 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_x = _tmp36_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			_tmp37_ = new_piece_y;
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
			self->priv->piece_y = _tmp37_;
#line 1877 "puzzle-view.c"
		}
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		result = TRUE;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		return result;
#line 1883 "puzzle-view.c"
	}
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	result = FALSE;
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1889 "puzzle-view.c"
}


static void puzzle_view_puzzle_changed_cb (PuzzleView* self) {
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1898 "puzzle-view.c"
}


static gchar puzzle_view_get_piece_id (PuzzleView* self) {
	gchar result;
	gchar _tmp0_;
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_piece_id;
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	result = _tmp0_;
#line 29 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1913 "puzzle-view.c"
}


static void puzzle_view_set_piece_id (PuzzleView* self, gchar value) {
	gchar _tmp0_;
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = value;
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->_piece_id = _tmp0_;
#line 30 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 1927 "puzzle-view.c"
}


Puzzle* puzzle_view_get_puzzle (PuzzleView* self) {
	Puzzle* result;
	Puzzle* _tmp0_;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	result = _tmp0_;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 1942 "puzzle-view.c"
}


static void _puzzle_view_puzzle_changed_cb_puzzle_changed (Puzzle* _sender, gpointer self) {
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_puzzle_changed_cb ((PuzzleView*) self);
#line 1949 "puzzle-view.c"
}


void puzzle_view_set_puzzle (PuzzleView* self, Puzzle* value) {
	Puzzle* _tmp0_;
	Puzzle* _tmp2_;
	Puzzle* _tmp3_;
	Puzzle* _tmp4_;
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = self->priv->_puzzle;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if (_tmp0_ != NULL) {
#line 1964 "puzzle-view.c"
		Puzzle* _tmp1_;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp1_ = self->priv->_puzzle;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 1970 "puzzle-view.c"
	}
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = value;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->_puzzle = _tmp3_;
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = self->priv->_puzzle;
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _puzzle_view_puzzle_changed_cb_puzzle_changed, self, 0);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_x = 0;
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_y = 0;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_set_piece_id (self, '\0');
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_object_notify_by_pspec ((GObject *) self, puzzle_view_properties[PUZZLE_VIEW_PUZZLE_PROPERTY]);
#line 1994 "puzzle-view.c"
}


static gint puzzle_view_get_tile_size (PuzzleView* self) {
	gint result;
	gint s = 0;
	gint _tmp0_;
	Puzzle* _tmp1_;
	Puzzle* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Puzzle* _tmp5_;
	Puzzle* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp11_;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp1_ = puzzle_view_get_puzzle (self);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp2_ = _tmp1_;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp3_ = _tmp2_->width;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp5_ = puzzle_view_get_puzzle (self);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp6_ = _tmp5_;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp7_ = _tmp6_->height;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp8_ = MIN ((_tmp0_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp3_, (_tmp4_ - PUZZLE_VIEW_SPACE_PADDING) / _tmp7_);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	s = _tmp8_;
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp9_ = s;
#line 65 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	if ((_tmp9_ % 2) != 0) {
#line 2038 "puzzle-view.c"
		gint _tmp10_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		_tmp10_ = s;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		s = _tmp10_ - 1;
#line 2044 "puzzle-view.c"
	}
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp11_ = s;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	result = _tmp11_;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	return result;
#line 2052 "puzzle-view.c"
}


static void puzzle_view_class_init (PuzzleViewClass * klass) {
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	puzzle_view_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_type_class_add_private (klass, sizeof (PuzzleViewPrivate));
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) puzzle_view_real_draw;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) puzzle_view_real_button_press_event;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) puzzle_view_real_button_release_event;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget *, GdkEventMotion*)) puzzle_view_real_motion_notify_event;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_puzzle_view_get_property;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_puzzle_view_set_property;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (klass)->finalize = puzzle_view_finalize;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PUZZLE_VIEW_PUZZLE_PROPERTY, puzzle_view_properties[PUZZLE_VIEW_PUZZLE_PROPERTY] = g_param_spec_object ("puzzle", "puzzle", "puzzle", TYPE_PUZZLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2077 "puzzle-view.c"
}


static void puzzle_view_instance_init (PuzzleView * self) {
	gchar* _tmp0_;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv = PUZZLE_VIEW_GET_PRIVATE (self);
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->render_size = 0;
#line 22 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_x = 0;
#line 23 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_y = 0;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->piece_unmoved = FALSE;
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->_piece_id = '\0';
#line 33 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->last_piece_id = '\0';
#line 35 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->kx = (gdouble) 0;
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->ky = (gdouble) 0;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->tiles_handle = NULL;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_tmp0_ = g_strdup ("");
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->image_filepath = _tmp0_;
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->surface = NULL;
#line 42 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self->priv->_puzzle = NULL;
#line 2111 "puzzle-view.c"
}


static void puzzle_view_finalize (GObject * obj) {
	PuzzleView * self;
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PUZZLE_VIEW, PuzzleView);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->tiles_handle);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_g_free0 (self->priv->image_filepath);
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_cairo_surface_destroy0 (self->priv->surface);
#line 42 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	_g_object_unref0 (self->priv->_puzzle);
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	G_OBJECT_CLASS (puzzle_view_parent_class)->finalize (obj);
#line 2129 "puzzle-view.c"
}


GType puzzle_view_get_type (void) {
	static volatile gsize puzzle_view_type_id__volatile = 0;
	if (g_once_init_enter (&puzzle_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PuzzleViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) puzzle_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PuzzleView), 0, (GInstanceInitFunc) puzzle_view_instance_init, NULL };
		GType puzzle_view_type_id;
		puzzle_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "PuzzleView", &g_define_type_info, 0);
		g_once_init_leave (&puzzle_view_type_id__volatile, puzzle_view_type_id);
	}
	return puzzle_view_type_id__volatile;
}


static void _vala_puzzle_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE_PROPERTY:
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		g_value_set_object (value, puzzle_view_get_puzzle (self));
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2156 "puzzle-view.c"
		default:
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2162 "puzzle-view.c"
	}
}


static void _vala_puzzle_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PuzzleView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PUZZLE_VIEW, PuzzleView);
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		case PUZZLE_VIEW_PUZZLE_PROPERTY:
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		puzzle_view_set_puzzle (self, g_value_get_object (value));
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2178 "puzzle-view.c"
		default:
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/Projects/GNOME/gnome-klotski/src/puzzle-view.vala"
		break;
#line 2184 "puzzle-view.c"
	}
}



