//  
//  Copyright (C) 2009 GNOME Do
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 

using System;
using System.Threading;

using Do.Platform;
using Do.Universe;

namespace WeatherDocklet
{
	/// <summary>
	/// A <see cref="Do.Universe.Item"/> class for weather actions.
	/// </summary>
	public class WeatherItem : Item, IRunnableItem
	{
		Action run;
		string name, description, icon;
		int i = -1;
		
		/// <summary>
		/// Constructs a new WeatherItem object.
		/// </summary>
		/// <param name="name">
		/// A <see cref="System.String"/> representing the name for the WeatherItem.
		/// </param>
		/// <param name="description">
		/// A <see cref="System.String"/> representing the description for the WeatherItem.
		/// </param>
		/// <param name="icon">
		/// A <see cref="System.String"/> representing the icon for the WeatherItem.
		/// </param>
		/// <param name="run">
		/// A <see cref="System.Action"/> representing the Action to run when the WeatherItem is called.
		/// </param>
		public WeatherItem (string name, string description, string icon, Action run)
		{
			this.name = name;
			this.description = description;
			this.icon = icon;
			this.run = run;
			this.i = -1;
		}
		
		/// <summary>
		/// Constructs a new WeatherItem that displays a day's forecast.
		/// </summary>
		/// <param name="name">
		/// A <see cref="System.String"/> representing the name for the WeatherItem.
		/// </param>
		/// <param name="description">
		/// A <see cref="System.String"/> representing the description for the WeatherItem.
		/// </param>
		/// <param name="icon">
		/// A <see cref="System.String"/> representing the icon for the WeatherItem.
		/// </param>
		/// <param name="i">
		/// A <see cref="System.Int32"/> representing the forecast day.
		/// </param>
		public WeatherItem (string name, string description, string icon, int i)
		{
			this.name = name;
			this.description = description;
			this.icon = icon;
			this.run = null;
			this.i = i;
		}
		public override string Name {
			get { return name; }
		}
		
		public override string Description {
			get { return description; }
		}
		
		public override string Icon {
			get { return icon; }
		}
		
		/// <summary>
		/// Starts a new thread and calls the WeatherItem's <see cref="System.Action"/>.
		/// </summary>
		public virtual void Run ()
		{
			if (run != null)
				Services.Application.RunOnThread (run);
			else
				Services.Application.RunOnThread (() => {
					WeatherController.Weather.ShowForecast (i);
				});
		}
	}
}
