/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gcm-gl-plugin.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 28 "gcm-gl-plugin.gob"

#include "gcm-gl-option-gconf.h"

#line 28 "gcm-gl-plugin.c"
/* self casting macros */
#define SELF(x) GCM_GL_PLUGIN(x)
#define SELF_CONST(x) GCM_GL_PLUGIN_CONST(x)
#define IS_SELF(x) GCM_IS_GL_PLUGIN(x)
#define TYPE_SELF GCM_TYPE_GL_PLUGIN
#define SELF_CLASS(x) GCM_GL_PLUGIN_CLASS(x)

#define SELF_GET_CLASS(x) GCM_GL_PLUGIN_GET_CLASS(x)

/* self typedefs */
typedef GCMGLPlugin Self;
typedef GCMGLPluginClass SelfClass;

/* here are local prototypes */
static void gcm_gl_plugin_init (GCMGLPlugin * o) G_GNUC_UNUSED;
static void gcm_gl_plugin_class_init (GCMGLPluginClass * c) G_GNUC_UNUSED;
static gboolean gcm_gl_plugin_exists (GCMGLPlugin * self) G_GNUC_UNUSED;
static gboolean gcm_gl_plugin_get_config (GCMGLPlugin * self) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_new gcm_gl_plugin_new
#define self_get_option gcm_gl_plugin_get_option
#define self_exists gcm_gl_plugin_exists
#define self_get_config gcm_gl_plugin_get_config
GType
gcm_gl_plugin_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GCMGLPluginClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gcm_gl_plugin_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GCMGLPlugin),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gcm_gl_plugin_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GCMGLPlugin", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GCMGLPlugin *)g_object_new(gcm_gl_plugin_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GCMGLPlugin * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GCMGLPlugin *
GET_NEW_VARG (const char *first, ...)
{
	GCMGLPlugin *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GCMGLPlugin *)g_object_new_valist (gcm_gl_plugin_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "GCM:GL:Plugin::finalize"
	GCMGLPlugin *self G_GNUC_UNUSED = GCM_GL_PLUGIN (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 35 "gcm-gl-plugin.gob"
	if(self->name) { g_free ((gpointer) self->name); self->name = NULL; }
#line 108 "gcm-gl-plugin.c"
#line 37 "gcm-gl-plugin.gob"
	if(self->info) { g_free ((gpointer) self->info); self->info = NULL; }
#line 111 "gcm-gl-plugin.c"
#define load_before (self->load_before)
#define VAR load_before
	{
#line 39 "gcm-gl-plugin.gob"
	
			if (load_before)
			{
				g_slist_foreach(load_before, (GFunc)g_free, NULL);
				g_slist_free(load_before);
			}
		}
#line 123 "gcm-gl-plugin.c"
	memset(&load_before, 0, sizeof(load_before));
#undef VAR
#undef load_before
#define requires (self->requires)
#define VAR requires
	{
#line 47 "gcm-gl-plugin.gob"
	
			if (requires)
			{
				g_slist_foreach(requires, (GFunc)g_free, NULL);
				g_slist_free(requires);
			}
		}
#line 138 "gcm-gl-plugin.c"
	memset(&requires, 0, sizeof(requires));
#undef VAR
#undef requires
}
#undef __GOB_FUNCTION__

static void 
gcm_gl_plugin_init (GCMGLPlugin * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GCM:GL:Plugin::init"
}
#undef __GOB_FUNCTION__
static void 
gcm_gl_plugin_class_init (GCMGLPluginClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GCM:GL:Plugin::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



/**
 * gcm_gl_plugin_new:
 * @name: plugin name
 *
 * Create a #GCMGLPlugin control
 *
 * Returns: #GCMGLPlugin or NULL if plugin isn't installed
 **/
#line 63 "gcm-gl-plugin.gob"
GCMGLPlugin * 
gcm_gl_plugin_new (gchar * name)
#line 176 "gcm-gl-plugin.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Plugin::new"
#line 63 "gcm-gl-plugin.gob"
	g_return_val_if_fail (name != NULL, (GCMGLPlugin * )NULL);
#line 181 "gcm-gl-plugin.c"
{
#line 65 "gcm-gl-plugin.gob"
	
		GCMGLPlugin * self = GET_NEW;
		
		/* Get name and check if plugin installed */
		self->name = g_strdup(name);
		if (!self_exists(self))
		{
			g_warning("plugin %s isn't installed", name);
			g_object_unref(self);
			return NULL;
		}
		
		if (!self_get_config(self))
		{
			g_object_unref(self);
			return NULL;
		}
		
		return self;
	}}
#line 204 "gcm-gl-plugin.c"
#undef __GOB_FUNCTION__

/**
 * gcm_gl_plugin_get_option:
 * @self: #GCMGLPlugin
 * @name: name of option
 * @screen: #GCMGLOptionScreen
 *
 * Get an #GCMGLOption of GL Plugin
 *
 * Returns: #GCMGLOption
 **/
#line 96 "gcm-gl-plugin.gob"
GCMGLOption * 
gcm_gl_plugin_get_option (GCMGLPlugin * self, gchar * name, gint screen)
#line 220 "gcm-gl-plugin.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Plugin::get_option"
#line 96 "gcm-gl-plugin.gob"
	g_return_val_if_fail (self != NULL, (GCMGLOption * )NULL);
#line 96 "gcm-gl-plugin.gob"
	g_return_val_if_fail (GCM_IS_GL_PLUGIN (self), (GCMGLOption * )NULL);
#line 96 "gcm-gl-plugin.gob"
	g_return_val_if_fail (name != NULL, (GCMGLOption * )NULL);
#line 96 "gcm-gl-plugin.gob"
	g_return_val_if_fail (screen > -3, (GCMGLOption * )NULL);
#line 231 "gcm-gl-plugin.c"
{
#line 98 "gcm-gl-plugin.gob"
	
		return gcm_gl_option_gconf_new(self->name, name, screen);
	}}
#line 237 "gcm-gl-plugin.c"
#undef __GOB_FUNCTION__

#line 102 "gcm-gl-plugin.gob"
static gboolean 
gcm_gl_plugin_exists (GCMGLPlugin * self)
#line 243 "gcm-gl-plugin.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Plugin::exists"
#line 102 "gcm-gl-plugin.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 102 "gcm-gl-plugin.gob"
	g_return_val_if_fail (GCM_IS_GL_PLUGIN (self), (gboolean )FALSE);
#line 250 "gcm-gl-plugin.c"
{
#line 104 "gcm-gl-plugin.gob"
	
		gchar * compiz_bindir = g_path_get_dirname(g_find_program_in_path("compiz"));
		gchar * compiz_libdir, ** dir_split;
		gchar * plugin_filename;
		gint cpt;
		gboolean result = FALSE;
		
		dir_split = g_strsplit(compiz_bindir, G_DIR_SEPARATOR_S, -1);
		g_free(compiz_bindir);
		for (cpt = 0; dir_split[cpt]; cpt++)
		{
			if (!g_ascii_strcasecmp(dir_split[cpt], "bin"))
			{
				g_free(dir_split[cpt]);
				dir_split[cpt] = g_strdup("lib");
				break;
			}
		}
		compiz_libdir = g_strjoinv(G_DIR_SEPARATOR_S, dir_split);
		g_strfreev(dir_split);
		
		plugin_filename = g_strdup_printf("%s/compiz/lib%s.so",
										  compiz_libdir, 
										  self->name);
		g_free(compiz_libdir);
		
		result = g_file_test(plugin_filename, G_FILE_TEST_EXISTS);
		g_free(plugin_filename);
		
		return result;
	}}
#line 284 "gcm-gl-plugin.c"
#undef __GOB_FUNCTION__

#line 136 "gcm-gl-plugin.gob"
static gboolean 
gcm_gl_plugin_get_config (GCMGLPlugin * self)
#line 290 "gcm-gl-plugin.c"
{
#define __GOB_FUNCTION__ "GCM:GL:Plugin::get_config"
#line 136 "gcm-gl-plugin.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 136 "gcm-gl-plugin.gob"
	g_return_val_if_fail (GCM_IS_GL_PLUGIN (self), (gboolean )0);
#line 297 "gcm-gl-plugin.c"
{
#line 138 "gcm-gl-plugin.gob"
	
		GCMGLOption * option = gcm_gl_option_gconf_new(self->name, "info", 
													   GCM_GL_OPTION_SCREEN_NONE);
		
		self->info = gcm_gl_option_get_description(option);
		g_object_unref(option);
		
		option = gcm_gl_option_gconf_new(self->name, "load_before", 
										 GCM_GL_OPTION_SCREEN_NONE);
		self->load_before = gcm_gl_option_get_string_list(option);
		g_object_unref(option);
		
		option = gcm_gl_option_gconf_new(self->name, "requires", 
										 GCM_GL_OPTION_SCREEN_NONE);
		self->requires = gcm_gl_option_get_string_list(option);
		g_object_unref(option);
		
		return TRUE;
	}}
#line 319 "gcm-gl-plugin.c"
#undef __GOB_FUNCTION__
