/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gcm-application.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 27 "gcm-application.gob"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define WNCK_I_KNOW_THIS_IS_UNSTABLE 1
#define SN_API_NOT_YET_FROZEN 1
#include <unistd.h>
#include <libwnck/screen.h>
#include <libwnck/window.h>

#include <signal.h>
#include <stdlib.h>

#line 39 "gcm-application.c"
/* self casting macros */
#define SELF(x) GCM_APPLICATION(x)
#define SELF_CONST(x) GCM_APPLICATION_CONST(x)
#define IS_SELF(x) GCM_IS_APPLICATION(x)
#define TYPE_SELF GCM_TYPE_APPLICATION
#define SELF_CLASS(x) GCM_APPLICATION_CLASS(x)

#define SELF_GET_CLASS(x) GCM_APPLICATION_GET_CLASS(x)

/* self typedefs */
typedef GCMApplication Self;
typedef GCMApplicationClass SelfClass;

struct _GCMApplicationPrivate {
#line 44 "gcm-application.gob"
	gchar * name;
#line 51 "gcm-application.gob"
	gchar * real_name;
#line 53 "gcm-application.gob"
	GList * argv;
#line 73 "gcm-application.gob"
	gint pid;
#line 74 "gcm-application.gob"
	GIOChannel * fdstdout;
#line 76 "gcm-application.gob"
	GIOChannel * fdstderr;
#line 66 "gcm-application.c"
};
/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void gcm_application_init (GCMApplication * o) G_GNUC_UNUSED;
static void gcm_application_class_init (GCMApplicationClass * c) G_GNUC_UNUSED;
static gboolean gcm_application_set_focus (GCMApplication * self) G_GNUC_UNUSED;
static gboolean gcm_application_child_event (GIOChannel * fd, GIOCondition condition, GCMApplication * self) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__data(object,func,data)	gcm_application_connect__data((object),(func),(data))
#define self_connect_after__data(object,func,data)	gcm_application_connect_after__data((object),(func),(data))
#define self_connect_data__data(object,func,data,destroy_data,flags)	gcm_application_connect_data__data((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (GCMApplication *, gchar *, gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((GCMApplication *)data1,
		(gchar *) g_value_get_string (param_values + 1),
		data2);
}


enum {
	DATA_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_NAME,
	PROP_ARGV
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_name gcm_application_get_name
#define self_set_name gcm_application_set_name
#define self_set_argv gcm_application_set_argv
#define self_data gcm_application_data
#define self_new gcm_application_new
#define self_run gcm_application_run
#define self_start gcm_application_start
#define self_stop gcm_application_stop
#define self_get_pid gcm_application_get_pid
#define self_set_focus gcm_application_set_focus
#define self_child_event gcm_application_child_event
GType
gcm_application_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GCMApplicationClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gcm_application_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GCMApplication),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gcm_application_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GCMApplication", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GCMApplication *)g_object_new(gcm_application_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GCMApplication * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GCMApplication *
GET_NEW_VARG (const char *first, ...)
{
	GCMApplication *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GCMApplication *)g_object_new_valist (gcm_application_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "GCM:Application::finalize"
	GCMApplication *self G_GNUC_UNUSED = GCM_APPLICATION (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 45 "gcm-application.gob"
	if(self->_priv->name) { g_free ((gpointer) self->_priv->name); self->_priv->name = NULL; }
#line 196 "gcm-application.c"
#line 52 "gcm-application.gob"
	if(self->_priv->real_name) { g_free ((gpointer) self->_priv->real_name); self->_priv->real_name = NULL; }
#line 199 "gcm-application.c"
#define argv (self->_priv->argv)
#define VAR argv
	{
#line 54 "gcm-application.gob"
	
			if (argv)
			{
				g_list_foreach(argv, (GFunc)g_free, NULL);
				g_list_free(argv);
			}
	    }
#line 211 "gcm-application.c"
	memset(&argv, 0, sizeof(argv));
#undef VAR
#undef argv
#line 75 "gcm-application.gob"
	if(self->_priv->fdstdout) { g_io_channel_unref ((gpointer) self->_priv->fdstdout); self->_priv->fdstdout = NULL; }
#line 217 "gcm-application.c"
#line 77 "gcm-application.gob"
	if(self->_priv->fdstderr) { g_io_channel_unref ((gpointer) self->_priv->fdstderr); self->_priv->fdstderr = NULL; }
#line 220 "gcm-application.c"
}
#undef __GOB_FUNCTION__

static void 
gcm_application_init (GCMApplication * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GCM:Application::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,GCM_TYPE_APPLICATION,GCMApplicationPrivate);
}
#undef __GOB_FUNCTION__
static void 
gcm_application_class_init (GCMApplicationClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "GCM:Application::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(GCMApplicationPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[DATA_SIGNAL] =
		g_signal_new ("data",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (GCMApplicationClass, data),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_STRING);
	if ___GOB_UNLIKELY(sizeof(gchar * ) != sizeof(gchar *) || parent_class == NULL /* avoid warning */) {
		g_error("gcm-application.gob line 80: Type mismatch of \"data\" signal signature");
	}

	c->data = NULL;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("name" /* name */,
		 "Name" /* nick */,
		 "Application filename" /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_NAME,
		param_spec);
	param_spec = g_param_spec_pointer
		("argv" /* name */,
		 "Argv" /* nick */,
		 "Application arguments" /* blurb */,
		 (GParamFlags)(G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_ARGV,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "GCM:Application::set_property"
{
	GCMApplication *self G_GNUC_UNUSED;

	self = GCM_APPLICATION (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 46 "gcm-application.gob"
{ char *old = self->_priv->name; self->_priv->name = g_value_dup_string (VAL); g_free (old); }
#line 298 "gcm-application.c"
		}
		break;
	case PROP_ARGV:
		{
#line 65 "gcm-application.gob"

			if (selfp->argv)
			{
				g_list_foreach(selfp->argv, (GFunc)g_free, NULL);
				g_list_free(selfp->argv);
			}
			selfp->argv = (GList *)g_value_get_pointer(VAL);
	    
#line 312 "gcm-application.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "GCM:Application::get_property"
{
	GCMApplication *self G_GNUC_UNUSED;

	self = GCM_APPLICATION (object);

	switch (property_id) {
	case PROP_NAME:
		{
#line 46 "gcm-application.gob"
g_value_set_string (VAL, self->_priv->name);
#line 343 "gcm-application.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 46 "gcm-application.gob"
gchar * 
gcm_application_get_name (GCMApplication * self)
#line 363 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::get_name"
{
#line 46 "gcm-application.gob"
		gchar* val; g_object_get (G_OBJECT (self), "name", &val, NULL); return val;
}}
#line 370 "gcm-application.c"
#undef __GOB_FUNCTION__

#line 46 "gcm-application.gob"
void 
gcm_application_set_name (GCMApplication * self, gchar * val)
#line 376 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::set_name"
{
#line 46 "gcm-application.gob"
		g_object_set (G_OBJECT (self), "name", val, NULL);
}}
#line 383 "gcm-application.c"
#undef __GOB_FUNCTION__

#line 65 "gcm-application.gob"
void 
gcm_application_set_argv (GCMApplication * self, gpointer val)
#line 389 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::set_argv"
{
#line 61 "gcm-application.gob"
		g_object_set (G_OBJECT (self), "argv", val, NULL);
}}
#line 396 "gcm-application.c"
#undef __GOB_FUNCTION__

#line 80 "gcm-application.gob"
void 
gcm_application_data (GCMApplication * self, gchar * buffer)
#line 402 "gcm-application.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 80 "gcm-application.gob"
	g_return_if_fail (self != NULL);
#line 80 "gcm-application.gob"
	g_return_if_fail (GCM_IS_APPLICATION (self));
#line 414 "gcm-application.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_STRING);
	g_value_set_static_string (&___param_values[1], (gchar *) buffer);

	g_signal_emitv (___param_values,
		object_signals[DATA_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}

/**
 * gcm_application_new:
 * @name: application name
 * @real_name: application name in process list if NULL same that name
 * @argv: application arguments 
 *
 * Create a new application launcher
 *
 * Returns: #GCMApplication
 **/
#line 93 "gcm-application.gob"
GCMApplication * 
gcm_application_new (gchar * name, gchar * real_name, GList * argv)
#line 446 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::new"
#line 93 "gcm-application.gob"
	g_return_val_if_fail (name != NULL, (GCMApplication * )NULL);
#line 451 "gcm-application.c"
{
#line 95 "gcm-application.gob"
	
		GCMApplication * self = GET_NEW;
		
		/* Check program */
		if ((selfp->name = g_find_program_in_path(name)) == NULL)
		{
			g_object_unref(self);
			return NULL;
		}
		if (real_name)
			 selfp->real_name = g_find_program_in_path(real_name);
		if (!selfp->real_name)
			selfp->real_name = g_strdup(selfp->name);
		
		if (argv) selfp->argv = argv;
		
		return self;
	}}
#line 472 "gcm-application.c"
#undef __GOB_FUNCTION__

/**
 * gcm_application_run:
 * @self: #GCMApplication
 *
 * Run application
 *
 * Returns: standard output or NUL if fail
 **/
#line 122 "gcm-application.gob"
gchar * 
gcm_application_run (GCMApplication * self)
#line 486 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::run"
#line 122 "gcm-application.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 122 "gcm-application.gob"
	g_return_val_if_fail (GCM_IS_APPLICATION (self), (gchar * )0);
#line 493 "gcm-application.c"
{
#line 124 "gcm-application.gob"
	
		gchar * buffer = NULL;
		gchar ** argv;
			
		argv = g_new0(gchar *, 2);
		argv[0] = g_strdup(selfp->name);
		if (selfp->argv)
		{
			GList * item;
			gint cpt = 0;
			
			for(item = g_list_first(selfp->argv); item; item = item->next)
			{
				argv = g_renew(gchar *, argv, cpt + 3);
				argv[cpt + 1] = g_strdup((gchar *)item->data);
				argv[cpt + 2] = NULL;
				cpt++;
			}
		}
		g_spawn_sync(NULL, argv, NULL, 
					 G_SPAWN_SEARCH_PATH,
					 NULL, NULL,
					 &buffer, NULL, NULL, NULL);
		
		return buffer;
	}}
#line 522 "gcm-application.c"
#undef __GOB_FUNCTION__

/**
 * gcm_application_start:
 * @self: #GCMApplication
 *
 * Launch application
 *
 * Returns: TRUE application is started
 **/
#line 159 "gcm-application.gob"
gboolean 
gcm_application_start (GCMApplication * self)
#line 536 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::start"
#line 159 "gcm-application.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 159 "gcm-application.gob"
	g_return_val_if_fail (GCM_IS_APPLICATION (self), (gboolean )0);
#line 543 "gcm-application.c"
{
#line 161 "gcm-application.gob"
	
		gint fdstdout, fdstderr;
		
		self_get_pid(self);
		
		if (selfp->pid) 
		{
			self_set_focus(self);
			return TRUE;
		}
		else
		{
			gchar ** argv;
			gboolean result;
			
			argv = g_new0(gchar *, 2);
			argv[0] = g_strdup(selfp->name);
			if (selfp->argv)
			{
				GList * item;
				gint cpt = 0;
				
				for(item = g_list_first(selfp->argv); item; item = item->next)
				{
					argv = g_renew(gchar *, argv, cpt + 3);
					argv[cpt + 1] = g_strdup((gchar *)item->data);
					argv[cpt + 2] = NULL;
					cpt++;
				}
			}
	
			result = g_spawn_async_with_pipes(NULL, argv, NULL, 
											  G_SPAWN_SEARCH_PATH,
											  NULL, NULL,
											  &selfp->pid, NULL,
											  &fdstdout, &fdstderr, NULL);
			g_strfreev(argv);
			
			if (result)
			{
				selfp->fdstdout = g_io_channel_unix_new(fdstdout);
				g_io_channel_set_encoding(selfp->fdstdout, NULL, NULL);
				g_io_channel_set_buffered(selfp->fdstdout, FALSE);
				g_io_channel_set_close_on_unref(selfp->fdstdout, TRUE);
				g_io_channel_set_flags(selfp->fdstdout, 
									   g_io_channel_get_flags(selfp->fdstdout) & G_IO_FLAG_NONBLOCK, 
									   NULL);
				selfp->fdstderr = g_io_channel_unix_new(fdstderr);
				g_io_channel_set_encoding(selfp->fdstderr, NULL, NULL);
				g_io_channel_set_buffered(selfp->fdstderr, FALSE);
				g_io_channel_set_close_on_unref(selfp->fdstderr, TRUE);
				g_io_channel_set_flags(selfp->fdstderr, 
									   g_io_channel_get_flags(selfp->fdstdout) & G_IO_FLAG_NONBLOCK, 
									   NULL);
		
				g_io_add_watch(selfp->fdstdout, G_IO_IN | G_IO_ERR | G_IO_HUP | G_IO_NVAL, 
							   (GIOFunc)self_child_event, (gpointer)self);
				g_io_add_watch(selfp->fdstderr, G_IO_IN | G_IO_ERR | G_IO_HUP | G_IO_NVAL, 
							   (GIOFunc)self_child_event, (gpointer)self);
			}
			
			return result;
		}
	}}
#line 610 "gcm-application.c"
#undef __GOB_FUNCTION__

/**
 * gcm_application_stop:
 * @self: #GCMApplication
 *
 * get application process id
 *
 * Returns: PID or if 0 isn't started
 **/
#line 232 "gcm-application.gob"
void 
gcm_application_stop (GCMApplication * self)
#line 624 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::stop"
#line 232 "gcm-application.gob"
	g_return_if_fail (self != NULL);
#line 232 "gcm-application.gob"
	g_return_if_fail (GCM_IS_APPLICATION (self));
#line 631 "gcm-application.c"
{
#line 234 "gcm-application.gob"
	
		if (selfp->pid) 
			kill(selfp->pid, SIGTERM);
		selfp->pid = 0;
	}}
#line 639 "gcm-application.c"
#undef __GOB_FUNCTION__

#line 248 "gcm-application.gob"
gint 
gcm_application_get_pid (GCMApplication * self)
#line 645 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::get_pid"
#line 248 "gcm-application.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 248 "gcm-application.gob"
	g_return_val_if_fail (GCM_IS_APPLICATION (self), (gint )0);
#line 652 "gcm-application.c"
{
#line 250 "gcm-application.gob"
	
		GDir * procdir;
		gchar * item;
		
		selfp->pid = 0;
		
		if ((procdir = g_dir_open("/proc", 0, NULL)) == NULL)
			return selfp->pid;
		
		while ((item = (gchar *)g_dir_read_name(procdir)) != NULL)
		{
			gchar * itemdir = g_strdup_printf("/proc/%s", item);
			
			if (g_file_test(itemdir,  G_FILE_TEST_IS_DIR))
			{
				GIOChannel * fd;
				gchar * filename = g_strdup_printf("/proc/%s/cmdline", item);
				
				if ((fd = g_io_channel_new_file(filename, "r", NULL)) != NULL)
				{
					gchar * cmdline;
				
					if (g_io_channel_read_line(fd, &cmdline, NULL, NULL, NULL) == G_IO_STATUS_NORMAL)
					{
						gchar * tmp1 = g_path_get_basename(cmdline);
						gchar * tmp2 = g_path_get_basename(selfp->real_name);
						
						if (strcmp(tmp1, tmp2) == 0)
						{
							selfp->pid = atoi(item);
							g_free(tmp1);
							g_free(tmp2);
							g_free(cmdline);
							g_free(filename);
							g_io_channel_unref(fd);
							break;
						}
						g_free(tmp1);
						g_free(tmp2);
						g_free(cmdline);
						g_io_channel_unref(fd);
					}
				}
				g_free(filename);
			}
			g_free(itemdir);
		}
		g_dir_close(procdir);
		
		return selfp->pid;
	}}
#line 706 "gcm-application.c"
#undef __GOB_FUNCTION__

#line 302 "gcm-application.gob"
static gboolean 
gcm_application_set_focus (GCMApplication * self)
#line 712 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::set_focus"
#line 302 "gcm-application.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 302 "gcm-application.gob"
	g_return_val_if_fail (GCM_IS_APPLICATION (self), (gboolean )0);
#line 719 "gcm-application.c"
{
#line 304 "gcm-application.gob"
	
		WnckScreen* screen;
		GList* windows;
		gint cpt, nb;
	
		screen = wnck_screen_get_default();
    	wnck_screen_force_update(screen);
    	windows = wnck_screen_get_windows(screen);
		nb = g_list_length(windows);
	
		for (cpt = 0; cpt < nb; cpt++)
		{
			WnckWindow * window = g_list_nth_data(windows, cpt);
			
			if (wnck_window_get_pid(window) == selfp->pid)
			{
				wnck_window_activate(window, 0);
				return TRUE;
			}
		}
		return FALSE;
	}}
#line 744 "gcm-application.c"
#undef __GOB_FUNCTION__

#line 327 "gcm-application.gob"
static gboolean 
gcm_application_child_event (GIOChannel * fd, GIOCondition condition, GCMApplication * self)
#line 750 "gcm-application.c"
{
#define __GOB_FUNCTION__ "GCM:Application::child_event"
#line 327 "gcm-application.gob"
	g_return_val_if_fail (self != NULL, (gboolean )FALSE);
#line 755 "gcm-application.c"
{
#line 330 "gcm-application.gob"
	
        g_return_val_if_fail(GCM_IS_APPLICATION(self), FALSE);
        
		if ((condition & G_IO_HUP) || (condition & G_IO_NVAL) || (condition & G_IO_ERR))
		{
			if (selfp->fdstdout) g_io_channel_unref(selfp->fdstdout);
			selfp->fdstdout = NULL;
			if (selfp->fdstderr) g_io_channel_unref(selfp->fdstderr);
			selfp->fdstderr = NULL;
			return FALSE;
		}
		else if (condition & G_IO_IN)
		{
			gchar buffer[1025];
			gsize nb = 0;
			
			bzero(buffer, sizeof(buffer));
			if (g_io_channel_read_chars(fd, buffer, 1024, &nb, NULL) == G_IO_STATUS_ERROR)
				return TRUE;
					
			if (nb)
			{
				gint cpt;
				gchar ** line = g_strsplit(buffer, "\n", -1);
				
				for (cpt = 0; line && line[cpt]; cpt++)
				{
					gchar * esc_buffer = g_strescape(line[cpt], NULL);
					gchar * utf8_buffer = g_locale_to_utf8(esc_buffer, -1, NULL, NULL, NULL);
					
					g_free(esc_buffer);
					
					self_data(self, utf8_buffer);
					
					g_free(utf8_buffer );
				}
				if (line) g_strfreev(line);
			}
		}
		return TRUE;
	}}
#line 799 "gcm-application.c"
#undef __GOB_FUNCTION__
