#ifndef __GM_SEARCHABLE_H__
#define __GM_SEARCHABLE_H__

#include <gtk/gtk.h>
#include <glib.h>

#define GM_TYPE_SEARCHABLE			(gm_searchable_get_type())
#define GM_SEARCHABLE(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_SEARCHABLE, GmSearchable))
#define GM_SEARCHABLE_CLASS(obj)	(G_TYPE_CHECK_CLASS_CAST((obj), \
		GM_TYPE_SEARCHABLE, GmSearchableInterface))
#define GM_IS_SEARCHABLE(obj)	(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_SEARCHABLE))
#define GM_SEARCHABLE_GET_INTERFACE(inst) (G_TYPE_INSTANCE_GET_INTERFACE( \
		(inst), GM_TYPE_SEARCHABLE, GmSearchableInterface))

typedef struct _GmSearchable GmSearchable; /* dummy object */
typedef struct _GmSearchableInterface GmSearchableInterface;

typedef enum _GmSearchableSearchFlags {
	GM_SEARCHABLE_SEARCH_NONE = 0,
	GM_SEARCHABLE_SEARCH_FORWARDS = 1 << 0,
	GM_SEARCHABLE_SEARCH_BACKWARDS = 1 << 1,
	GM_SEARCHABLE_SEARCH_CASE_INSENSITIVE = 1 << 2
} GmSearchableSearchFlags;

struct _GmSearchableInterface {
	GTypeInterface parent;

	GtkTextView *(* get_text_view) (GmSearchable *self);
	gboolean (* find_first) (GmSearchable *self, gchar const *str, 
			GmSearchableSearchFlags flags);
	gboolean (* find_next) (GmSearchable *self, gchar const *str, 
			GmSearchableSearchFlags flags);
		
	gboolean (* replace) (GmSearchable *self, gchar const *replace);
	gboolean (* replace_all) (GmSearchable *self, gchar const *str, 
			gchar const *replace, GmSearchableSearchFlags flags);
};

GType gm_searchable_get_type();

GtkTextView *gm_searchable_get_text_view(GmSearchable *self);
gboolean gm_searchable_can_find(GmSearchable *self);
gboolean gm_searchable_find_first(GmSearchable *self, const gchar *str,
		GmSearchableSearchFlags flags);
gboolean gm_searchable_find_next(GmSearchable *self, const gchar *str,
		GmSearchableSearchFlags flags);
		
gboolean gm_searchable_can_replace(GmSearchable *self);
gboolean gm_searchable_replace(GmSearchable *self, gchar const *replace);
gboolean gm_searchable_replace_all(GmSearchable *self, gchar const *str,
		gchar const *replace, GmSearchableSearchFlags flags);

#endif /* __GM_SEARCHABLE_H__ */
