// Scene_as.hx:  ActionScript 3 "Scene" class, for Gnash.
//
// Generated by gen-as3.sh on: 20090514 by "rob". Remove this
// after any hand editing loosing changes.
//
//   Copyright (C) 2009 Free Software Foundation, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

// This test case must be processed by CPP before compiling to include the
//  DejaGnu.hx header file for the testing framework support.

#if flash9
import flash.display.Scene;
import flash.display.MovieClip;
import flash.display.FrameLabel;
#end
import flash.Lib;
import Type;

// import our testing API
import DejaGnu;
import Std;

// Class must be named with the _as suffix, as that's the same name as the file.
class Scene_as {
    static function main() {
        #if !flash9
			DejaGnu.note("This test is only valid for AS3 -- flash v.9 and higher");
		#end
		#if flash9
		var x1:FrameLabel = new FrameLabel("Label 1", 5);
		var x2:FrameLabel = new FrameLabel("Label 2", 25);
		var x3:FrameLabel = new FrameLabel("Label 3", 100);
		var x4:Scene = new Scene("My New Scene", [x1,x2,x3], 200);

        // Make sure we actually get a valid class        
        if (x4 != null) {
            DejaGnu.pass("Scene class exists");
        } else {
            DejaGnu.fail("Scene lass doesn't exist");
        }
// Tests to see if all the properties exist. All these do is test for
// existance of a property, and don't test the functionality at all. This
// is primarily useful only to test completeness of the API implementation.
	if ((Std.is(x4.name, String)) && (Std.string(x4.name) == "My New Scene")) {
	    DejaGnu.pass("Scene::name has correct type and string");
	} else {
	    DejaGnu.fail("Scene::name property doesn't exist (either value type is wrong or name changed from what's expected");
	}
	if ((Type.typeof(x4.numFrames) == ValueType.TInt) && (x4.numFrames == 200)) {
	    DejaGnu.pass("Scene::numFrames has correct type and value.");
	} else {
	    DejaGnu.fail("Scene::numFrames either has wrong type or value changed from what's expected.");
	}	
 	if (Std.is(x4.labels, Array) && (x4.labels[0].name == "Label 1") && (x4.labels[0].frame == 5)
	&& (x4.labels[1].name == "Label 2") && (x4.labels[1].frame == 25) && (x4.labels[2].name == "Label 3")
	&& (x4.labels[2].frame == 100)){
 	    DejaGnu.pass("Scene::labels array has correct values and type");
 	} else {
 	    DejaGnu.fail("Scene::labels property has something wrong, check values");
 	}

	#end
        // Call this after finishing all tests. It prints out the totals.
        DejaGnu.done();
    }
}

// local Variables:
// mode: C++
// indent-tabs-mode: t
// End:

