------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-date.ads,v 1.6 2004/08/23 13:41:32 vagul Exp $

with Ada.Calendar;

package OCI.Thick.Date is

   type OCIDate is new Lib.OCIDate;

   type Compare_Result is new Integer range -1 .. 1;

   function To_String (From : OCIDate; Format : String) return String;

   function To_Date (Item : String; Format : String) return OCIDate;

   function To_Ada (DT : in OCIDate) return Ada.Calendar.Time;

   function To_OCI (DT : in Ada.Calendar.Time) return OCIDate;

   function SysDate return OCIDate;

   function Compare (Left, Right : OCIDate) return Compare_Result;

   function "<" (Left, Right : OCIDate) return Boolean;

   function ">" (Left, Right : OCIDate) return Boolean;

   function Equal (Left, Right : OCIDate) return Boolean;
   --  The name is not "=" to avoid conflict with Standard "="
   --  operator.

   function "<=" (Left, Right : OCIDate) return Boolean;

   function ">=" (Left, Right : OCIDate) return Boolean;

   pragma Inline ("<", ">", "<=", ">=", Equal);

   Init_OCIDate : constant OCIDate;

private

   Init_OCIDate : constant OCIDate := (
      OCIDateYYYY => 0, -- gregorian year; range is -4712 <= year <= 9999
      OCIDateMM   => 1, -- month; range is 1 <= month < 12
      OCIDateDD   => 1, -- day; range is 1 <= day <= 31
      OCIDateTime => (
         OCITimeHH => 0, -- hours; range is 0 <= hours <=23
         OCITimeMI => 0, -- minutes; range is 0 <= minutes <= 59
         OCITimeSS => 0) -- seconds; range is 0 <= seconds <= 59
     );

end OCI.Thick.Date;
