-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/lista4/data_bind.adb,v $
--  Description     : binding package
--  Author          : Julio Cano                                             --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/01/08 19:58:50 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Julio Cano                                            --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Julio Cano  <julius_bip@yahoo.com>                               --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Text_Io;
with Ada.Strings.Fixed;
with Unchecked_Deallocation;

with Gnu.Db.Sqlcli;
use Gnu.Db.Sqlcli;


package body Data_Bind is


procedure DataFix (Elem : access Data_List) is
begin
   Text_Io.Put_Line ("no DISPATCHINGGGG");
end;

procedure DataFix (Elem : access String_Data) is
begin
   SQLFixNTS (Elem.Binded.all, Elem.Data_Length);
--   Elem.Data := new String'(Elem.Binded.all);
   Ada.Strings.Fixed.Move (Elem.Binded.all, Elem.Data.all);
--   Text_Io.Put_Line ("**"&String(Elem.Binded.all));
--   Text_Io.Put_Line ("***"&Elem.Data.all);
end DataFix;

procedure DataListFix ( List : Base_Data) is
Tmp : Base_Data;
begin
   Tmp := List;
   while Tmp /= null loop
      DataFix (Tmp);
      Tmp := Tmp.Next;
   end loop;
end DataListFix;


function Name2col (
      Stmt   : Sqlhstmt;
      Column : Unbounded_String )
  return Sql_Column_Number is
   Name    : Unbounded_String;
   Ucolumn : Unbounded_String := Column;

   Datatype :
   aliased Sql_Data_Type;
   Col_Size :
   aliased Sqluinteger;
   Decimaldigits :
   aliased Sqlsmallint;
   Nullable :
   aliased Sql_Nullable_Info;
   Errorcode :
   aliased Sqlreturn;
begin
   Trim (Ucolumn, Ada.Strings.Both);

   for I in 1..Sqlnumresultcols(Stmt) loop
      Name := To_Unbounded_String(
         Sqldescribecol (Stmt, Sql_Column_Number(I),
            Sqlsmallint(256),
            Datatype'access,
            Col_Size'access,
            Decimaldigits'access,
            Nullable'access,
            Errorcode'access));

      Trim (Name, Ada.Strings.Both);
      if Ucolumn = Name then
         return I;
      end if;
   end loop;
   return 0;
end;


procedure Binddata (
      Data : access Data_List;
      Stmt : Sqlhstmt   ) is
begin
   Text_Io.Put_Line ("NO DISPATCHING!!!!!!!!!");
   null;
end;

procedure Binddata (
      Data : access String_Data;
      Stmt : Sqlhstmt         ) is
begin
   Data.Binded := new Sql_Str;

   Sb.Sqlbindcol (Stmt, Name2col(Stmt, Data.Field),
      Sql_C_Char, Data.Binded , Data.Binded.all'Length, Data.Data_Length'access);
   --      Sb.Sqlbindcol (Recordset.Resultado, Name2col(Recordset.Resultado,
   --            List.Field),
   --         Sql_C_Char, List.Data'access, List.Data'Length, List.Data_Length'access);
   exception
      when INVALID_HANDLE => null; -- Data not binded, not statemente ready yet
end;

procedure Binddatalist (
      List : Base_Data;
      Stmt : Sqlhstmt   ) is
Tmp : Base_Data := List;
begin

   while tmp /= null loop
      Binddata (tmp, Stmt);
      tmp := Tmp.Next;
   end loop;
end;

procedure Registerdata (
      List   : in out Base_Data;
      Data   : String_Access;
      Column : String           ) is
   Elem  : String_Data_Ptr;
   Tmp : Base_Data;
begin
   Elem := new String_Data'(
                            Field       => To_Unbounded_String (Column),
                            Next        => null,
                            Data        => Data,
                            Data_Length => 0,
                            Binded => null);

   Tmp := List;
   if List = null then
      List := Base_Data(Elem);
   else
      while Tmp.Next /= null loop
         Tmp := Tmp.Next;
      end loop;
      Tmp.Next := Base_Data(Elem);
   end if;
end Registerdata;

procedure UnRegisterdata (
      List   : in out Base_Data;
      Column : String           ) is
   type Data_list_ptr is access all Data_List;
   procedure Free is new unchecked_deallocation(Data_List, Data_list_ptr);
   -- Freed needs no class wide access
   Elem  : Data_List_Ptr;
   Tmp : Base_Data;

begin
   Tmp := List;
   if List /= null then
      if Tmp.Field = Column then
         List := List.Next;
         Elem := Data_List_Ptr(Tmp);
         Free (Elem);
      else
         while Tmp.Next /= null loop
            if Tmp.Next.Field = Column then
               Elem := Data_List_Ptr(Tmp.Next);
               Tmp.Next := Tmp.Next.Next;
               Free (Elem);
            end if;
         end loop;
      end if;
   end if;
end UnRegisterdata;


procedure UnregisterAll (List : in out Base_Data) is
   type Data_list_ptr is access all Data_List;
   procedure Free is new unchecked_deallocation(Data_List, Data_list_ptr);
   Elem  : Data_List_Ptr;
   Tmp : Base_Data;
begin
   Tmp := List;
   while Tmp /= Null loop
      Elem := Data_List_Ptr(Tmp);
      Tmp := Tmp.Next;
      Free (Elem);
   end loop;
   List := NULL;
end;

end Data_Bind;
