------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-gen_ocinumber.adb,v 1.3 2003/04/01 04:46:59 vagul Exp $

with OCI.Thread;

package body OCI.Thick.Gen_OCINumber is

   --------------------
   -- Unary_Operator --
   --------------------

   function Unary_Function (Item : OCINumber) return OCINumber is
      Result : aliased OCINumber;
      rc     : SWord := OCINumberOper(Thread.Error, Item, Result'Access);
   begin
      Check_Error (rc);
      return Result;
   end Unary_Function;

   ---------------------
   -- Binary_Operator --
   ---------------------

   function Binary_Function (Left,Right : OCINumber) return OCINumber is
      Result : aliased OCINumber;
      rc : SWord := OCINumberOper (Thread.Error, Left, Right, Result'Access);
   begin
      Check_Error(rc);
      return Result;
   end Binary_Function;

end OCI.Thick.Gen_OCINumber;

