// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/services/reach_plan_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [ReachForecastService.ListPlannableLocations][]
type ListPlannableLocationsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPlannableLocationsRequest) Reset()         { *m = ListPlannableLocationsRequest{} }
func (m *ListPlannableLocationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPlannableLocationsRequest) ProtoMessage()    {}
func (*ListPlannableLocationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{0}
}

func (m *ListPlannableLocationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableLocationsRequest.Unmarshal(m, b)
}
func (m *ListPlannableLocationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableLocationsRequest.Marshal(b, m, deterministic)
}
func (m *ListPlannableLocationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableLocationsRequest.Merge(m, src)
}
func (m *ListPlannableLocationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPlannableLocationsRequest.Size(m)
}
func (m *ListPlannableLocationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableLocationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableLocationsRequest proto.InternalMessageInfo

// The list of plannable locations.
type ListPlannableLocationsResponse struct {
	// The list of locations available for planning (Countries, DMAs,
	// sub-countries).
	// For locations like Countries, DMAs see
	// https://developers.google.com/adwords/api/docs/appendix/geotargeting for
	// more information.
	PlannableLocations   []*PlannableLocation `protobuf:"bytes,1,rep,name=plannable_locations,json=plannableLocations,proto3" json:"plannable_locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListPlannableLocationsResponse) Reset()         { *m = ListPlannableLocationsResponse{} }
func (m *ListPlannableLocationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPlannableLocationsResponse) ProtoMessage()    {}
func (*ListPlannableLocationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{1}
}

func (m *ListPlannableLocationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableLocationsResponse.Unmarshal(m, b)
}
func (m *ListPlannableLocationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableLocationsResponse.Marshal(b, m, deterministic)
}
func (m *ListPlannableLocationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableLocationsResponse.Merge(m, src)
}
func (m *ListPlannableLocationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPlannableLocationsResponse.Size(m)
}
func (m *ListPlannableLocationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableLocationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableLocationsResponse proto.InternalMessageInfo

func (m *ListPlannableLocationsResponse) GetPlannableLocations() []*PlannableLocation {
	if m != nil {
		return m.PlannableLocations
	}
	return nil
}

// A plannable location: a country, a DMA, a metro region, a tv region,
// a province.
type PlannableLocation struct {
	// The location identifier.
	Id *wrappers.StringValue `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The unique location name in english.
	Name *wrappers.StringValue `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The parent country code, not present if location is a country.
	// If present will always be a criterion id: additional information, such as
	// country name are returned both via ListPlannableLocations or directly by
	// accessing GeoTargetConstantService with the criterion id.
	ParentCountryId      *wrappers.Int64Value `protobuf:"bytes,3,opt,name=parent_country_id,json=parentCountryId,proto3" json:"parent_country_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlannableLocation) Reset()         { *m = PlannableLocation{} }
func (m *PlannableLocation) String() string { return proto.CompactTextString(m) }
func (*PlannableLocation) ProtoMessage()    {}
func (*PlannableLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{2}
}

func (m *PlannableLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannableLocation.Unmarshal(m, b)
}
func (m *PlannableLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannableLocation.Marshal(b, m, deterministic)
}
func (m *PlannableLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannableLocation.Merge(m, src)
}
func (m *PlannableLocation) XXX_Size() int {
	return xxx_messageInfo_PlannableLocation.Size(m)
}
func (m *PlannableLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannableLocation.DiscardUnknown(m)
}

var xxx_messageInfo_PlannableLocation proto.InternalMessageInfo

func (m *PlannableLocation) GetId() *wrappers.StringValue {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *PlannableLocation) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *PlannableLocation) GetParentCountryId() *wrappers.Int64Value {
	if m != nil {
		return m.ParentCountryId
	}
	return nil
}

// Request to list available products in a given location.
type ListPlannableProductsRequest struct {
	// Required. The ID of the selected location for planning. To list the available
	// plannable location ids use ListPlannableLocations.
	PlannableLocationId  *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListPlannableProductsRequest) Reset()         { *m = ListPlannableProductsRequest{} }
func (m *ListPlannableProductsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPlannableProductsRequest) ProtoMessage()    {}
func (*ListPlannableProductsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{3}
}

func (m *ListPlannableProductsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableProductsRequest.Unmarshal(m, b)
}
func (m *ListPlannableProductsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableProductsRequest.Marshal(b, m, deterministic)
}
func (m *ListPlannableProductsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableProductsRequest.Merge(m, src)
}
func (m *ListPlannableProductsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPlannableProductsRequest.Size(m)
}
func (m *ListPlannableProductsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableProductsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableProductsRequest proto.InternalMessageInfo

func (m *ListPlannableProductsRequest) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

// A response with all available products.
type ListPlannableProductsResponse struct {
	// The list of products available for planning and related targeting metadata.
	ProductMetadata      []*ProductMetadata `protobuf:"bytes,1,rep,name=product_metadata,json=productMetadata,proto3" json:"product_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListPlannableProductsResponse) Reset()         { *m = ListPlannableProductsResponse{} }
func (m *ListPlannableProductsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPlannableProductsResponse) ProtoMessage()    {}
func (*ListPlannableProductsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{4}
}

func (m *ListPlannableProductsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableProductsResponse.Unmarshal(m, b)
}
func (m *ListPlannableProductsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableProductsResponse.Marshal(b, m, deterministic)
}
func (m *ListPlannableProductsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableProductsResponse.Merge(m, src)
}
func (m *ListPlannableProductsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPlannableProductsResponse.Size(m)
}
func (m *ListPlannableProductsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableProductsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableProductsResponse proto.InternalMessageInfo

func (m *ListPlannableProductsResponse) GetProductMetadata() []*ProductMetadata {
	if m != nil {
		return m.ProductMetadata
	}
	return nil
}

// The metadata associated with an available plannable product.
type ProductMetadata struct {
	// The code associated with the ad product. E.g. Trueview, Bumper
	// To list the available plannable product codes use ListPlannableProducts.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// The allowed plannable targeting for this product.
	PlannableTargeting   *PlannableTargeting `protobuf:"bytes,2,opt,name=plannable_targeting,json=plannableTargeting,proto3" json:"plannable_targeting,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ProductMetadata) Reset()         { *m = ProductMetadata{} }
func (m *ProductMetadata) String() string { return proto.CompactTextString(m) }
func (*ProductMetadata) ProtoMessage()    {}
func (*ProductMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{5}
}

func (m *ProductMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductMetadata.Unmarshal(m, b)
}
func (m *ProductMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductMetadata.Marshal(b, m, deterministic)
}
func (m *ProductMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductMetadata.Merge(m, src)
}
func (m *ProductMetadata) XXX_Size() int {
	return xxx_messageInfo_ProductMetadata.Size(m)
}
func (m *ProductMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ProductMetadata proto.InternalMessageInfo

func (m *ProductMetadata) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *ProductMetadata) GetPlannableTargeting() *PlannableTargeting {
	if m != nil {
		return m.PlannableTargeting
	}
	return nil
}

// The targeting for which traffic metrics will be reported.
type PlannableTargeting struct {
	// Allowed plannable age ranges for the product for which metrics will be
	// reported. Actual targeting is computed by mapping this age range onto
	// standard Google common.AgeRangeInfo values.
	AgeRanges []enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange `protobuf:"varint,1,rep,packed,name=age_ranges,json=ageRanges,proto3,enum=google.ads.googleads.v2.enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange" json:"age_ranges,omitempty"`
	// Targetable genders for the ad product.
	Genders []*common.GenderInfo `protobuf:"bytes,2,rep,name=genders,proto3" json:"genders,omitempty"`
	// Targetable devices for the ad product.
	Devices              []*common.DeviceInfo `protobuf:"bytes,3,rep,name=devices,proto3" json:"devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlannableTargeting) Reset()         { *m = PlannableTargeting{} }
func (m *PlannableTargeting) String() string { return proto.CompactTextString(m) }
func (*PlannableTargeting) ProtoMessage()    {}
func (*PlannableTargeting) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{6}
}

func (m *PlannableTargeting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannableTargeting.Unmarshal(m, b)
}
func (m *PlannableTargeting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannableTargeting.Marshal(b, m, deterministic)
}
func (m *PlannableTargeting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannableTargeting.Merge(m, src)
}
func (m *PlannableTargeting) XXX_Size() int {
	return xxx_messageInfo_PlannableTargeting.Size(m)
}
func (m *PlannableTargeting) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannableTargeting.DiscardUnknown(m)
}

var xxx_messageInfo_PlannableTargeting proto.InternalMessageInfo

func (m *PlannableTargeting) GetAgeRanges() []enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange {
	if m != nil {
		return m.AgeRanges
	}
	return nil
}

func (m *PlannableTargeting) GetGenders() []*common.GenderInfo {
	if m != nil {
		return m.Genders
	}
	return nil
}

func (m *PlannableTargeting) GetDevices() []*common.DeviceInfo {
	if m != nil {
		return m.Devices
	}
	return nil
}

// Request message for [ReachForecastService.GenerateProductMixIdeas][].
type GenerateProductMixIdeasRequest struct {
	// Required. The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The ID of the location, this is one of the ids returned by
	// ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,2,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	// Required. Currency code.
	// Three-character ISO 4217 currency code.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Required. Total budget.
	// Amount in micros. One million is equivalent to one unit.
	BudgetMicros *wrappers.Int64Value `protobuf:"bytes,4,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	// The preferences of the suggested product mix.
	// An unset preference is interpreted as all possible values are allowed,
	// unless explicitly specified.
	Preferences          *Preferences `protobuf:"bytes,5,opt,name=preferences,proto3" json:"preferences,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *GenerateProductMixIdeasRequest) Reset()         { *m = GenerateProductMixIdeasRequest{} }
func (m *GenerateProductMixIdeasRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateProductMixIdeasRequest) ProtoMessage()    {}
func (*GenerateProductMixIdeasRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{7}
}

func (m *GenerateProductMixIdeasRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Unmarshal(m, b)
}
func (m *GenerateProductMixIdeasRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Marshal(b, m, deterministic)
}
func (m *GenerateProductMixIdeasRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateProductMixIdeasRequest.Merge(m, src)
}
func (m *GenerateProductMixIdeasRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Size(m)
}
func (m *GenerateProductMixIdeasRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateProductMixIdeasRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateProductMixIdeasRequest proto.InternalMessageInfo

func (m *GenerateProductMixIdeasRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *GenerateProductMixIdeasRequest) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetPreferences() *Preferences {
	if m != nil {
		return m.Preferences
	}
	return nil
}

// Set of preferences about the planned mix.
type Preferences struct {
	// True if ad skippable.
	// If not set, default is any value.
	IsSkippable *wrappers.BoolValue `protobuf:"bytes,1,opt,name=is_skippable,json=isSkippable,proto3" json:"is_skippable,omitempty"`
	// True if ad start with sound.
	// If not set, default is any value.
	StartsWithSound *wrappers.BoolValue `protobuf:"bytes,2,opt,name=starts_with_sound,json=startsWithSound,proto3" json:"starts_with_sound,omitempty"`
	// The length of the ad.
	// If not set, default is any value.
	AdLength enums.ReachPlanAdLengthEnum_ReachPlanAdLength `protobuf:"varint,3,opt,name=ad_length,json=adLength,proto3,enum=google.ads.googleads.v2.enums.ReachPlanAdLengthEnum_ReachPlanAdLength" json:"ad_length,omitempty"`
	// True if ad will only show on the top content.
	// If not set, default is false.
	TopContentOnly *wrappers.BoolValue `protobuf:"bytes,4,opt,name=top_content_only,json=topContentOnly,proto3" json:"top_content_only,omitempty"`
	// True if the price guaranteed. The cost of serving the ad is agreed upfront
	// and not subject to an auction.
	// If not set, default is any value.
	HasGuaranteedPrice   *wrappers.BoolValue `protobuf:"bytes,5,opt,name=has_guaranteed_price,json=hasGuaranteedPrice,proto3" json:"has_guaranteed_price,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Preferences) Reset()         { *m = Preferences{} }
func (m *Preferences) String() string { return proto.CompactTextString(m) }
func (*Preferences) ProtoMessage()    {}
func (*Preferences) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{8}
}

func (m *Preferences) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Preferences.Unmarshal(m, b)
}
func (m *Preferences) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Preferences.Marshal(b, m, deterministic)
}
func (m *Preferences) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Preferences.Merge(m, src)
}
func (m *Preferences) XXX_Size() int {
	return xxx_messageInfo_Preferences.Size(m)
}
func (m *Preferences) XXX_DiscardUnknown() {
	xxx_messageInfo_Preferences.DiscardUnknown(m)
}

var xxx_messageInfo_Preferences proto.InternalMessageInfo

func (m *Preferences) GetIsSkippable() *wrappers.BoolValue {
	if m != nil {
		return m.IsSkippable
	}
	return nil
}

func (m *Preferences) GetStartsWithSound() *wrappers.BoolValue {
	if m != nil {
		return m.StartsWithSound
	}
	return nil
}

func (m *Preferences) GetAdLength() enums.ReachPlanAdLengthEnum_ReachPlanAdLength {
	if m != nil {
		return m.AdLength
	}
	return enums.ReachPlanAdLengthEnum_UNSPECIFIED
}

func (m *Preferences) GetTopContentOnly() *wrappers.BoolValue {
	if m != nil {
		return m.TopContentOnly
	}
	return nil
}

func (m *Preferences) GetHasGuaranteedPrice() *wrappers.BoolValue {
	if m != nil {
		return m.HasGuaranteedPrice
	}
	return nil
}

// The suggested product mix.
type GenerateProductMixIdeasResponse struct {
	// A list of products (ad formats) and the associated budget allocation idea.
	ProductAllocation    []*ProductAllocation `protobuf:"bytes,1,rep,name=product_allocation,json=productAllocation,proto3" json:"product_allocation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GenerateProductMixIdeasResponse) Reset()         { *m = GenerateProductMixIdeasResponse{} }
func (m *GenerateProductMixIdeasResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateProductMixIdeasResponse) ProtoMessage()    {}
func (*GenerateProductMixIdeasResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{9}
}

func (m *GenerateProductMixIdeasResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Unmarshal(m, b)
}
func (m *GenerateProductMixIdeasResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Marshal(b, m, deterministic)
}
func (m *GenerateProductMixIdeasResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateProductMixIdeasResponse.Merge(m, src)
}
func (m *GenerateProductMixIdeasResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Size(m)
}
func (m *GenerateProductMixIdeasResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateProductMixIdeasResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateProductMixIdeasResponse proto.InternalMessageInfo

func (m *GenerateProductMixIdeasResponse) GetProductAllocation() []*ProductAllocation {
	if m != nil {
		return m.ProductAllocation
	}
	return nil
}

// An allocation of a part of the budget on a given product.
type ProductAllocation struct {
	// Selected product for planning. The product codes returned are within the
	// set of the ones returned by ListPlannableProducts when using the same
	// location id.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// The value to be allocated for the suggested product in requested currency.
	// Amount in micros. One million is equivalent to one unit.
	BudgetMicros         *wrappers.Int64Value `protobuf:"bytes,2,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProductAllocation) Reset()         { *m = ProductAllocation{} }
func (m *ProductAllocation) String() string { return proto.CompactTextString(m) }
func (*ProductAllocation) ProtoMessage()    {}
func (*ProductAllocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{10}
}

func (m *ProductAllocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductAllocation.Unmarshal(m, b)
}
func (m *ProductAllocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductAllocation.Marshal(b, m, deterministic)
}
func (m *ProductAllocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductAllocation.Merge(m, src)
}
func (m *ProductAllocation) XXX_Size() int {
	return xxx_messageInfo_ProductAllocation.Size(m)
}
func (m *ProductAllocation) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductAllocation.DiscardUnknown(m)
}

var xxx_messageInfo_ProductAllocation proto.InternalMessageInfo

func (m *ProductAllocation) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *ProductAllocation) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

// Request message for [ReachPlanService.GenerateReachForecast][google.ads.googleads.v2.services.ReachPlanService.GenerateReachForecast].
type GenerateReachForecastRequest struct {
	// Required. The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The currency code.
	// Three-character ISO 4217 currency code.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Required. Campaign duration.
	CampaignDuration *CampaignDuration `protobuf:"bytes,3,opt,name=campaign_duration,json=campaignDuration,proto3" json:"campaign_duration,omitempty"`
	// Desired cookie frequency cap that will be applied to each planned product.
	// This is equivalent to the frequency cap exposed in Google Ads when creating
	// a campaign, it represents the maximum number of times an ad can be shown to
	// the same user.
	// If not specified no cap is applied.
	CookieFrequencyCap *wrappers.Int32Value `protobuf:"bytes,4,opt,name=cookie_frequency_cap,json=cookieFrequencyCap,proto3" json:"cookie_frequency_cap,omitempty"`
	// Desired minimum effective frequency (the number of times a person was
	// exposed to the ad) for the reported reach metrics [1-10].
	// This won't affect the targeting, but just the reporting.
	// If not specified, a default of 1 is applied.
	MinEffectiveFrequency *wrappers.Int32Value `protobuf:"bytes,5,opt,name=min_effective_frequency,json=minEffectiveFrequency,proto3" json:"min_effective_frequency,omitempty"`
	// The targeting to be applied to all products selected in the product mix.
	//
	// This is planned targeting: execution details might vary based on the
	// advertising product, please consult an implementation specialist.
	//
	// If no targeting dimensions are specified, then campaigns will target
	// everywhere and everyone.
	//
	// See specific metrics for details on how targeting affects them.
	//
	// In some cases, targeting may be overridden using the
	// PlannedProduct.advanced_product_targeting field.
	Targeting *Targeting `protobuf:"bytes,6,opt,name=targeting,proto3" json:"targeting,omitempty"`
	// Required. The product to be planned.
	PlannedProducts      []*PlannedProduct `protobuf:"bytes,7,rep,name=planned_products,json=plannedProducts,proto3" json:"planned_products,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GenerateReachForecastRequest) Reset()         { *m = GenerateReachForecastRequest{} }
func (m *GenerateReachForecastRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateReachForecastRequest) ProtoMessage()    {}
func (*GenerateReachForecastRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{11}
}

func (m *GenerateReachForecastRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateReachForecastRequest.Unmarshal(m, b)
}
func (m *GenerateReachForecastRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateReachForecastRequest.Marshal(b, m, deterministic)
}
func (m *GenerateReachForecastRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateReachForecastRequest.Merge(m, src)
}
func (m *GenerateReachForecastRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateReachForecastRequest.Size(m)
}
func (m *GenerateReachForecastRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateReachForecastRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateReachForecastRequest proto.InternalMessageInfo

func (m *GenerateReachForecastRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *GenerateReachForecastRequest) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetCampaignDuration() *CampaignDuration {
	if m != nil {
		return m.CampaignDuration
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetCookieFrequencyCap() *wrappers.Int32Value {
	if m != nil {
		return m.CookieFrequencyCap
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetMinEffectiveFrequency() *wrappers.Int32Value {
	if m != nil {
		return m.MinEffectiveFrequency
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetTargeting() *Targeting {
	if m != nil {
		return m.Targeting
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetPlannedProducts() []*PlannedProduct {
	if m != nil {
		return m.PlannedProducts
	}
	return nil
}

// The targeting for which traffic metrics will be reported.
type Targeting struct {
	// Required. The ID of the selected location.
	// Plannable locations ID can be obtained from ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	// Required
	// Selected age range to be planned on.
	AgeRange enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange `protobuf:"varint,2,opt,name=age_range,json=ageRange,proto3,enum=google.ads.googleads.v2.enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange" json:"age_range,omitempty"`
	// Targetable genders for the ad product.
	Genders []*common.GenderInfo `protobuf:"bytes,3,rep,name=genders,proto3" json:"genders,omitempty"`
	// Targetable devices for the ad product.
	Devices              []*common.DeviceInfo `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Targeting) Reset()         { *m = Targeting{} }
func (m *Targeting) String() string { return proto.CompactTextString(m) }
func (*Targeting) ProtoMessage()    {}
func (*Targeting) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{12}
}

func (m *Targeting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Targeting.Unmarshal(m, b)
}
func (m *Targeting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Targeting.Marshal(b, m, deterministic)
}
func (m *Targeting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Targeting.Merge(m, src)
}
func (m *Targeting) XXX_Size() int {
	return xxx_messageInfo_Targeting.Size(m)
}
func (m *Targeting) XXX_DiscardUnknown() {
	xxx_messageInfo_Targeting.DiscardUnknown(m)
}

var xxx_messageInfo_Targeting proto.InternalMessageInfo

func (m *Targeting) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

func (m *Targeting) GetAgeRange() enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange {
	if m != nil {
		return m.AgeRange
	}
	return enums.ReachPlanAgeRangeEnum_UNSPECIFIED
}

func (m *Targeting) GetGenders() []*common.GenderInfo {
	if m != nil {
		return m.Genders
	}
	return nil
}

func (m *Targeting) GetDevices() []*common.DeviceInfo {
	if m != nil {
		return m.Devices
	}
	return nil
}

// The duration of a planned campaign.
type CampaignDuration struct {
	// The duration value in days.
	DurationInDays       *wrappers.Int32Value `protobuf:"bytes,1,opt,name=duration_in_days,json=durationInDays,proto3" json:"duration_in_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CampaignDuration) Reset()         { *m = CampaignDuration{} }
func (m *CampaignDuration) String() string { return proto.CompactTextString(m) }
func (*CampaignDuration) ProtoMessage()    {}
func (*CampaignDuration) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{13}
}

func (m *CampaignDuration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignDuration.Unmarshal(m, b)
}
func (m *CampaignDuration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignDuration.Marshal(b, m, deterministic)
}
func (m *CampaignDuration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignDuration.Merge(m, src)
}
func (m *CampaignDuration) XXX_Size() int {
	return xxx_messageInfo_CampaignDuration.Size(m)
}
func (m *CampaignDuration) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignDuration.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignDuration proto.InternalMessageInfo

func (m *CampaignDuration) GetDurationInDays() *wrappers.Int32Value {
	if m != nil {
		return m.DurationInDays
	}
	return nil
}

// A product being planned for reach.
type PlannedProduct struct {
	// Required. Selected product for planning.
	// Plannable products codes can be obtained from ListPlannableProducts.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// Required. Maximum budget allocation in micros for the selected product.
	// The value is specified in the selected planning currency_code.
	// E.g. 1 000 000$ = 1 000 000 000 000 micros.
	BudgetMicros         *wrappers.Int64Value `protobuf:"bytes,2,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlannedProduct) Reset()         { *m = PlannedProduct{} }
func (m *PlannedProduct) String() string { return proto.CompactTextString(m) }
func (*PlannedProduct) ProtoMessage()    {}
func (*PlannedProduct) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{14}
}

func (m *PlannedProduct) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannedProduct.Unmarshal(m, b)
}
func (m *PlannedProduct) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannedProduct.Marshal(b, m, deterministic)
}
func (m *PlannedProduct) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannedProduct.Merge(m, src)
}
func (m *PlannedProduct) XXX_Size() int {
	return xxx_messageInfo_PlannedProduct.Size(m)
}
func (m *PlannedProduct) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannedProduct.DiscardUnknown(m)
}

var xxx_messageInfo_PlannedProduct proto.InternalMessageInfo

func (m *PlannedProduct) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *PlannedProduct) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

// Response message containing the generated reach curve.
type GenerateReachForecastResponse struct {
	// Reference on target audiences for this curve.
	OnTargetAudienceMetrics *OnTargetAudienceMetrics `protobuf:"bytes,1,opt,name=on_target_audience_metrics,json=onTargetAudienceMetrics,proto3" json:"on_target_audience_metrics,omitempty"`
	// The generated reach curve for the planned product mix.
	ReachCurve           *ReachCurve `protobuf:"bytes,2,opt,name=reach_curve,json=reachCurve,proto3" json:"reach_curve,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *GenerateReachForecastResponse) Reset()         { *m = GenerateReachForecastResponse{} }
func (m *GenerateReachForecastResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateReachForecastResponse) ProtoMessage()    {}
func (*GenerateReachForecastResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{15}
}

func (m *GenerateReachForecastResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateReachForecastResponse.Unmarshal(m, b)
}
func (m *GenerateReachForecastResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateReachForecastResponse.Marshal(b, m, deterministic)
}
func (m *GenerateReachForecastResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateReachForecastResponse.Merge(m, src)
}
func (m *GenerateReachForecastResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateReachForecastResponse.Size(m)
}
func (m *GenerateReachForecastResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateReachForecastResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateReachForecastResponse proto.InternalMessageInfo

func (m *GenerateReachForecastResponse) GetOnTargetAudienceMetrics() *OnTargetAudienceMetrics {
	if m != nil {
		return m.OnTargetAudienceMetrics
	}
	return nil
}

func (m *GenerateReachForecastResponse) GetReachCurve() *ReachCurve {
	if m != nil {
		return m.ReachCurve
	}
	return nil
}

// The reach curve for the planned products.
type ReachCurve struct {
	// All points on the reach curve.
	ReachForecasts       []*ReachForecast `protobuf:"bytes,1,rep,name=reach_forecasts,json=reachForecasts,proto3" json:"reach_forecasts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReachCurve) Reset()         { *m = ReachCurve{} }
func (m *ReachCurve) String() string { return proto.CompactTextString(m) }
func (*ReachCurve) ProtoMessage()    {}
func (*ReachCurve) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{16}
}

func (m *ReachCurve) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReachCurve.Unmarshal(m, b)
}
func (m *ReachCurve) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReachCurve.Marshal(b, m, deterministic)
}
func (m *ReachCurve) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReachCurve.Merge(m, src)
}
func (m *ReachCurve) XXX_Size() int {
	return xxx_messageInfo_ReachCurve.Size(m)
}
func (m *ReachCurve) XXX_DiscardUnknown() {
	xxx_messageInfo_ReachCurve.DiscardUnknown(m)
}

var xxx_messageInfo_ReachCurve proto.InternalMessageInfo

func (m *ReachCurve) GetReachForecasts() []*ReachForecast {
	if m != nil {
		return m.ReachForecasts
	}
	return nil
}

// A point on reach curve.
type ReachForecast struct {
	// The cost in micros.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Forecasted traffic metrics for this point.
	Forecast *Forecast `protobuf:"bytes,2,opt,name=forecast,proto3" json:"forecast,omitempty"`
	// The forecasted allocation. This differs from the input allocation if one
	// or more product cannot fulfill the budget because of limited inventory.
	ForecastedProductAllocations []*ProductAllocation `protobuf:"bytes,3,rep,name=forecasted_product_allocations,json=forecastedProductAllocations,proto3" json:"forecasted_product_allocations,omitempty"`
	XXX_NoUnkeyedLiteral         struct{}             `json:"-"`
	XXX_unrecognized             []byte               `json:"-"`
	XXX_sizecache                int32                `json:"-"`
}

func (m *ReachForecast) Reset()         { *m = ReachForecast{} }
func (m *ReachForecast) String() string { return proto.CompactTextString(m) }
func (*ReachForecast) ProtoMessage()    {}
func (*ReachForecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{17}
}

func (m *ReachForecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReachForecast.Unmarshal(m, b)
}
func (m *ReachForecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReachForecast.Marshal(b, m, deterministic)
}
func (m *ReachForecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReachForecast.Merge(m, src)
}
func (m *ReachForecast) XXX_Size() int {
	return xxx_messageInfo_ReachForecast.Size(m)
}
func (m *ReachForecast) XXX_DiscardUnknown() {
	xxx_messageInfo_ReachForecast.DiscardUnknown(m)
}

var xxx_messageInfo_ReachForecast proto.InternalMessageInfo

func (m *ReachForecast) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *ReachForecast) GetForecast() *Forecast {
	if m != nil {
		return m.Forecast
	}
	return nil
}

func (m *ReachForecast) GetForecastedProductAllocations() []*ProductAllocation {
	if m != nil {
		return m.ForecastedProductAllocations
	}
	return nil
}

// Forecasted traffic metrics for the planned products and targeting.
type Forecast struct {
	// Number of unique people reached at least
	// GenerateReachForecastRequest.min_effective_frequency times that exactly
	// matches the Targeting.
	OnTargetReach *wrappers.Int64Value `protobuf:"bytes,1,opt,name=on_target_reach,json=onTargetReach,proto3" json:"on_target_reach,omitempty"`
	// Total number of unique people reached at least
	// GenerateReachForecastRequest.min_effective_frequency times. This includes
	// people that may fall outside the specified Targeting.
	TotalReach *wrappers.Int64Value `protobuf:"bytes,2,opt,name=total_reach,json=totalReach,proto3" json:"total_reach,omitempty"`
	// Number of ad impressions that exactly matches the Targeting.
	OnTargetImpressions *wrappers.Int64Value `protobuf:"bytes,3,opt,name=on_target_impressions,json=onTargetImpressions,proto3" json:"on_target_impressions,omitempty"`
	// Total number of ad impressions. This includes impressions that may fall
	// outside the specified Targeting, due to insufficent information on
	// signed-in users.
	TotalImpressions     *wrappers.Int64Value `protobuf:"bytes,4,opt,name=total_impressions,json=totalImpressions,proto3" json:"total_impressions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Forecast) Reset()         { *m = Forecast{} }
func (m *Forecast) String() string { return proto.CompactTextString(m) }
func (*Forecast) ProtoMessage()    {}
func (*Forecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{18}
}

func (m *Forecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Forecast.Unmarshal(m, b)
}
func (m *Forecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Forecast.Marshal(b, m, deterministic)
}
func (m *Forecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Forecast.Merge(m, src)
}
func (m *Forecast) XXX_Size() int {
	return xxx_messageInfo_Forecast.Size(m)
}
func (m *Forecast) XXX_DiscardUnknown() {
	xxx_messageInfo_Forecast.DiscardUnknown(m)
}

var xxx_messageInfo_Forecast proto.InternalMessageInfo

func (m *Forecast) GetOnTargetReach() *wrappers.Int64Value {
	if m != nil {
		return m.OnTargetReach
	}
	return nil
}

func (m *Forecast) GetTotalReach() *wrappers.Int64Value {
	if m != nil {
		return m.TotalReach
	}
	return nil
}

func (m *Forecast) GetOnTargetImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.OnTargetImpressions
	}
	return nil
}

func (m *Forecast) GetTotalImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.TotalImpressions
	}
	return nil
}

// Audience metrics for the planned products.
// These metrics consider the following targeting dimensions:
//
// - Location
// - PlannableAgeRange
// - Gender
type OnTargetAudienceMetrics struct {
	// Reference audience size matching the considered targeting for YouTube.
	YoutubeAudienceSize *wrappers.Int64Value `protobuf:"bytes,1,opt,name=youtube_audience_size,json=youtubeAudienceSize,proto3" json:"youtube_audience_size,omitempty"`
	// Reference audience size matching the considered targeting for Census.
	CensusAudienceSize   *wrappers.Int64Value `protobuf:"bytes,2,opt,name=census_audience_size,json=censusAudienceSize,proto3" json:"census_audience_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OnTargetAudienceMetrics) Reset()         { *m = OnTargetAudienceMetrics{} }
func (m *OnTargetAudienceMetrics) String() string { return proto.CompactTextString(m) }
func (*OnTargetAudienceMetrics) ProtoMessage()    {}
func (*OnTargetAudienceMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_c868579e438b97a9, []int{19}
}

func (m *OnTargetAudienceMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OnTargetAudienceMetrics.Unmarshal(m, b)
}
func (m *OnTargetAudienceMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OnTargetAudienceMetrics.Marshal(b, m, deterministic)
}
func (m *OnTargetAudienceMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OnTargetAudienceMetrics.Merge(m, src)
}
func (m *OnTargetAudienceMetrics) XXX_Size() int {
	return xxx_messageInfo_OnTargetAudienceMetrics.Size(m)
}
func (m *OnTargetAudienceMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_OnTargetAudienceMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_OnTargetAudienceMetrics proto.InternalMessageInfo

func (m *OnTargetAudienceMetrics) GetYoutubeAudienceSize() *wrappers.Int64Value {
	if m != nil {
		return m.YoutubeAudienceSize
	}
	return nil
}

func (m *OnTargetAudienceMetrics) GetCensusAudienceSize() *wrappers.Int64Value {
	if m != nil {
		return m.CensusAudienceSize
	}
	return nil
}

func init() {
	proto.RegisterType((*ListPlannableLocationsRequest)(nil), "google.ads.googleads.v2.services.ListPlannableLocationsRequest")
	proto.RegisterType((*ListPlannableLocationsResponse)(nil), "google.ads.googleads.v2.services.ListPlannableLocationsResponse")
	proto.RegisterType((*PlannableLocation)(nil), "google.ads.googleads.v2.services.PlannableLocation")
	proto.RegisterType((*ListPlannableProductsRequest)(nil), "google.ads.googleads.v2.services.ListPlannableProductsRequest")
	proto.RegisterType((*ListPlannableProductsResponse)(nil), "google.ads.googleads.v2.services.ListPlannableProductsResponse")
	proto.RegisterType((*ProductMetadata)(nil), "google.ads.googleads.v2.services.ProductMetadata")
	proto.RegisterType((*PlannableTargeting)(nil), "google.ads.googleads.v2.services.PlannableTargeting")
	proto.RegisterType((*GenerateProductMixIdeasRequest)(nil), "google.ads.googleads.v2.services.GenerateProductMixIdeasRequest")
	proto.RegisterType((*Preferences)(nil), "google.ads.googleads.v2.services.Preferences")
	proto.RegisterType((*GenerateProductMixIdeasResponse)(nil), "google.ads.googleads.v2.services.GenerateProductMixIdeasResponse")
	proto.RegisterType((*ProductAllocation)(nil), "google.ads.googleads.v2.services.ProductAllocation")
	proto.RegisterType((*GenerateReachForecastRequest)(nil), "google.ads.googleads.v2.services.GenerateReachForecastRequest")
	proto.RegisterType((*Targeting)(nil), "google.ads.googleads.v2.services.Targeting")
	proto.RegisterType((*CampaignDuration)(nil), "google.ads.googleads.v2.services.CampaignDuration")
	proto.RegisterType((*PlannedProduct)(nil), "google.ads.googleads.v2.services.PlannedProduct")
	proto.RegisterType((*GenerateReachForecastResponse)(nil), "google.ads.googleads.v2.services.GenerateReachForecastResponse")
	proto.RegisterType((*ReachCurve)(nil), "google.ads.googleads.v2.services.ReachCurve")
	proto.RegisterType((*ReachForecast)(nil), "google.ads.googleads.v2.services.ReachForecast")
	proto.RegisterType((*Forecast)(nil), "google.ads.googleads.v2.services.Forecast")
	proto.RegisterType((*OnTargetAudienceMetrics)(nil), "google.ads.googleads.v2.services.OnTargetAudienceMetrics")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/services/reach_plan_service.proto", fileDescriptor_c868579e438b97a9)
}

var fileDescriptor_c868579e438b97a9 = []byte{
	// 1720 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcb, 0x6f, 0x24, 0x47,
	0x19, 0x57, 0xb7, 0x97, 0xec, 0xfa, 0x73, 0xd6, 0x8f, 0xda, 0x75, 0x3c, 0x4c, 0x1c, 0xef, 0xaa,
	0xb5, 0x48, 0x91, 0x71, 0x66, 0xc2, 0x6c, 0x40, 0xc9, 0x90, 0x25, 0x99, 0xb5, 0xd7, 0xce, 0x48,
	0x6b, 0xad, 0x35, 0x86, 0xe5, 0x21, 0x4b, 0x4d, 0xb9, 0xbb, 0xa6, 0x5d, 0xca, 0x4c, 0x55, 0xd3,
	0x55, 0xed, 0xe0, 0xa0, 0x48, 0x08, 0x09, 0x10, 0x07, 0x24, 0x24, 0xfe, 0x02, 0x38, 0x20, 0xe0,
	0x3f, 0x40, 0x42, 0x1c, 0x38, 0x46, 0x88, 0x0b, 0x12, 0x87, 0x3d, 0x71, 0x40, 0x1c, 0xf8, 0x1b,
	0x88, 0x84, 0xba, 0x1e, 0x3d, 0x3d, 0xef, 0xb6, 0x77, 0x91, 0xb8, 0xd5, 0x54, 0x7d, 0xbf, 0x5f,
	0x7d, 0xef, 0xaf, 0xa6, 0xe1, 0x9d, 0x88, 0xf3, 0xa8, 0x47, 0xea, 0x38, 0x14, 0x75, 0xbd, 0xcc,
	0x56, 0xe7, 0x8d, 0xba, 0x20, 0xc9, 0x39, 0x0d, 0x88, 0xa8, 0x27, 0x04, 0x07, 0x67, 0x7e, 0xdc,
	0xc3, 0xcc, 0x37, 0x7b, 0xb5, 0x38, 0xe1, 0x92, 0xa3, 0xbb, 0x5a, 0xbe, 0x86, 0x43, 0x51, 0xcb,
	0xa1, 0xb5, 0xf3, 0x46, 0xcd, 0x42, 0xab, 0x6f, 0x4c, 0x23, 0x0f, 0x78, 0xbf, 0xcf, 0x59, 0x3d,
	0x48, 0xa8, 0x24, 0x09, 0xc5, 0x9a, 0xb0, 0xfa, 0xf6, 0x34, 0x71, 0xc2, 0xd2, 0xfe, 0x90, 0x22,
	0x38, 0xf4, 0x7b, 0x84, 0x45, 0xf2, 0xec, 0xf2, 0xc8, 0x88, 0xf8, 0x09, 0x66, 0x91, 0x31, 0xa2,
	0xba, 0x69, 0x91, 0x31, 0xad, 0x63, 0xc6, 0xb8, 0xc4, 0x92, 0x72, 0x26, 0xcc, 0xe9, 0x46, 0xe1,
	0x34, 0xe8, 0x51, 0xc2, 0xa4, 0x39, 0xb8, 0x53, 0x38, 0xe8, 0x52, 0xd2, 0x0b, 0xfd, 0x53, 0x72,
	0x86, 0xcf, 0x29, 0x4f, 0x8c, 0xc0, 0x96, 0x11, 0x50, 0xbf, 0x4e, 0xd3, 0x6e, 0xfd, 0xa3, 0x04,
	0xc7, 0x31, 0x49, 0x0c, 0xb3, 0x77, 0x07, 0x5e, 0x7b, 0x4c, 0x85, 0x3c, 0xea, 0x61, 0xc6, 0xf0,
	0x69, 0x8f, 0x3c, 0xe6, 0x81, 0xbe, 0xb9, 0x43, 0xbe, 0x97, 0x12, 0x21, 0xbd, 0x9f, 0x38, 0xb0,
	0x35, 0x4d, 0x42, 0xc4, 0x9c, 0x09, 0x82, 0x42, 0xb8, 0x15, 0xdb, 0x53, 0xbf, 0x67, 0x8f, 0x2b,
	0xce, 0xdd, 0x85, 0xd7, 0x97, 0x1a, 0xf7, 0x6b, 0xf3, 0xc2, 0x53, 0x1b, 0xa3, 0xee, 0xa0, 0x78,
	0xec, 0x36, 0xef, 0x8f, 0x0e, 0xac, 0x8d, 0x49, 0xa2, 0x1d, 0x70, 0x69, 0x58, 0x71, 0xee, 0x3a,
	0xaf, 0x2f, 0x35, 0x36, 0xed, 0x55, 0xd6, 0xd8, 0xda, 0xb1, 0x4c, 0x28, 0x8b, 0x9e, 0xe2, 0x5e,
	0x4a, 0x3a, 0x2e, 0x0d, 0xd1, 0x9b, 0x70, 0x8d, 0xe1, 0x3e, 0xa9, 0xb8, 0x25, 0xe4, 0x95, 0x24,
	0x3a, 0x80, 0xb5, 0x18, 0x27, 0x84, 0x49, 0x3f, 0xe0, 0x29, 0x93, 0xc9, 0x85, 0x4f, 0xc3, 0xca,
	0x82, 0x82, 0xbf, 0x3a, 0x06, 0x6f, 0x33, 0xf9, 0x95, 0xb7, 0x34, 0x7a, 0x45, 0xa3, 0x76, 0x35,
	0xa8, 0x1d, 0x7a, 0x29, 0x6c, 0x0e, 0xb9, 0xf1, 0x28, 0xe1, 0x61, 0x1a, 0x48, 0xeb, 0x67, 0xf4,
	0x0d, 0x58, 0x1f, 0x77, 0xa2, 0x5f, 0xce, 0xb6, 0x87, 0x0b, 0xff, 0x68, 0xb9, 0x9d, 0x5b, 0x63,
	0x4e, 0x6b, 0x87, 0xde, 0x27, 0x23, 0xf1, 0x1d, 0x5c, 0x6b, 0x82, 0x77, 0x02, 0xab, 0xb1, 0xde,
	0xf3, 0xfb, 0x44, 0xe2, 0x10, 0x4b, 0x6c, 0x22, 0xf7, 0xa5, 0x12, 0x91, 0xd3, 0xc8, 0x43, 0x03,
	0xec, 0xac, 0xc4, 0xc3, 0x1b, 0xde, 0x5f, 0x1c, 0x58, 0x19, 0x11, 0x42, 0x1d, 0x78, 0x65, 0x60,
	0xa9, 0xbd, 0x3b, 0xe0, 0x21, 0x29, 0x15, 0xc6, 0xdb, 0xf1, 0x88, 0x29, 0xbb, 0x3c, 0x24, 0x88,
	0x14, 0x53, 0x50, 0xe2, 0x24, 0x22, 0x92, 0xb2, 0xc8, 0xc4, 0xf9, 0xad, 0x4b, 0xa4, 0xe0, 0xd7,
	0x2d, 0xb6, 0x90, 0x83, 0xf9, 0x9e, 0xf7, 0x53, 0x17, 0xd0, 0xb8, 0x28, 0x22, 0x00, 0x79, 0x3d,
	0xeb, 0xbc, 0x5f, 0x6e, 0xec, 0x4f, 0xbd, 0x54, 0xf5, 0x82, 0x5a, 0x27, 0xeb, 0x05, 0x19, 0x57,
	0x2b, 0x22, 0x9d, 0x0c, 0xf8, 0x88, 0xa5, 0xfd, 0xf1, 0xdd, 0xce, 0x22, 0x36, 0x2b, 0x81, 0xf6,
	0xe0, 0x7a, 0x44, 0x58, 0x48, 0x12, 0x51, 0x71, 0x55, 0x84, 0xb6, 0xa7, 0xde, 0xa1, 0x1b, 0x5b,
	0xed, 0x40, 0x89, 0xb7, 0x59, 0x97, 0x77, 0x2c, 0x34, 0x63, 0x09, 0x89, 0xb2, 0xba, 0xb2, 0x50,
	0x8e, 0x65, 0x4f, 0x89, 0x6b, 0x16, 0x03, 0xf5, 0x3e, 0x73, 0x61, 0xeb, 0x80, 0x30, 0x92, 0x60,
	0x69, 0x03, 0x71, 0x48, 0xbf, 0xdf, 0x0e, 0x09, 0xce, 0x33, 0xfa, 0x1e, 0x2c, 0x05, 0xa9, 0x90,
	0xbc, 0x4f, 0x12, 0x9b, 0xc7, 0x8b, 0x3a, 0x53, 0xc1, 0xee, 0xb7, 0xc3, 0xe9, 0x79, 0xef, 0x3e,
	0x4f, 0xde, 0xa3, 0x7d, 0xb8, 0x19, 0xa4, 0x49, 0x42, 0x58, 0x70, 0xa1, 0x73, 0x6b, 0xa1, 0x2c,
	0xdd, 0xcb, 0x16, 0xa7, 0x12, 0xeb, 0x11, 0xdc, 0x3c, 0x4d, 0xc3, 0x88, 0x48, 0xbf, 0x4f, 0x83,
	0x84, 0x8b, 0xca, 0xb5, 0xb9, 0xb5, 0x6f, 0x68, 0x34, 0xec, 0x50, 0xa1, 0xd0, 0x13, 0x58, 0x8a,
	0x13, 0xd2, 0x25, 0x19, 0x31, 0x11, 0x95, 0xcf, 0x29, 0x92, 0x37, 0xca, 0x14, 0x58, 0x0e, 0xea,
	0x14, 0x19, 0xbc, 0x9f, 0x2f, 0xc0, 0x52, 0xe1, 0x10, 0x3d, 0x80, 0x97, 0xa9, 0xf0, 0xc5, 0x87,
	0x34, 0x8e, 0x33, 0x4f, 0x98, 0x52, 0xaa, 0x8e, 0xa9, 0xf9, 0x90, 0xf3, 0x9e, 0x2e, 0xa4, 0x25,
	0x2a, 0x8e, 0xad, 0x38, 0xda, 0x87, 0x35, 0x21, 0x71, 0x22, 0x85, 0xff, 0x11, 0x95, 0x67, 0xbe,
	0xe0, 0x29, 0xb3, 0x11, 0x98, 0xc5, 0xb1, 0xa2, 0x41, 0xdf, 0xa4, 0xf2, 0xec, 0x38, 0x83, 0xa0,
	0x00, 0x16, 0xf3, 0x99, 0xa8, 0x5c, 0x7e, 0x99, 0x42, 0x08, 0x1f, 0x2b, 0xdc, 0x48, 0x21, 0x98,
	0xdd, 0xce, 0x0d, 0x6c, 0x56, 0x68, 0x0f, 0x56, 0x25, 0x8f, 0xfd, 0x80, 0x33, 0x99, 0x35, 0x66,
	0xce, 0x7a, 0x17, 0x26, 0x2c, 0xb3, 0x74, 0x5d, 0x96, 0x3c, 0xde, 0xd5, 0x90, 0x27, 0xac, 0x77,
	0x81, 0x1e, 0xc3, 0xed, 0x33, 0x2c, 0xfc, 0x28, 0xc5, 0x09, 0x66, 0x92, 0x90, 0xd0, 0x8f, 0x13,
	0x1a, 0x10, 0x13, 0x9b, 0x59, 0x4c, 0xe8, 0x0c, 0x8b, 0x83, 0x1c, 0x76, 0x94, 0xa1, 0xbc, 0x1f,
	0x3b, 0x70, 0x67, 0x6a, 0x3d, 0x98, 0x56, 0x7b, 0x0a, 0xc8, 0xb6, 0x3b, 0xdc, 0xb3, 0xa9, 0x7e,
	0x89, 0x31, 0xa9, 0xb1, 0xad, 0x1c, 0xda, 0x59, 0x8b, 0x47, 0xb7, 0xbc, 0xdf, 0x65, 0x53, 0x72,
	0x74, 0xf7, 0x7f, 0xd2, 0x72, 0xdf, 0x1f, 0xad, 0x0c, 0x77, 0xfe, 0x54, 0x1c, 0x2a, 0x0a, 0xef,
	0x4f, 0xd7, 0x60, 0xd3, 0xfa, 0x4c, 0xc5, 0x7b, 0x9f, 0x27, 0x24, 0xc0, 0x42, 0x5e, 0xae, 0x83,
	0xb4, 0x46, 0x4b, 0xbd, 0xcc, 0x74, 0x1f, 0xae, 0xf2, 0x10, 0xd6, 0x02, 0xdc, 0x8f, 0x31, 0x8d,
	0x98, 0x1f, 0xa6, 0x89, 0x0e, 0x8c, 0xee, 0x18, 0x8d, 0xf9, 0x81, 0xd9, 0x35, 0xd0, 0x3d, 0x83,
	0xd4, 0x2a, 0xae, 0x06, 0x23, 0xdb, 0xe8, 0x10, 0x6e, 0x07, 0x9c, 0x7f, 0x48, 0x89, 0xdf, 0x4d,
	0x32, 0x0b, 0x95, 0xc2, 0x38, 0x9e, 0xd5, 0x52, 0xee, 0x37, 0x4c, 0xca, 0x69, 0xe0, 0xbe, 0xc5,
	0xed, 0xe2, 0x18, 0x1d, 0xc3, 0x46, 0x9f, 0x32, 0x9f, 0x74, 0xbb, 0x24, 0x90, 0xf4, 0xbc, 0xc0,
	0x6a, 0x72, 0x78, 0x26, 0xe3, 0x7a, 0x9f, 0xb2, 0x47, 0x16, 0x9a, 0xf3, 0xa2, 0x36, 0x2c, 0x0e,
	0xc6, 0xe7, 0x4b, 0x8a, 0xe6, 0x8b, 0xf3, 0x3d, 0x30, 0x98, 0x9a, 0x03, 0x34, 0xfa, 0x2e, 0xac,
	0xaa, 0xc4, 0x51, 0x95, 0xa5, 0x5f, 0x1d, 0x95, 0xeb, 0x2a, 0xd9, 0xdf, 0x2c, 0x39, 0x90, 0xb3,
	0xe2, 0x52, 0x40, 0xed, 0xd1, 0x95, 0x78, 0x68, 0x53, 0x78, 0x7f, 0x75, 0x61, 0x71, 0x30, 0x85,
	0x8f, 0x9e, 0xe3, 0x05, 0x35, 0x79, 0x88, 0x64, 0xdd, 0xcc, 0xce, 0x75, 0x95, 0x55, 0x2f, 0x6e,
	0xac, 0xdf, 0xb0, 0x63, 0xbd, 0x38, 0xd5, 0x17, 0x5e, 0xc8, 0x54, 0xbf, 0x76, 0xf5, 0xa9, 0xfe,
	0x6d, 0x58, 0x1d, 0x4d, 0x66, 0xf4, 0x08, 0x56, 0x6d, 0x49, 0xf8, 0x94, 0xf9, 0x21, 0xbe, 0x10,
	0xc6, 0xa3, 0x33, 0xf3, 0x6b, 0xd9, 0x82, 0xda, 0x6c, 0x0f, 0x5f, 0x08, 0xef, 0x37, 0x0e, 0x2c,
	0x0f, 0x07, 0xf5, 0xff, 0xb4, 0x2b, 0xfd, 0xcb, 0x81, 0xd7, 0xa6, 0x74, 0x25, 0xd3, 0xc7, 0xcf,
	0xa1, 0xca, 0x99, 0x79, 0x65, 0xfa, 0x38, 0x0d, 0x69, 0x36, 0x82, 0xb3, 0xd7, 0x73, 0x42, 0x03,
	0xeb, 0x9b, 0x77, 0xe6, 0xa7, 0xf8, 0x13, 0xa6, 0x73, 0xb7, 0x65, 0x18, 0x0e, 0x35, 0x41, 0x67,
	0x83, 0x4f, 0x3e, 0x40, 0x87, 0xb0, 0xa4, 0xff, 0x41, 0x06, 0x69, 0x72, 0x6e, 0xdb, 0xdc, 0xce,
	0xfc, 0x8b, 0x94, 0x15, 0xbb, 0x19, 0xa6, 0x03, 0x49, 0xbe, 0xf6, 0xba, 0x00, 0x83, 0x13, 0xf4,
	0x2d, 0x58, 0xd1, 0xe4, 0x5d, 0x63, 0xae, 0xfd, 0x03, 0x57, 0x2f, 0x79, 0x41, 0xee, 0xa6, 0xe5,
	0xa4, 0xf8, 0x53, 0x78, 0xbf, 0x70, 0xe1, 0xe6, 0x90, 0x04, 0x7a, 0x17, 0x96, 0x02, 0x2e, 0xf2,
	0x10, 0x39, 0xf3, 0x43, 0x04, 0x99, 0xbc, 0x79, 0x4b, 0xed, 0xc3, 0x0d, 0xab, 0xa3, 0xf1, 0xc1,
	0xf6, 0x7c, 0x15, 0x73, 0xed, 0x72, 0x2c, 0xba, 0x80, 0x2d, 0xbb, 0x1e, 0xb4, 0xa8, 0xc2, 0x64,
	0xb6, 0xf5, 0x78, 0xa5, 0xd1, 0xbc, 0x39, 0xa0, 0x1e, 0x3b, 0x14, 0xde, 0x6f, 0x5d, 0xb8, 0x91,
	0x7b, 0x63, 0x17, 0x56, 0x06, 0xe9, 0xa4, 0x7c, 0x57, 0xc6, 0x23, 0x37, 0x6d, 0x96, 0x28, 0xd7,
	0x66, 0x2e, 0x95, 0x5c, 0xe2, 0x9e, 0x21, 0x28, 0x91, 0xf5, 0xa0, 0xe4, 0x35, 0xfa, 0x09, 0xac,
	0x0f, 0x54, 0xa0, 0xfd, 0x38, 0x21, 0x42, 0x18, 0x0f, 0xcc, 0xe5, 0xb9, 0x65, 0x15, 0x69, 0x0f,
	0x70, 0xe8, 0x03, 0x58, 0xd3, 0xea, 0x14, 0xc9, 0xe6, 0x3f, 0x9d, 0x3b, 0xab, 0x0a, 0x55, 0x60,
	0xf2, 0xfe, 0xe0, 0xc0, 0xc6, 0x94, 0x4a, 0xc9, 0xd4, 0xbe, 0xe0, 0xa9, 0x4c, 0x4f, 0xc9, 0xa0,
	0x0c, 0x05, 0xfd, 0x98, 0x94, 0xf1, 0xdf, 0x2d, 0x83, 0xb4, 0x9c, 0xc7, 0xf4, 0x63, 0xa2, 0x26,
	0x34, 0x61, 0x22, 0x15, 0x23, 0x7c, 0x25, 0xdc, 0x89, 0x34, 0xb0, 0x48, 0xd7, 0xf8, 0xec, 0x3a,
	0xac, 0xe6, 0xad, 0xff, 0x58, 0x27, 0x0b, 0xfa, 0xb3, 0x03, 0xaf, 0x4c, 0xfe, 0xa0, 0x82, 0xde,
	0x9b, 0x9f, 0x69, 0x33, 0x3f, 0xd6, 0x54, 0xdf, 0xbf, 0x3a, 0x81, 0xee, 0x6d, 0xde, 0x17, 0x7e,
	0xf4, 0xb7, 0x7f, 0xfe, 0xd2, 0xbd, 0xe3, 0x55, 0xeb, 0xe7, 0x8d, 0x66, 0x6f, 0xa2, 0x6c, 0xd3,
	0xd9, 0x46, 0x7f, 0x77, 0x60, 0x7d, 0xe2, 0x77, 0x05, 0xf4, 0xb5, 0x4b, 0xaa, 0x30, 0xf2, 0x1d,
	0xa4, 0xfa, 0xde, 0x95, 0xf1, 0xc6, 0x82, 0x77, 0x9f, 0xb5, 0x26, 0xbf, 0x03, 0x94, 0x65, 0x5b,
	0xde, 0xe7, 0xc7, 0x2c, 0xb3, 0x14, 0x99, 0x61, 0xbf, 0x72, 0x61, 0x63, 0xca, 0x3b, 0x1e, 0x95,
	0xf0, 0xee, 0xec, 0xbf, 0xc4, 0xd5, 0xd6, 0x73, 0x30, 0x18, 0xf3, 0x7e, 0xe8, 0x3c, 0x6b, 0x3d,
	0x28, 0xbc, 0x8a, 0x77, 0x26, 0xda, 0xba, 0x33, 0xf4, 0x22, 0xde, 0x19, 0x1a, 0x89, 0xca, 0x0f,
	0x4d, 0xef, 0xcb, 0xea, 0x03, 0xa8, 0x21, 0x12, 0xf5, 0x1f, 0x14, 0x38, 0x1f, 0x6c, 0x7f, 0xd2,
	0x8c, 0x26, 0xeb, 0x91, 0xf9, 0xe8, 0x67, 0x2e, 0xac, 0x4f, 0x9c, 0x90, 0x65, 0x82, 0x3f, 0xeb,
	0xc1, 0x5f, 0x26, 0xf8, 0x33, 0x47, 0xb3, 0xc7, 0x9f, 0xb5, 0x6a, 0x45, 0xe7, 0x8c, 0xbd, 0xea,
	0x77, 0x46, 0x9f, 0xa4, 0xca, 0x1b, 0x6f, 0x7b, 0xf7, 0xcb, 0x79, 0x63, 0xe8, 0xd6, 0xa6, 0xb3,
	0x5d, 0x7d, 0xf5, 0xd3, 0x56, 0x65, 0xa0, 0xa8, 0x59, 0xc5, 0x54, 0x64, 0xaf, 0xac, 0x87, 0xff,
	0x71, 0xe0, 0x5e, 0xc0, 0xfb, 0x73, 0x8d, 0x7a, 0xb8, 0x3e, 0xda, 0x25, 0x8e, 0xb2, 0x0e, 0x73,
	0xe4, 0x7c, 0xe7, 0x03, 0x03, 0x8d, 0x78, 0x0f, 0xb3, 0xa8, 0xc6, 0x93, 0xa8, 0x1e, 0x11, 0xa6,
	0xfa, 0x4f, 0x7d, 0x70, 0xd9, 0xf4, 0xaf, 0xe6, 0x5f, 0xb5, 0x8b, 0x5f, 0xbb, 0x0b, 0x07, 0xad,
	0xd6, 0xef, 0xdd, 0xbb, 0x07, 0x9a, 0xb0, 0x15, 0x8a, 0x9a, 0x5e, 0x66, 0xab, 0xa7, 0x8d, 0x9a,
	0xb9, 0x58, 0x7c, 0x6a, 0x45, 0x4e, 0x5a, 0xa1, 0x38, 0xc9, 0x45, 0x4e, 0x9e, 0x36, 0x4e, 0xac,
	0xc8, 0xbf, 0xdd, 0x7b, 0x7a, 0xbf, 0xd9, 0x6c, 0x85, 0xa2, 0xd9, 0xcc, 0x85, 0x9a, 0xcd, 0xa7,
	0x8d, 0x66, 0xd3, 0x8a, 0x9d, 0xbe, 0xa4, 0xf4, 0xbc, 0xff, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xc1, 0xc8, 0xd0, 0x5d, 0xdc, 0x17, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReachPlanServiceClient is the client API for ReachPlanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReachPlanServiceClient interface {
	// Returns the list of plannable locations (for example, countries & DMAs).
	ListPlannableLocations(ctx context.Context, in *ListPlannableLocationsRequest, opts ...grpc.CallOption) (*ListPlannableLocationsResponse, error)
	// Returns the list of per-location plannable YouTube ad formats with allowed
	// targeting.
	ListPlannableProducts(ctx context.Context, in *ListPlannableProductsRequest, opts ...grpc.CallOption) (*ListPlannableProductsResponse, error)
	// Generates a product mix ideas given a set of preferences. This method
	// helps the advertiser to obtain a good mix of ad formats and budget
	// allocations based on its preferences.
	GenerateProductMixIdeas(ctx context.Context, in *GenerateProductMixIdeasRequest, opts ...grpc.CallOption) (*GenerateProductMixIdeasResponse, error)
	// Generates a reach forecast for a given targeting / product mix.
	GenerateReachForecast(ctx context.Context, in *GenerateReachForecastRequest, opts ...grpc.CallOption) (*GenerateReachForecastResponse, error)
}

type reachPlanServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReachPlanServiceClient(cc grpc.ClientConnInterface) ReachPlanServiceClient {
	return &reachPlanServiceClient{cc}
}

func (c *reachPlanServiceClient) ListPlannableLocations(ctx context.Context, in *ListPlannableLocationsRequest, opts ...grpc.CallOption) (*ListPlannableLocationsResponse, error) {
	out := new(ListPlannableLocationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.ReachPlanService/ListPlannableLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) ListPlannableProducts(ctx context.Context, in *ListPlannableProductsRequest, opts ...grpc.CallOption) (*ListPlannableProductsResponse, error) {
	out := new(ListPlannableProductsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.ReachPlanService/ListPlannableProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) GenerateProductMixIdeas(ctx context.Context, in *GenerateProductMixIdeasRequest, opts ...grpc.CallOption) (*GenerateProductMixIdeasResponse, error) {
	out := new(GenerateProductMixIdeasResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.ReachPlanService/GenerateProductMixIdeas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) GenerateReachForecast(ctx context.Context, in *GenerateReachForecastRequest, opts ...grpc.CallOption) (*GenerateReachForecastResponse, error) {
	out := new(GenerateReachForecastResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.ReachPlanService/GenerateReachForecast", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReachPlanServiceServer is the server API for ReachPlanService service.
type ReachPlanServiceServer interface {
	// Returns the list of plannable locations (for example, countries & DMAs).
	ListPlannableLocations(context.Context, *ListPlannableLocationsRequest) (*ListPlannableLocationsResponse, error)
	// Returns the list of per-location plannable YouTube ad formats with allowed
	// targeting.
	ListPlannableProducts(context.Context, *ListPlannableProductsRequest) (*ListPlannableProductsResponse, error)
	// Generates a product mix ideas given a set of preferences. This method
	// helps the advertiser to obtain a good mix of ad formats and budget
	// allocations based on its preferences.
	GenerateProductMixIdeas(context.Context, *GenerateProductMixIdeasRequest) (*GenerateProductMixIdeasResponse, error)
	// Generates a reach forecast for a given targeting / product mix.
	GenerateReachForecast(context.Context, *GenerateReachForecastRequest) (*GenerateReachForecastResponse, error)
}

// UnimplementedReachPlanServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReachPlanServiceServer struct {
}

func (*UnimplementedReachPlanServiceServer) ListPlannableLocations(ctx context.Context, req *ListPlannableLocationsRequest) (*ListPlannableLocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlannableLocations not implemented")
}
func (*UnimplementedReachPlanServiceServer) ListPlannableProducts(ctx context.Context, req *ListPlannableProductsRequest) (*ListPlannableProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlannableProducts not implemented")
}
func (*UnimplementedReachPlanServiceServer) GenerateProductMixIdeas(ctx context.Context, req *GenerateProductMixIdeasRequest) (*GenerateProductMixIdeasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateProductMixIdeas not implemented")
}
func (*UnimplementedReachPlanServiceServer) GenerateReachForecast(ctx context.Context, req *GenerateReachForecastRequest) (*GenerateReachForecastResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateReachForecast not implemented")
}

func RegisterReachPlanServiceServer(s *grpc.Server, srv ReachPlanServiceServer) {
	s.RegisterService(&_ReachPlanService_serviceDesc, srv)
}

func _ReachPlanService_ListPlannableLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlannableLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).ListPlannableLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.ReachPlanService/ListPlannableLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).ListPlannableLocations(ctx, req.(*ListPlannableLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_ListPlannableProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlannableProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).ListPlannableProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.ReachPlanService/ListPlannableProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).ListPlannableProducts(ctx, req.(*ListPlannableProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_GenerateProductMixIdeas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateProductMixIdeasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).GenerateProductMixIdeas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.ReachPlanService/GenerateProductMixIdeas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).GenerateProductMixIdeas(ctx, req.(*GenerateProductMixIdeasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_GenerateReachForecast_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateReachForecastRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).GenerateReachForecast(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.ReachPlanService/GenerateReachForecast",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).GenerateReachForecast(ctx, req.(*GenerateReachForecastRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReachPlanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.ReachPlanService",
	HandlerType: (*ReachPlanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPlannableLocations",
			Handler:    _ReachPlanService_ListPlannableLocations_Handler,
		},
		{
			MethodName: "ListPlannableProducts",
			Handler:    _ReachPlanService_ListPlannableProducts_Handler,
		},
		{
			MethodName: "GenerateProductMixIdeas",
			Handler:    _ReachPlanService_GenerateProductMixIdeas_Handler,
		},
		{
			MethodName: "GenerateReachForecast",
			Handler:    _ReachPlanService_GenerateReachForecast_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/reach_plan_service.proto",
}
