/*
 *  
 *  $Id: gvistacompleja.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once


#include "visualizatorviews.h"
#include <visualizator/export/contracts/ioverlayscontract.h>
#include <api/observers/ieventsobserver.h>
#include <export/contracts/iwidgetscontract.h>
#include <export/contracts/islidercontract.h>
#include <export/contracts/irulecontract.h>
#include <export/contracts/iwindowlevelcontract.h>
#include <export/contracts/iwindowlayoutcontract.h>
#include <export/contracts/iimageexportcontract.h>
#include "../estudios/overlay.h"
#include <api/ianotador.h>

#include <wx/sizer.h>
#include <wx/dc.h>
#include <wx/bitmap.h>
#include <wx/aui/auibar.h>

#include <vtkCommand.h>

namespace GNKVisualizator{
	class VisualizatorStudy;
	class Vista2D;
	class SimpleViewExportDelegate;
}
namespace GNC {
	namespace GCS {
		class Layout;
	}
}

class GVistaSimple;

class TimerPlay;
class BarraHerramientasBotones;

class vtkScalarsToColors;
class vtkAlgorithmOutput;
class GVistaComplejaDelegate;
class GVistaComplejaOverlaysDelegate;
class GVistaComplejaWindowLayoutDelegate;

namespace GNKVisualizator
{	
	class SimpleViewExportContractDelegate;
	class SimpleViewExportDelegate;
	namespace GUI {
		class PreviewPanelVisualizator;
		class wxDropTargetPreviewPanelVisualizator;
	}	
}

class GVistaCompleja: public VistaComplejaBase, public GNC::GCS::IAnotador, public GNC::GCS::IEventsObserver {
	friend class GVistaComplejaDelegate;
	friend class GVistaComplejaOverlaysDelegate;
	friend class GVistaComplejaWindowLayoutDelegate;
	friend class GNKVisualizator::SimpleViewExportContractDelegate;
	friend class GNKVisualizator::SimpleViewExportDelegate;
	friend class GNKVisualizator::GUI::wxDropTargetPreviewPanelVisualizator;
public:

   /* Constructor */
	GVistaCompleja( GNKVisualizator::Vista2D* pIVista);
   /* Destructor */
	~GVistaCompleja();

	virtual void OnEraseBackground( wxEraseEvent& event ) { event.Skip(false); }

	void AddVistaSimple();

	void LoadSeries(long seriesPk);

	void IniciarPipeline(const GNC::GCS::Ptr<GNC::GCS::Layout>& layout = NULL);

	void DetenerPipeline();

	virtual void OnCargaFinalizada();

	void SetOverlays(GNC::GCS::Ptr<GNKVisualizator::TListaOverlays>& pListaOverlays);

	bool GetManipulacionEnabled()
	{
		return m_pPanelManipulacion->IsEnabled();
	}

   //region "Eventos"
	virtual void OnPaint(wxPaintEvent& evt);

	void OnMenuVerClick(wxCommandEvent& event);
	void OnMenuCineClick(wxAuiToolBarEvent& evt);
	void OnInvertColorMap(wxCommandEvent &event);

	void ActualizarMaxMinSlider();

	void OnFocus(wxChildFocusEvent &event);

	void SetPeriodo(int milisegundos);

	void OnSize(wxSizeEvent &event);

	void OnZSliderScroll (wxScrollEvent& event);

	void OnKeyDown( wxKeyEvent& event );

	void OnMouseWheel( wxMouseEvent& event );

	void OnPlayStopClick(wxCommandEvent &event);

	void Play();
	void Stop();

	void OnBucleClick(wxCommandEvent &event);

	void OnTimer();

	void OnSincronizarClick(wxCommandEvent &event);

	void Sincronizar(bool sincronizar);

	void GoToSlice(int posicion, bool relativa =  true, bool propagar = true, bool render= true);
	int GetCurrentSlice() const;

	virtual void PreProcesarEvento(GNC::GCS::Events::IEvent*, std::list<GNC::GCS::Events::IEvent*>& );

	void ProcesarEvento(GNC::GCS::Events::IEvent *evt) ;

	typedef std::vector<GNKVisualizator::Vista2D*> TipoListaVista2D;
	void Sincronizar(const TipoListaVista2D& lista);
	void DesSincronizar();
	bool EsSincronizable();

	//endregion


	//region "Realizacion de la interfaz IAnnotator"
	virtual std::string GetTopLeftAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetTopRightAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetBottomLeftAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetBottomRightAnnotation(GNC::GCS::Contexto3D* c);
	virtual std::string GetPatientPosition(GNC::GCS::Contexto3D* c);

	virtual std::string GetAnotacionPosicion(GNC::GCS::Vector* pPosicion);
	//endregion

	// Asigna los valores de los apuntadores a la la imagen y el slice actual
	void AsignarConexionesDeFiltrado(vtkImageData** pImagen, int* slice, vtkImageData** pChroma);
	void ActualizarImagen();

	//region "IContratoExportacionImagenes interface realization"
//TODO	void GetImage(GNC::GCS::IContratoExportacionImages::ImageType::Pointer& img, int index, bool conWidgets, const GNC::GCS::Vector& size);

	//region "IReconstructionContract interface realization"
	//void SetReconstructionMode(GNKVisualizator::Reconstruction::ReconstructionMode mode);
	GNC::GCS::IVista* GetView();
protected:
	GNKVisualizator::Vista2D*            IVista;
	TimerPlay*                           m_playTimer;
	BarraHerramientasBotones*            m_pBarraIzquierda;
	BarraHerramientasBotones*            m_pBarraCine;
	BarraHerramientasBotones*            m_pBarraDerecha;

	int                                  m_orientacion;
	TipoListaVista2D                     m_ListaSincronizacion;
	int m_posicion;
	bool                                 m_ReproducirBucle;
	int                                  m_PeriodoMs;
	typedef std::vector<GVistaSimple*>   TListaGVistasSimples;
	TListaGVistasSimples                 m_VistasSimples;
	///widgets
	//TipoFicherosGNKVisualizator*              m_pFicherosAprimaria;
	

	//si se ha pintado
	bool                                 m_hasBeenRendered;
	GNC::GCS::IWidgetsManager*				 m_pManager;
	GNC::GCS::Ptr<GVistaComplejaDelegate> Delegate;
	GNC::GCS::Ptr<GVistaComplejaOverlaysDelegate> OverlaysDelegate;
	GNC::GCS::Ptr<GVistaComplejaWindowLayoutDelegate> WindowLayoutDelegate;
	GNC::GCS::Ptr<GNKVisualizator::SimpleViewExportContractDelegate> ExportDelegate;
	GNKVisualizator::GUI::PreviewPanelVisualizator*   m_pPanelPreview;

	friend class GNKVisualizator::Vista2D;
};
