/*
 *  
 *  $Id: queryretrievetool.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include "queryretrievetool.h"
#include <api/controllers/icontroladorpermisos.h>

#include <resources/ginkgoresourcesmanager.h>
#include <main/controllers/historytoolscontroller.h>
#include <main/gui/acquisition/dialogoadquisicion.h>

//----------------------------------------------------------------------

GNC::QueryRetrieveTool::QueryRetrieveTool(): GNC::GCS::IHistoryTool(ID,GNC::GCS::IHistoryTool::TFamily_Q_R, _Std("PACS Q/R"), _Std("Acquire a DICOM study from PACS")+ " \tAlt+a", GinkgoResourcesManager::Acquisition::GetIcoAdquirePACS(), GinkgoResourcesManager::BigIcons::GetIcoBigQR()) 
{
}

GNC::QueryRetrieveTool::~QueryRetrieveTool()
{
}

bool GNC::QueryRetrieveTool::Enabled() 
{
	return GNC::GCS::IControladorPermisos::Instance()->Get("core.restrictions","acquire") && 
		GNC::GCS::IControladorPermisos::Instance()->Get("core.pacs.limits","pacs_acquisition");
}

void GNC::QueryRetrieveTool::Execute()
{
	GNC::GUI::DialogoAdquisicion::Instance()->Show();
}



