/*
 *
 *  $Id: firstlevelpanel.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "firstlevelpanel.h"
#include <sstream>
#include <wx/dcbuffer.h>
#include <main/entorno.h>
#include <main/gui/mainwindow/ventanaprincipal.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorlog.h>
#include <resources/ginkgoresourcesmanager.h>
#include "leafpanel.h"

#define TEXT_LENGTH 75
#define LEAF_HEIGHT 120
#define FIRST_LEVEL_HEADER_HEIGHT 30
namespace GNC {
	namespace GUI {		
		FirstLevelPanel::FirstLevelPanel(GNC::GCS::IVista* pView, INodoHistorial* pParent,  GNC::GUI::IPreviewNode* pNode, bool desplegarNodo): FirstLevelPanelBase(pParent->GetWxWindow()), 
			INodoHistorial(pParent),
			m_pView(pView)
		{
			wxPanel::SetBackgroundColour(*wxWHITE);

			m_pNode = pNode;
			m_deployed = false;	
			m_pIcoPlegar->SetBitmap(GinkgoResourcesManager::History::GetIcoDesplegar());
			
			//truncate string...
			wxString tmp = wxString::FromUTF8(pNode->GetLabel().c_str());
			wxClientDC dc(this);
			dc.SetFont(m_pLabel->GetFont());
			int x,y;
			dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);

			while(x > TEXT_LENGTH)
			{
				dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);
				tmp = tmp.substr(0,tmp.size()-2);
			}
			m_pLabel->SetLabel(tmp);
		
			this->SetToolTip(wxString::FromUTF8(pNode->GetLabel().c_str()));
			m_pLabel->SetToolTip(wxString::FromUTF8(pNode->GetLabel().c_str()));
			//end truncate

			//add nodes...
			int leafIndex = 0;
			for (IPreviewNode::TListNodes::iterator it = pNode->children.begin(); it != pNode->children.end(); ++it, ++leafIndex)
			{
				IPreviewLeaf* pLeaf = dynamic_cast<IPreviewLeaf*>((*it));
				if (pLeaf != NULL) {
					LeafPanel* p = new LeafPanel(m_pView, this, pLeaf, leafIndex%2); 
					m_pSizerFirstLevel->Add(p,0,wxALIGN_LEFT,0);
				} else {
					LOG_ERROR("FirstLevelPanel", "leaf panel isn't an IPreviewLeaf");
				}				
			}	
			//

			if (desplegarNodo) {
				Deploy();
			} else {
				m_pSizerFirstLevel->Show(desplegarNodo);
			}
			Layout();
		}

		FirstLevelPanel::~FirstLevelPanel()
		{
		}

		void FirstLevelPanel::GetNodeSize(int &x, int &y)
		{
			x = this->GetSize().x;
			y = FIRST_LEVEL_HEADER_HEIGHT;
			if (m_deployed) {
				y += m_pSizerFirstLevel->GetChildren().size() * LEAF_HEIGHT;
			} 
		}

		void FirstLevelPanel::Deploy(bool show)
		{
			this->GetParent()->Freeze();
			Freeze();
			if (show) {
				m_deployed = !m_deployed;
				if (m_deployed) {
					m_pIcoPlegar->SetBitmap(GinkgoResourcesManager::History::GetIcoPlegar());
				} else {
					m_pIcoPlegar->SetBitmap(GinkgoResourcesManager::History::GetIcoDesplegar());
				}
				m_pIcoPlegar->Refresh(true);

				/*todo hide children
				for (TChildrenList::iterator it = m_lis.begin(); it != m_mapaHijos.end(); ++it) {
					((PanelEstudio*)((*it).second))->Show(m_desplegado);
				}*/

				m_pSizerFirstLevel->Show(m_deployed);
				Layout();
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Events::EventoLayoutHistorial(m_pView));
			}
			Thaw();
			this->GetParent()->Thaw();
		}

		wxWindow* FirstLevelPanel::GetWxWindow()
		{
			return this;
		}

		void FirstLevelPanel::OnPaint(wxPaintEvent& event)
		{
			wxPaintDC dc(this);
			FirstLevelPanelBase::OnPaint(event);
			{
				int panelHeight = 29;
				wxColour borderColor(0,0,0);
				dc.SetBrush(wxBrush(borderColor,wxTRANSPARENT));
				dc.SetPen(wxPen(borderColor, 1, wxSOLID));
				dc.DrawLine(wxPoint(0,0), wxPoint(0, dc.GetSize().y-1));
				dc.DrawLine(wxPoint(0, panelHeight), wxPoint(dc.GetSize().x - 1,panelHeight));
				dc.DrawLine(wxPoint(dc.GetSize().x - 1, 0), wxPoint(dc.GetSize().x - 1, panelHeight));
			}
		}

		void FirstLevelPanel::OnSize(wxSizeEvent & event)
		{
			Layout();
			for (wxWindowList::iterator it = m_children.begin(); it != m_children.end(); ++it)
			{
				(*it)->Layout();
			}
			event.Skip();
		}

		void FirstLevelPanel::OnMouseWheel(wxMouseEvent& event)
		{
			event.ResumePropagation(2);
			event.Skip(true);
		}

		void FirstLevelPanel::OnCabeceraClick(wxMouseEvent &)
		{
			//si el virtual size pasa de 16 bits (32000 pasan cosas malas)
			if (!m_deployed && this->GetParent()->GetVirtualSize().y > 30000)
			{
				Deploy(false);
				wxBell();
				return;
			}
			Deploy(true);
		}
	};
};
