/*
*  $Id: wxOftalImageThumbnail.cpp $
*  Proyecto Ginkgo
*
*  Copyright 2008 MetaEmotion S.L. All rights reserved.
*
*/

#include <wx/filename.h>
#include <wx/dc.h>

#include "wxhistoryimagethumbnail.h"
#include <resources/ginkgoresourcesmanager.h>
namespace GNC {
	namespace GUI {
		wxHistoryImageThumbnailItem::wxHistoryImageThumbnailItem(const wxString& filename, TItemType type, long series_pk, long file_pk, bool linked):wxImageThumbnailItem(filename)
		{
			m_type = type;
			m_filepk = file_pk;
			m_seriespk = series_pk;
			isLinked = linked;
		}

		bool wxHistoryImageThumbnailItem::Draw(wxDC& dc, wxThumbnailCtrl* ctrl, const wxRect& rect, int style)
		{
			wxImageThumbnailItem::Draw(dc, ctrl, rect, style);
			if (isLinked) {
				wxBitmap tagBitmap = GinkgoResourcesManager::History::GetIcoLinked();
				if (tagBitmap.Ok())
				{
					int x = rect.x + ctrl->GetThumbnailMargin();
					int y = rect.y + ctrl->GetThumbnailMargin();
					dc.DrawBitmap(tagBitmap, x, y, true);
				}
			}
			return true;
		}
	}
}
