/*
 *  
 *  $Id: panelconfiguracionpacs.h $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iconfiguracion.h>
#include "panelesconfiguracionginkgobase.h"
#include <string>
#include <vector>

namespace GNC {
	namespace GUI {

		class PanelConfiguracionPACS: public PanelConfiguracionPACSBase, public IPasoConfiguracion
		{
			public:
				PanelConfiguracionPACS(wxWindow* pParent, IDialogoConfiguracion* pDialogo);
				~PanelConfiguracionPACS();

				void Recargar();

				//region "Metodos de IPasoConfiguracion"
				wxWindow* GetPanel();

				std::string GetTitle();

				std::string GetCabecera();

				bool Validar();

				bool Guardar();
				//endregion
				
				typedef struct TipoPACS {
					std::string id;
					std::string aet;
					std::string host;
					int puerto;
					int pdu;

					bool retrieveSeries;
					bool retrieveWithMove;
					bool useTLS;
					std::string pacsUser;
					std::string pacsPass;
					bool verifyCredentials;
					std::string certificate;
					std::string privateKey;
					bool isDefault;
					bool reuseConnection;
					std::string defaultCharset;

					TipoPACS() :
							puerto(11112),
							pdu(16384),
							retrieveSeries(true),
							retrieveWithMove(true),
							useTLS(false),
							verifyCredentials(false),
							isDefault(false),
							reuseConnection(false),
							defaultCharset("ISO_IR 100")
					{

					}
				} TipoPACS;

				typedef struct TipoConfigLocal{
					bool useTLS;
					bool verifyCredentials;
					std::string privateKey;
					std::string certificate;

					TipoConfigLocal() :
							useTLS(false),
							verifyCredentials(false)
					{
					}
				} TipoConfigLocal;
			protected:
				virtual void OnAdvancedLocal(wxCommandEvent &event);
				virtual void OnListaPACSChoice(wxTreeEvent &event);
				virtual void OnListaPACSDClick(wxTreeEvent&event);

				virtual void OnNuevoClick(wxCommandEvent &event);

				virtual void OnEditarClick(wxCommandEvent &event);

				virtual void OnEliminarClick(wxCommandEvent &event);

				virtual void OnSetDefaultClick(wxCommandEvent &event);

				virtual void OnTextoCambiado(wxCommandEvent &event );

				void OnSize(wxSizeEvent &);

				typedef std::vector <TipoPACS> TipoListaPACS;
				TipoListaPACS m_servidores;				
				TipoConfigLocal m_configLocal;

		};
	}
}
