/*
*  
*  $Id: estilo.h $
*  Ginkgo CADx Project
*
*  Copyright 2008-12 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

class vtkImageData;
class vtkGinkgoImageViewer;

namespace GNC {
	namespace GCS {
		namespace Events {

			class EXTAPI EventoColorPaciente : public GNC::GCS::Events::IEvent
			{
			public:
				typedef struct TColor {
					unsigned char r;
					unsigned char g;
					unsigned char b;
				} TColor;

				// El parametro render indica si en el preprocesado de este evento, se debería apilar o no un render
				EventoColorPaciente(const std::string& idPaciente = "", TColor* pColor = NULL) : GNC::GCS::Events::IEvent(ginkgoEVT_Core_Estilo,0,100,NULL)
				{
					m_idPaciente = idPaciente;
					m_pColor = pColor;
				}

				~EventoColorPaciente()
				{
				}

				virtual void pushInfo(std::ostream& out) const {
					out << "EventoColorPaciente";
				}

				void SetColorPaciente(TColor color)
				{
					if(m_pColor != NULL) {
						(*m_pColor) = color;
					}
				}

				const std::string& GetIdPaciente()
				{
					return m_idPaciente;
				}
			protected:
				TColor*  m_pColor;
				std::string m_idPaciente;
			};
		}
	}
}
