/*
 *  
 *  $Id: clientesoapintegracion.h 3066 2010-12-21 10:10:14Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <ostream>
#include <string>

class wxString;

namespace GIL {
	namespace GnkNetwork {
		namespace GnkSOAP {
			class ClienteSOAPException : public std::exception {
			public:
				ClienteSOAPException(const std::string& msg, bool fatal = true) throw()
				{
					this->cause = msg;
					this->fatal = fatal;
				}
				~ClienteSOAPException() throw()
				{
				}

				const std::string& GetCause() const {
					return cause;
				}

				bool IsFatal()  const {
					return fatal;
				}

				operator const std::string () const;

				friend std::ostream& operator<<(std::ostream& out, const ClienteSOAPException& ex)
				{
					out << (const std::string&) ex;
					return out;
				}

				friend std::ostream& operator<<(std::ostream& out, const ClienteSOAPException* ex)
				{
					if (ex != NULL) {
						out << *ex;
					}
					else {
						out << "(NULL)";
					}
					return out;
				}

			protected:
				std::string cause;
				bool fatal;
			};


			class ClienteSOAPIntegracion
			{
				ClienteSOAPIntegracion();
				~ClienteSOAPIntegracion();

			public:

				static std::string GetXMLPeticion(const std::string& xmlTicket);

				static void ParseURL(const std::string url,std::string& protocolo, std::string& host, int& puerto, std::string& path);
			protected:
				static std::string ConstruirPeticionSOAP(const std::string& ticket);
				static std::string ParsearSOAPRespuesta(const std::string& respuesta);
				static bool CompararNombreIgnorandoNamespace(const wxString& nombre,const wxString& comparacion);

			};
		};
	};
};
