/*
 *  
 *  $Id: paneltags.cpp 3834 2011-05-10 07:42:57Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>

#include "paneltags.h"

#include <api/icontroladoreventos.h>

#include <api/icontextoestudio.h>
#include <api/dicom/idicommanager.h>

#include <main/controllers/pacscontroller.h>
#include <main/controllers/controladorvistas.h>

#include <eventos/eventosginkgo.h>


GNC::GUI::PanelTags::PanelTags(wxWindow* pPadre) : PanelTagsBase(pPadre, -1, wxDefaultPosition, wxDefaultSize)
{
	Freeze();
	//eventos
//	m_pTags->Connect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(PanelTags::OnPropertyChanged),NULL,this);
//	m_pTags->Connect(wxEVT_PG_CHANGING,wxPropertyGridEventHandler(PanelTags::OnPropertyChanging),NULL,this);

	Thaw();
}

GNC::GUI::PanelTags::~PanelTags()
{
//	m_pTags->Disconnect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(PanelTags::OnPropertyChanged),NULL,this);
//	m_pTags->Disconnect(wxEVT_PG_CHANGING,wxPropertyGridEventHandler(PanelTags::OnPropertyChanging),NULL,this);
}

bool GNC::GUI::PanelTags::IsVisiblePanelTags()
{
	return IsShown();
}

void GNC::GUI::PanelTags::MostrarOcultarPanelTags()
{
	if (IsShown()) {
		GNC::GCS::ControladorVistas::Instance()->OcultarPanel(this);
	} else {
		GNC::GCS::ControladorVistas::Instance()->MostrarPanel(this);
	}
}

void GNC::GUI::PanelTags::SetEstudio(GnkPtr<GNC::GCS::IContextoEstudio> pEstudio)
{
	m_pTags->Clear();
	if(!pEstudio.IsValid())
	{
		
		return;
	}

	GnkPtr<GIL::DICOM::TipoMetaInfo> info = pEstudio->GetMetaInfoDeImagenActiva();
	GnkPtr<GIL::DICOM::TipoJerarquia> pJerarquia = pEstudio->GetTagsImagenDeImagenActiva();
	
	GIL::DICOM::IDICOMManager*	pDICOMManager = GIL::DICOM::PACSController::Instance()->CrearInstanciaDeDICOMManager();
	
	if (info) {
		for(GIL::DICOM::TipoMetaInfo::ListaTags::iterator it = info->tags.begin(); it!= info->tags.end(); it++) {
			wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).first).c_str());
			
			wxStringProperty* prop = NULL;
			wxString valor;
			if((*it).second.size()>100) {
				valor = _("Data");
			} else {
				std::string oidname = pDICOMManager->GetOIDName((*it).second);
				if (oidname.size() > 0) {
					valor = wxString::FromUTF8(oidname.c_str()) + wxT("[") + wxString::FromUTF8((*it).second.c_str()) + wxT("]");
				}
				else {
					valor = wxString::FromUTF8((*it).second.c_str());
				}
			}
			
			wxString label;
			if(helpString.size()>0){
				label = wxT("(") + wxString::FromUTF8((*it).first.c_str()) + wxT(") ") + helpString;
			}else{
				label = wxT("(") + wxString::FromUTF8((*it).first.c_str()) + wxT(") ");
			}
			while(m_pTags->GetProperty(label) != NULL)
				label = label + wxT(" ");
			prop = new wxStringProperty(label,
										wxPG_LABEL,valor);
			
			prop->SetHelpString(wxString::FromUTF8((*it).first.c_str()));
			m_pTags->AppendIn(m_pTags->GetRoot(), prop);
			prop->SetFlag(wxPG_PROP_READONLY);
			//m_pTags->SetDisableProperty(prop);
		}
	}
	
	SetTags(*pJerarquia, m_pTags->GetRoot(), pDICOMManager);
	GIL::DICOM::PACSController::Instance()->LiberarInstanciaDeDICOMManager(pDICOMManager);
}

void GNC::GUI::PanelTags::SetTags(GIL::DICOM::TipoJerarquia& base, wxPGPropArg idPadre, GIL::DICOM::IDICOMManager* pDICOMManager) 
{	
	for(GIL::DICOM::ListaTags::iterator it = base.tags.begin(); it!= base.tags.end(); it++) {
		wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).first).c_str());
		wxStringProperty* prop = NULL;
		wxString valor;
		if((*it).second.size()>100) {
			valor = _("Data");
		} else {
			valor = wxString::FromUTF8((*it).second.c_str());
		}

		wxString label;
		if(helpString.size()>0){
			label = wxT("(") + wxString::FromUTF8((*it).first.c_str()) + wxT(") ") + helpString;
		}else{
			label = wxT("(") + wxString::FromUTF8((*it).first.c_str()) + wxT(") ");
		}
		while(m_pTags->GetProperty(label) != NULL)
			label = label + wxT(" ");
		prop = new wxStringProperty(label,
			wxPG_LABEL,valor);

		prop->SetHelpString(wxString::FromUTF8((*it).first.c_str()));
		m_pTags->AppendIn(idPadre, prop);
		prop->SetFlag(wxPG_PROP_READONLY);
		//m_pTags->SetDisableProperty(prop);
	}

	for(GIL::DICOM::TipoJerarquia::ListaJerarquias::iterator it = base.secuencias.begin(); it!=base.secuencias.end(); it++){
		wxStringProperty* prop = NULL;
		wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).tagName).c_str());

		wxString label;
		if(helpString.size()>0){
			label = wxT("(") + wxString::FromUTF8((*it).tagName.c_str()) + wxT(") ") + helpString;
		}else{
			label = wxT("(") + wxString::FromUTF8((*it).tagName.c_str()) + wxT(") ");
		}
		while(m_pTags->GetProperty(label) != NULL)
			label = label + wxT(" ");
		prop = new wxStringProperty(label,
			wxPG_LABEL,wxEmptyString);

		prop->SetHelpString(wxString::FromUTF8((*it).tagName.c_str()));

		wxPGId pIdSequencia = m_pTags->AppendIn(idPadre,prop);
		pIdSequencia->SetFlag(wxPG_PROP_READONLY);
		//m_pTags->DisableProperty(pIdSequencia);
		//recursion
		int i=0;
		for(GIL::DICOM::TipoJerarquia::ListaJerarquias::iterator it2 = (*it).items.begin(); it2!= (*it).items.end(); it2++, i++) {
			wxPGPropArg pIdItem = m_pTags->AppendIn(pIdSequencia,new wxStringProperty(wxString::Format(wxT("Item %d"),i),wxPG_LABEL,wxEmptyString));
			
			SetTags((*it2), pIdItem, pDICOMManager);
		}
	}
}


//endregion


void GNC::GUI::PanelTags::OnPropertyChanged(wxPropertyGridEvent& /*event*/) {
	/*wxPGProperty* selected= event.GetProperty();
	selected->ClearFlag(wxPG_PROP_INVALID_VALUE);
	//se avisa a la vista para que tenga en cuenta que se ha modificado algún campo DICOM

	GNC::GCS::Eventos::EventoModificacionFichero* pEvt = new GNC::GCS::Eventos::EventoModificacionFichero();
	pEvt->SetVista(m_pVista);
	m_pEntorno->GetControladorEventos()->ProcesarEvento(pEvt);*/

}

void GNC::GUI::PanelTags::OnPropertyChanging(wxPropertyGridEvent& /*event*/) {
	/*wxPGProperty* selected= event.GetProperty();
	selected->ClearFlag(wxPG_PROP_INVALID_VALUE);
	//se avisa a la vista para que tenga en cuenta que se ha modificado algún campo DICOM
	wxString mensaje = wxEmptyString;
	if(selected == m_pEdadPaciente){				
	if(!ValidarLong(event.GetValue().GetString(),0,199)){
	mensaje += wxT("La edad ha de ser un entero entre 0 y 199");
	}
	}
	if(selected == m_pAlturaPaciente){	
	if(!ValidarDouble(event.GetValue().GetString(),0.01f,3.0f)){
	mensaje += wxT("El formato de la altura no es correcto. Ha de ser un numero real entre 0.01 y 3.");
	}
	}
	if(selected == m_pPesoPaciente) {			
	if(!ValidarDouble(event.GetValue().GetString(),0.01f,400.0f)){
	mensaje += wxT("El formato del peso no es correcto. Ha de ser un numero real entre 0.01 y 400.");
	}
	}
	if(selected == m_pHoraEstudio || selected == m_pHoraSerie){
	if(!ValidarHora(event.GetValue())){
	mensaje += wxT("El formato de la hora ha de ser HHMMSS.");
	}
	}
	if(mensaje != wxEmptyString){
	wxMessageBox(mensaje, wxT("Error validar los campos"), wxICON_ERROR);
	event.Veto();
	}*/	
}
