/*
*  
*  $Id: itoolwindowlevellight.h 4468 2011-12-09 10:02:00Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include <export/icontratoscore.h>
#define HLightVisualizator_WindowLevelLight   6001

namespace LightVisualizator {
	class IContratoWindowLevelLight: public GNC::GCS::IContractWindowLevel {
	public:
		IContratoWindowLevelLight() {
			CurrentWindow = 0.0;
			CurrentLevel = 0.0;
			AutoWindowLevel = true;
		}
		~IContratoWindowLevelLight() {
		}

		double CurrentWindow;
		double CurrentLevel;
		bool AutoWindowLevel;
	};

	class IToolWindowLevelLight: public GNC::GCS::IHerramienta, public GNC::GCS::IContratable<LightVisualizator::IContratoWindowLevelLight> {
	public:
		typedef LightVisualizator::IContratoWindowLevelLight TContratoWindowLevel;
		typedef GNC::GCS::IContratable<TContratoWindowLevel> TContratableWindowLevel;

		static const IHerramienta::UID ID = HLightVisualizator_WindowLevelLight;
		IToolWindowLevelLight() : IHerramienta(HLightVisualizator_WindowLevelLight,TFamiliaVisualizacion,"WindowLevelLight") {};
		virtual ~IToolWindowLevelLight() {};

		virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

		virtual void ConectarContratos(bool) = 0;

		virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
			return TContratableWindowLevel::ValidaContrato(pVista);
		}
	};
}
