/*
 *  
 *  $Id: prvext.h 4552 2012-01-17 07:51:42Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <iostream>
#include <string>
#include <fstream>
#include <sstream>
#include <list>

#include <api/api.h>

#if defined(_WINDOWS)
#include <windows.h>
#endif

#include <main/licencia.h>

class wxWindow;

namespace GNC {
	namespace GCS {
		class IEntorno;
		class IControladorModulo;
	}
}
#if defined(_DEBUG)
	#define PRIVATE_EXTENSION_NAME CreatePrivateExtensionDebug
#else
	#define PRIVATE_EXTENSION_NAME CreatePrivateExtension
#endif


#if defined(WIN32)
	#define IMPLEMENT_BuildDescriptorEntryPoint() \
		extern "C" __declspec(dllexport) void BuildDescriptor(HWND hwnd, HINSTANCE hinst, LPSTR lpszCmdLine, int nCmdShow) { \
			std::string args = lpszCmdLine; \
			std::stringstream is(args); \
			std::string path; \
			std::string extFileName; \
			is >> path; \
			is >> extFileName; \
			std::string fullPath = path + "\\" + extFileName + ".inf"; \
			std::cout << "Writing extension descriptor to " << fullPath.c_str() << " ..." << std::endl; fstream fs; \
			fs.open ( fullPath.c_str(), fstream::out); \
			fs << "DLL=" << extFileName << ".dll" << std::endl; \
			fs << PRIVATE_EXTENSION_NAME() << std::endl; \
			fs << "CORE_VERSION=" << GINKGO_VERSION << std::endl; \
			fs << "CORE_SUBVERSION=" << GINKGO_SUB_VERSION << std::endl; \
			fs.close(); \
			std::cout << "Done" << std::endl; \
		}

	#if defined(_DEBUG)
		#define IMPLEMENT_PrivateExtension(name) \
			extern "C" __declspec(dllexport) PrivateExtension* PRIVATE_EXTENSION_NAME() { return new name();}\
			IMPLEMENT_BuildDescriptorEntryPoint()

	#else
		#define IMPLEMENT_PrivateExtension(name) \
			extern "C" __declspec(dllexport) PrivateExtension* PRIVATE_EXTENSION_NAME() { return new name();}\
			IMPLEMENT_BuildDescriptorEntryPoint()
	#endif
#else

	#define IMPLEMENT_BuildDescriptorEntryPoint() \
		extern "C" EXTAPI int main(int argc, char**argv) { \
			std::string args = argv[1]; \
			std::stringstream is(args); \
			std::string path; \
			std::string extFileName; \
			is >> path; \
			is >> extFileName; \
			std::string fullPath = path + "\\" + extFileName + ".inf"; \
			std::cout << "Writing extension descriptor to " << fullPath.c_str() << " ..." << std::endl; fstream fs; \
			fs.open ( fullPath.c_str(), fstream::out); \
			fs << "DLL=" << extFileName << ".dll" << std::endl; \
			fs << PRIVATE_EXTENSION_NAME() << std::endl; \
			fs << "CORE_VERSION=" << GINKGO_VERSION << std::endl; \
			fs << "CORE_SUBVERSION=" << GINKGO_SUB_VERSION << std::endl; \
			fs.close(); \
			std::cout << "Done" << std::endl; \
		}

	#if defined(_DEBUG)
		#define IMPLEMENT_PrivateExtension(name) \
			extern "C" EXTAPI PrivateExtension* PRIVATE_EXTENSION_NAME() { return new name();};\
			IMPLEMENT_BuildDescriptorEntryPoint()
	#else
		#define IMPLEMENT_PrivateExtension(name) \
			extern "C" EXTAPI PrivateExtension* PRIVATE_EXTENSION_NAME() { return new name();};\
			IMPLEMENT_BuildDescriptorEntryPoint()
	#endif

	
#endif

class PrivateExtension
{
public:
	typedef std::list<GNC::GCS::IControladorModulo*> TListControllers;
	PrivateExtension(const std::string& sid, const std::string& provider, const std::string& description, int version, int subversion, int subrelease, const char* svnBuildString, const char* codename, const char* updateurl, const unsigned char* pixelDataIcon = NULL, unsigned int iconSize = 0)
	{
		this->sid = sid;
		this->provider = provider;
		this->description = description;
		this->version = version;
		this->subversion = subversion;
		this->subrelease = subrelease;
		this->build = ParseSVNBuild(svnBuildString);
		this->codename = codename;
		this->updateurl = updateurl;

		this->iconSize = iconSize;
		this->pixelDataIcon = pixelDataIcon;
		
		AsignarFechaCompilacion(__DATE__);
	}

	PrivateExtension(const PrivateExtension& o)
	{
		*this = o;
	}

	virtual ~PrivateExtension()
	{
	}

	virtual TListControllers InitializeLibrary(GNC::GCS::IEntorno* pEntorno) = 0;
	virtual bool IsActivated() = 0;
	virtual void ShowActivationDialog(wxWindow* pParent) = 0;

	int GetVersion() const
	{
		return this->version;
	}

	int GetSubVersion() const
	{
		return this->subversion;
	}

	int GetSubRelease() const
	{
		return this->subrelease;
	}

	int GetBuild() const
	{
		return this->build;
	}

	std::string GetCodeName() const
	{
		return this->codename;
	}

	const std::string& GetSID() const
	{
		return this->sid;
	}

	const std::string& GetProvider() const
	{
		return this->provider;
	}

	const std::string& GetDescription() const
	{
		return this->description;
	}

	void AsignarFechaCompilacion(const std::string& fecha)
	{
		this->fecha_compilacion = fecha;
	}

	void AsignPath(const std::string& path) 
	{
		this->path = path;
	}

	const std::string& GetPath() const
	{
		return this->path;
	}

	const std::string& GetFechaCompilacion() const
	{
		return this->fecha_compilacion;
	}

	int GetSVNBuild() const 
	{
		return build;
	}

	const std::string& GetUpdateURL() const
	{
		return updateurl;
	}

	const unsigned char* GetPixelDataIcon()
	{
		return pixelDataIcon;
	}

	int GetIconSize() {
		return iconSize;
	}

	PrivateExtension& operator=(const PrivateExtension& o)
	{
		this->version = o.version;
		this->subversion = o.subversion;
		this->subrelease = o.subrelease;
		this->build = o.build;
		this->codename = o.codename;

		this->sid = o.sid;
		this->provider = o.provider;
		this->description = o.description;
		this->fecha_compilacion = o.fecha_compilacion;
		this->updateurl = o.updateurl;

		this->pixelDataIcon = o.pixelDataIcon;
		this->iconSize = o.iconSize;
		return *this;
	}

	friend std::ostream& operator<<(std::ostream &os, const PrivateExtension& ext)
	{
		os << "SID=" << ext.sid.c_str() << std::endl;
		os << "DESCRIPTION=" << ext.description.c_str() << std::endl;
		os << "PROVIDER=" << ext.provider.c_str() << std::endl;
		//os << "COMPILATION=" << ext.fecha_compilacion.c_str() << std::endl;
		os << "VERSION=" << ext.version << std::endl;
		os << "SUBVERSION=" << ext.subversion << std::endl;
		os << "RELEASE=" << ext.subrelease << std::endl;
		os << "BUILD=" << ext.build << std::endl;
		os << "CODENAME=" << ext.codename.c_str() << std::endl;
		os << "UPDATEURL=" << ext.updateurl.c_str();
		return os;		
	}

	friend std::ostream& operator<<(std::ostream& os, PrivateExtension* ext)
	{
		if (ext != NULL) {
			return os << (*ext);
		}
		else {
			return os << "NULL";
		}
	}

protected:
	int version;
	int subversion;
	int subrelease;
	int build;

	std::string codename;
	std::string sid;
	std::string provider;
	std::string description;
	std::string fecha_compilacion;
	std::string path;
	std::string updateurl;
	const unsigned char* pixelDataIcon;
	unsigned int	iconSize;

private:
	int ParseSVNBuild(const char* str)
	{
		int num = -1;
		std::string beg;
		std::string end;
		std::stringstream ss(str);
		ss >> beg >> num >> end;
		return num;
	}

};

//define a function pointer type for convenience
#ifndef __PLUGIN_FUNCTION
#define __PLUGIN_FUNCTION
typedef PrivateExtension* ( *CreatePrivateExtension_function)();
#endif //__PLUGIN_FUNCTION

