/*
 *  
 *  $Id: toolzoom.h 4488 2011-12-14 08:43:28Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <export/itoolzoom.h>
#include <api/toolhandlers/izoomhandler.h>
#include <api/api.h>
#include <widgets/wzoom.h>

namespace GNC {

	class EXTAPI ToolZoom : public GNC::GCS::IToolZoom, public GNC::GCS::ToolHandlers::IZoomHandler {
	public:
		typedef GNC::GCS::Eventos::EventoRaton       TEventoRaton;
		typedef GNC::GCS::Eventos::EventoTeclado     TEventoTeclado;
		typedef GNC::GCS::Widgets::WZoomBuilder      TBuilder;
		ToolZoom();
		~ToolZoom();

//region "Realización de la interfaz IHerramienta"

		// Setup de paneles
		virtual void CrearPaneles( wxPanel* panel );

//endregion

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);

//region "IWZoomObserver"
		virtual void ChangeZoom(int steps);
//endregion

	protected:

		TBuilder*            m_pBuilder;
	};
}
