/*
 *
 *  $Id: panelserie.cpp 4742 2012-02-23 10:57:03Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>
#include <wx/wx.h>
#include "panelserie.h"
#include "dialogoconfirmacioneliminar.h"
#include "dialogoabrircon.h"
#include <api/imodelointegracion.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorvistas.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/controladorcomandos.h>
#include <main/controllers/integrationcontroller.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorpermisos.h>
#include <main/controllers/controladorenviohl7.h>
#include <main/entorno.h>
#include <main/gui/pacsupload/wxwizarduploadpacs.h>
#include <commands/comandogenerarthumbnails.h>
#include <api/ivista.h>
#include <api/dicom/idicommanager.h>
#include <export/tagsprivadoscomunes.h>

#include <api/icontextoestudio.h>

#include <resources/ginkgoresourcemanager.h>
#include <main/entorno.h>
#include <main/gui/mainwindow/ventanaprincipal.h>
#include <eventos/eventosginkgo.h>

#include <wx/file.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/menu.h>
#include <wx/caret.h>


#define ID_MENUS 1401

#define FONDO_INACTIVO wxColour(96,96,96)
#define FONDO_ACTIVO   wxColour(242,215,16)

namespace GNC {
	namespace GUI {
		class TimerPanelSerie: public wxTimer {
		public:
			TimerPanelSerie(PanelSerie* pPanelSerie) {
				m_pPanelSerie = pPanelSerie;
				//el primer viaje es para los thumbnails
				m_parpadear = false;
			}
			~TimerPanelSerie() {
			}

			virtual void Notify() {
				if (m_parpadear) {
					m_pPanelSerie->OnTimerParpadeo();
				} else {
					m_pPanelSerie->GenerarThumbnail();
					m_parpadear = true;
				}
			}

			bool m_parpadear;
			PanelSerie* m_pPanelSerie;
		};
		/*CLASE PARA NOTIFICARLE QUE ESTA DISPONIBLE EL PREVIEW*/
		class NotificadorPreview : public GADAPI::INotificadorThumbnail
		{
		public:
			NotificadorPreview(PanelSerie* pPanel)
			{
				m_pPanelSerie = pPanel;
			}
			~NotificadorPreview() {
				m_pPanelSerie = NULL;
			}

			void SetImage(const std::string&, wxImage* pImage)
			{
				m_pPanelSerie->SetImage(pImage);
			}

			PanelSerie* m_pPanelSerie;
		};


		PanelSerie::PanelSerie(INodoHistorial* pPadre,  wxWindow* pParentWindow, const std::string& descripcion, const std::string& fecha,
			const std::string& hora, const std::string& id_importador, const std::string& id_modalidad,
			const std::string& uidSerie, const int numeroSlices, const std::string& uidEstudio, const std::string uidTransferSyntax):PanelSerieBase(pParentWindow),INodoHistorial(pPadre,uidSerie)
		{
			m_numeroSlices = numeroSlices;
			m_pNumeroCortes->SetLabel(wxString::Format(wxT("%d"),m_numeroSlices));
			InitFields(descripcion, fecha, hora, id_importador, id_modalidad, uidEstudio, uidTransferSyntax);
			m_pThumbnail->Hide();
			m_modificado = false;
			m_pNotificadorPreview = new NotificadorPreview(this);

			m_pBWin = NULL;
			m_pTimer = new TimerPanelSerie(this);
			//random 50 y 300
			m_dibujada = false;

			Layout();
		}
		PanelSerie::~PanelSerie()
		{
			GNC::GCS::ControladorComandos::Instance()->AbortarComandosDeOwnerAsincrono(this);
			delete m_pTimer;
			m_pTimer = NULL;

			if (m_pBWin != NULL) {
				m_pBWin->Show();
				m_pBWin = NULL;
			}

			if(EstaSeleccionado()){
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoSeleccionarHistorial(NULL));
			}
			m_pVistas.clear();
			std::list< std::string > listaUIDs;
			listaUIDs.push_back(m_clave);
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoAbribleEliminado(listaUIDs));
			delete m_pNotificadorPreview;
		}

		void PanelSerie::SetModeloIntegracion (GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion) {
			m_pModeloIntegracion = pModeloIntegracion;
		}

		
		void PanelSerie::InitFields(const std::string& descripcion, const std::string& fecha,
			const std::string& hora, const std::string& id_importador, const std::string& id_modalidad,
			const std::string& uidEstudio, const std::string uidTransferSyntax)
		{
			m_uidEstudio = uidEstudio;
			m_uidTransferSyntax = uidTransferSyntax;
			if(descripcion != "")
			{
				m_pDescripcionSerie->SetToolTip(wxString::FromUTF8(descripcion.c_str()));

				wxString tmp = wxString::FromUTF8(descripcion.c_str());
				wxClientDC dc(this);
				dc.SetFont(m_pDescripcionSerie->GetFont());
				int x,y;
				dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);

				while(x > 90)
				{
					dc.GetTextExtent(tmp, &x, &y, NULL, NULL, NULL);
					tmp = tmp.substr(0,tmp.size()-2);
				}
				if(descripcion.size() != tmp.size()) {
					std::stringstream ostr;
					ostr << tmp.ToUTF8() << "...";
					m_pDescripcionSerie->SetLabel(wxString::FromUTF8(ostr.str().c_str()));
				} else {
					m_pDescripcionSerie->SetLabel(wxString::FromUTF8(descripcion.c_str()));
				}
			} else {
				m_pDescripcionSerie->SetLabel(_("No description"));
			}

			m_pFechaSerie->SetLabel(wxString::FromUTF8(fecha.c_str()));
			m_pHoraSerie->SetLabel(wxString::FromUTF8(hora.c_str()));

			{
				std::ostringstream ostr;
				ostr << _Std("Description: ") << descripcion << std::endl;
				ostr << _Std("Date: ") << fecha << std::endl;
				ostr << _Std("Time: ") << hora << std::endl;
				ostr << _Std("Modality: ") << id_modalidad << std::endl;
				ostr << _Std("Series UID: ") << m_clave << std::endl;
				ostr << _Std("UID Importer: ") << id_importador;
				wxString toolTip = wxString::FromUTF8(ostr.str().c_str());

				SetToolTip(toolTip);
				m_pThumbnail->SetToolTip(toolTip);
			}

			m_idImportador = id_importador;
			m_idModalidad = id_modalidad;
			m_pModalidad->SetLabel(wxString::FromUTF8(m_idModalidad.c_str()));
		}

		int PanelSerie::RefrescarNumeroSlices()
		{
			m_numeroSlices = GNC::GCS::ControladorHistorial::Instance()->GetSlicesCount(m_clave);
			m_pNumeroCortes->SetLabel(wxString::Format(wxT("%d"),m_numeroSlices));
			Layout();
			return m_numeroSlices;
		}
		void PanelSerie::IncrementarNumeroSlices()
		{
			++m_numeroSlices;
			m_pNumeroCortes->SetLabel(wxString::Format(wxT("%d"),m_numeroSlices));
			Layout();
		}

		void PanelSerie::Seleccionar(bool seleccionar,bool force)
		{
			if(m_seleccionado!=seleccionar || force){
				m_seleccionado = seleccionar;
				Refresh();
			}
		}

		void PanelSerie::SetAbierto(bool abierto)
		{
			if(m_abierto!=abierto){
				m_abierto=abierto;
				UpdateStatus();
			}
		}
		void PanelSerie::SetModificado(bool modificado)
		{
			if(m_modificado!=modificado){
				m_modificado=modificado;
				UpdateStatus();
			}
		}

		void PanelSerie::UpdateStatus()
		{
			wxColour color( 255, 255, 255 );
			if(m_abierto && m_modificado) {
				color = wxColour(255,0,0);
			}
			else if(m_abierto) {
				color = wxColour(0,255,0);
			}
			m_pDescripcionSerie->SetForegroundColour(color);
			m_pFechaSerie->SetForegroundColour(color);
			m_pHoraSerie->SetForegroundColour(color);
			m_pModalidad->SetForegroundColour(color);
			m_pNumeroCortes->SetForegroundColour(color);
			Refresh();
		}

		void PanelSerie::SetImage(wxImage* pImage)
		{
			if(pImage != NULL && pImage->IsOk()) {
				wxBitmap bitmap(*pImage);
				m_pThumbnail->SetBitmap(bitmap);
				m_pThumbnail->Show();
			}
			Layout();
		}

		void PanelSerie::GenerarThumbnail()
		{
			//generar el thumbnail!!!
			GADAPI::ComandoGenerarThumbnails* pCmd = new GADAPI::ComandoGenerarThumbnails(GNC::GCS::ControladorHistorial::Instance()->GetPathFrameOfReference(m_clave),m_pNotificadorPreview);
			GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Creating Thumbnail..."),pCmd,this);
		}

		//eventos
		void PanelSerie::OnMouseAbrir(wxMouseEvent& event)
		{
			Abrir();
			event.Skip(false);
		}

		void PanelSerie::OnMouseSeleccionar(wxMouseEvent &event)
		{
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoSeleccionarHistorial(this));
			event.Skip(false);
		}

		void PanelSerie::OnKeyDown(wxKeyEvent &event)
		{

			if (event.GetKeyCode() == WXK_DELETE) {
				DoDelete(true);
				event.Skip(false);
			}
		}

		void PanelSerie::OnMenuMouse(wxMouseEvent &event)
		{
			//se selecciona
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoSeleccionarHistorial(this));
			wxMenu menu;
			menu.Append(4, _("Open Series"));
			menu.Connect(4,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelSerie::OnAbrir),NULL,this);
			menu.Append(5, _("Open Series with .."));
			menu.Connect(5,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelSerie::OnAbrirCon),NULL,this);
				
			
			//Do you have to reprocess this series?
			GNC::GCS::IControladorModulo* pModulo = NULL;

			GNC::ControladorExtensiones::ListaModulos listaModulos = ControladorExtensiones::Instance()->Modulos();
			for(GNC::ControladorExtensiones::IteradorListaModulos itModulos = listaModulos.begin(); itModulos!= listaModulos.end() && pModulo == NULL; ++itModulos)
			{
				if((*itModulos).second->SupportsImportationUID(m_idImportador)) {
					pModulo = (*itModulos).second;
					break;
				}
			}

			if(pModulo != NULL) {
				//reprocess integration xml... read xml from first file..
				std::vector<std::string> rutas = GNC::GCS::ControladorHistorial::Instance()->GetPathsSerieOrdenados(m_clave);
				GIL::DICOM::IDICOMManager* pManager = GNC::Entorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
				GIL::DICOM::TipoPrivateTags tagsPrivados(UID_TAGS_PRIVADOS_COMUNES);
				pManager->CargarFichero(rutas[0]);
				pManager->CargarTagsPrivados(tagsPrivados);
				std::string xmlString;
				if (tagsPrivados.GetTag(TAG_XML_INTEGRACION, xmlString)) {
					wxMenuItem* pMenuSend = new wxMenuItem(&menu, 8, wxString( _("Reprocess Series") ), _("Reprocess Series"), wxITEM_NORMAL );
					menu.Connect(8,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelSerie::OnReprocessIntegration),NULL,this);
					#ifdef __WXMSW__
					pMenuSend->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoReset());
					#else
					pMenuSend->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoReset());
					#endif
					menu.AppendSeparator();
					menu.Append(pMenuSend);
				}
				GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pManager);				
			}
			//end reprocess		

			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_upload")) {
				wxMenuItem* pMenuSend = new wxMenuItem(&menu, 7, wxString( _("Send to PACS server") ), _("Send to PACS server"), wxITEM_NORMAL );
				menu.Connect(7,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelSerie::OnUploadPACS),NULL,this);
				#ifdef __WXMSW__
				pMenuSend->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
				#else
				pMenuSend->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
				#endif
				menu.AppendSeparator();
				menu.Append(pMenuSend);
			}

			if (!GNC::GCS::ControladorHistorial::Instance()->IsReadOnly()) {
				wxMenuItem* pMenuEliminar = new wxMenuItem(&menu, 3, wxString( _("&Delete from history") ), _("Delete"), wxITEM_NORMAL );
				menu.Connect(3,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelSerie::OnEliminar),NULL,this);
				#ifdef __WXMSW__
				pMenuEliminar->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoEliminar());
				#else
				pMenuEliminar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoEliminar());
				#endif
				menu.AppendSeparator();
				menu.Append(pMenuEliminar);

				wxMenuItem* pMenuLimpiar = new wxMenuItem(&menu, 6, wxString( _("&Clear History") ), _("Delete"), wxITEM_NORMAL );
				menu.Connect(6,wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( PanelSerie::OnLimpiarHistorial),NULL,this);
				#ifdef __WXMSW__
				pMenuLimpiar->SetBitmaps(GinkgoResourcesManager::PanelHistorial::GetIcoCleanAll());
				pMenuLimpiar->SetBitmap(GinkgoResourcesManager::PanelHistorial::GetIcoCleanAll());
				#endif
				menu.Append(pMenuLimpiar);
			}

			if (menu.GetMenuItemCount() > 0) {
				GNC::Entorno::Instance()->GetVentanaRaiz()->PopupMenu(&menu);
			}
			event.Skip(false);
		}

		void PanelSerie::OnMouseWheel(wxMouseEvent& event)
		{
			event.ResumePropagation(2);
			event.Skip(true);
		}

		//movidas de estudio para ver si esta abierto y tal
		void PanelSerie::AddVista(GNC::GCS::IVista* pVista){
			//esta cargado
			if(pVista!=NULL){
				if(!m_abierto) {
					SetAbierto(true);
				}
				for(std::list<GNC::GCS::IVista*>::iterator it = m_pVistas.begin(); it != m_pVistas.end(); it++){
					if(pVista==*it){
						return;
					}
				}
				m_pVistas.push_back(pVista);
			}
		}

		void PanelSerie::VistaModificada(GNC::GCS::IVista* pVista){
			//esta cargado
			if(pVista != NULL){
				SetModificado(true);
			}
		}

		void PanelSerie::VistaGuardada(GNC::GCS::IVista* pVista){
			//esta cargado
			if(pVista != NULL){
				if(m_modificado){
					SetModificado(false);
				}
			}
		}

		void PanelSerie::RemoveVista(GNC::GCS::IVista* pVista){
			//esta cargado
			if(pVista!=NULL){
				for(std::list<GNC::GCS::IVista*>::iterator it = m_pVistas.begin(); it != m_pVistas.end(); it++){
					if(pVista == *it){
						m_pVistas.erase(it);
						break;
					}
				}
				if(m_pVistas.size() == 0){
					SetAbierto(false);
					SetModificado(false);
				}
			}
		}

		void PanelSerie::OnAbrir(wxCommandEvent& )
		{
			Abrir(false);
		}

		void PanelSerie::Abrir(bool forzarEstudio)
		{
			//ir a la pestaña del estudio
			if(m_abierto) {
				if (m_pBWin != NULL) {
					m_pBWin->Show();
					m_pBWin = NULL;
				}
				wxBell();

				GNC::Entorno::Instance()->GetVentanaPrincipal()->ForzarCambioVista(m_pVistas.front());
				GNC::GCS::IVista* pVista = GNC::Entorno::Instance()->GetControladorVistas()->GetVistaActiva();
				if(pVista != NULL) {
					m_pBWin = pVista->GetWindow();
					pVista->ActivarRuta(GNC::GCS::ControladorHistorial::Instance()->GetPathFrameOfReference(m_clave));
					m_pBWin->Hide();
					if (m_pTimer->IsRunning()) {
						m_pTimer->Stop();
					}
					m_pTimer->Start(100, true);
					return;
				} else {
					//se trata de un dialogo
					return;
				}
			}

			//max number of opened tabs
			GNC::GCS::Permisos::EstadoPermiso estado = GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions", "max_tabs");
			if (estado) {
				long maxNumberOfTabs = estado.ObtenerValor<long>();
				if ((int)GNC::Entorno::Instance()->GetControladorVistas()->GetVistas().size() >= maxNumberOfTabs) {
						wxMessageBox(_("You have reached maximum number of opened tabs, close some tabs and try it again"), _("Info"),
							wxOK | wxICON_INFORMATION, GNC::Entorno::Instance()->GetVentanaRaiz());
						return;					
				}
			}
			//max

			//darse cuenta si debe abrirse por estudios, en ese caso decirle al padre que se quiere abrir...
			GNC::GCS::IControladorModulo* pModulo = NULL;
			GNC::GCS::ModoControlador* pModo = NULL;

			GNC::ControladorExtensiones::ListaModulos listaModulos = ControladorExtensiones::Instance()->Modulos();
			for(GNC::ControladorExtensiones::IteradorListaModulos itModulos = listaModulos.begin(); itModulos!= listaModulos.end() && pModo == NULL && pModulo == NULL; ++itModulos)
			{
				//se busca la vista del modulo q abra este tipo de ficheros
				for(GNC::GCS::IControladorModulo::IteradorListaModos itModos = (*itModulos).second->GetListaModos().begin(); itModos != (*itModulos).second->GetListaModos().end(); ++itModos){
					if((*itModos)->SupportsImportationUID(m_idImportador) && (*itModos)->SupportsModalityFile(m_idModalidad,m_uidTransferSyntax)) {
						pModo = (*itModos);
						pModulo = (*itModulos).second;
						break;
					}
				}
			}

			if(pModo== NULL || pModulo == NULL) {
				//intentamos abrir por modalidad
				std::list<GNC::GCS::IControladorModulo*> listaModulos = ControladorExtensiones::Instance()->ModulosOrdenados();
				for(std::list<GNC::GCS::IControladorModulo*>::iterator itModulos=listaModulos.begin(); itModulos != listaModulos.end() && pModo == NULL && pModulo == NULL; ++itModulos){
					for(GNC::GCS::IControladorModulo::IteradorListaModos itModos = (*itModulos)->GetListaModos().begin(); itModos != (*itModulos)->GetListaModos().end(); ++itModos){
						if((*itModos)->SupportsModalityFile(m_idModalidad,m_uidTransferSyntax)) {
							pModo = (*itModos);
							pModulo = (*itModulos);
							break;
						}
					}
				}
			}

			if(pModo != NULL && pModulo != NULL){
				AbrirDICOM(pModulo, pModo->GetId(), forzarEstudio);
			}
			else{
				wxString strModalidades=wxT("");
				wxMessageBox(_("Unable to open modality ") + wxString::FromUTF8(m_idModalidad.c_str()) + _( " with transfer syntax ") << wxString::FromUTF8(m_uidTransferSyntax.c_str()), _("Info"),
						 wxOK | wxICON_INFORMATION, GNC::Entorno::Instance()->GetVentanaRaiz());
			}

		}

		void PanelSerie::OnAbrirCon(wxCommandEvent& )
		{
			//max number of opened tabs
			GNC::GCS::Permisos::EstadoPermiso estado = GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions", "max_tabs");
			if (estado) {
				long maxNumberOfTabs = estado.ObtenerValor<long>();
				if ((int)GNC::Entorno::Instance()->GetControladorVistas()->GetVistas().size() >= maxNumberOfTabs) {
						wxMessageBox(_("You have reached maximum number of opened tabs, close some tabs and try it again"), _("Info"),
							wxOK | wxICON_INFORMATION, GNC::Entorno::Instance()->GetVentanaRaiz());
						return;					
				}
			}
			//max

			DialogoAbrirCon::ListaModalidades listaModalidades;
			listaModalidades.push_back(std::pair<std::string,std::string>(m_idModalidad, m_uidTransferSyntax));

			DialogoAbrirCon dialogoAbrir(GNC::Entorno::Instance()->GetVentanaRaiz(), listaModalidades);
			int answer = dialogoAbrir.ShowModal();
			if (answer == wxID_OK) {
				AbrirDICOM(dialogoAbrir.GetModuloSeleccionado(), dialogoAbrir.GetModoSeleccionado()->GetId(), false);
			}
		}

		void PanelSerie::AbrirDICOM( GNC::GCS::IControladorModulo* pModulo, int idModo, bool forzarEstudio)
		{
			if(m_abierto) {
				int answer = wxMessageBox(_("The series selected is already open\nDo you want to open it again?"),_("Open again"), wxYES_NO , GNC::Entorno::Instance()->GetVentanaRaiz());
				if (answer != wxYES) {
					return;
				}
			}

			GNC::GCS::IControladorModulo::ListaDescriptoresSerie listaDescriptoresSerie;
			if( pModulo->GetModo(idModo)->AbreSeriesSueltas() && !forzarEstudio ) {
				listaDescriptoresSerie.push_back(GNC::GCS::IControladorModulo::DescriptorSerie(m_clave, m_idModalidad, m_uidTransferSyntax, m_pModeloIntegracion));
			} else {
				//pillamos todos los ficheros del estudio!!
				GNC::GCS::ControladorHistorial::ListaModelosSeries seriesEstudio;
				GNC::GCS::ControladorHistorial::Instance()->GetModelosSerieEstudio(m_uidEstudio, seriesEstudio);
				for(GNC::GCS::ControladorHistorial::ListaModelosSeries::iterator it = seriesEstudio.begin(); it != seriesEstudio.end(); it++) {
					//TODO FALTA RESOLVER EL TEMA MODELO DE INTEGRACION EN ESTE PUNTO
					if((*it).m_uidSerie == m_clave) {
						listaDescriptoresSerie.push_front(GNC::GCS::IControladorModulo::DescriptorSerie((*it).m_uidSerie, (*it).m_modalidad, (*it).m_uidTransferSyntax , NULL));
					} else {
						listaDescriptoresSerie.push_back(GNC::GCS::IControladorModulo::DescriptorSerie((*it).m_uidSerie, (*it).m_modalidad, (*it).m_uidTransferSyntax , NULL));
					}
				}
			}
			try {
				pModulo->AbrirVista(idModo,listaDescriptoresSerie);
			}
			catch (GNC::GCS::VistaException& ex)
			{
				LOG_ERROR("GNC/AbrirEstudio", (std::string)ex );
				wxMessageBox(wxString::FromUTF8( ((std::string)ex).c_str() ), _("Error loading study"),wxICON_ERROR);
			}
			catch (...)
			{
				LOG_ERROR("GNC/AbrirEstudio", "Error al abrir el estudio: Error interno");
				wxMessageBox(_( "Internal error" ), _("Error loading study"),wxICON_ERROR);
			}

		}

		void PanelSerie::OnEliminar(wxCommandEvent& event)
		{
			DoDelete(true);
			event.Skip(false);
		}
			
		bool PanelSerie::DoDelete(bool ask) 
		{
			if (EstaAbierto())
			{
				wxMessageBox(_("You can't remove opened series"), _("Info"),
					wxOK | wxICON_WARNING);
					return false;
			}

			bool eliminar = false;
			if (ask)	{
				DialogoConfirmacionEliminar dlg(GNC::Entorno::Instance()->GetVentanaRaiz(), _("this serie"));
				dlg.ShowModal();
				switch (dlg.GetResultado()) {
					case DialogoConfirmacionEliminar::TR_Eliminar :
						eliminar = true;
						break;
					case DialogoConfirmacionEliminar::TR_Cancelar :
						break;
				}
			} else {
				eliminar = true;
			}

			if(eliminar){
				GNC::GCS::ControladorHistorial::Instance()->EliminarSerie(m_clave,true);
				Eliminar();
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
			}
			return eliminar;
		}

		void PanelSerie::OnLimpiarHistorial(wxCommandEvent &event)
		{
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLimpiarHistorial());
			event.Skip(false);
		}

		void PanelSerie::OnUploadPACS(wxCommandEvent &)
		{
			wxWizardUploadPACSGinkgo::TListUIDs list;
			list.push_back(m_clave);
			wxWizardUploadPACSGinkgo wiz(GNC::Entorno::Instance()->GetVentanaRaiz(), list);
			wiz.ShowModal();
		}

		void PanelSerie::OnReprocessIntegration(wxCommandEvent &)
		{
			int answer = wxMessageBox(_("If you reprocess this series it will be uploaded to PACS server and \nintegration message will be resent to integration engine.\nDo you want to continue?"),_("Open again"), wxYES_NO , GNC::Entorno::Instance()->GetVentanaRaiz());
			if (answer != wxYES) {
				return;
			}

			//restart hl7 sending service
			if (!GIL::HL7::ControladorEnvioHl7::EstaArrancado()) {
				GIL::HL7::ControladorEnvioHl7::Arrancar();
			}
			//

			//darse cuenta si debe abrirse por estudios, en ese caso decirle al padre que se quiere abrir...
			GNC::GCS::IControladorModulo* pModulo = NULL;

			GNC::ControladorExtensiones::ListaModulos listaModulos = ControladorExtensiones::Instance()->Modulos();
			for(GNC::ControladorExtensiones::IteradorListaModulos itModulos = listaModulos.begin(); itModulos!= listaModulos.end() && pModulo == NULL; ++itModulos)
			{
				if((*itModulos).second->SupportsImportationUID(m_idImportador)) {
					pModulo = (*itModulos).second;
					break;
				}
			}

			//reprocess integration xml... read xml from first file..
			std::vector<std::string> rutas = GNC::GCS::ControladorHistorial::Instance()->GetPathsSerieOrdenados(m_clave);
			GIL::DICOM::IDICOMManager* pManager = GNC::Entorno::Instance()->GetPACSController()->CrearInstanciaDeDICOMManager();
			GIL::DICOM::TipoPrivateTags tagsPrivados(UID_TAGS_PRIVADOS_COMUNES);
			pManager->CargarFichero(rutas[0]);
			pManager->CargarTagsPrivados(tagsPrivados);
			std::string xmlString;
			if (!tagsPrivados.GetTag(TAG_XML_INTEGRACION, xmlString)) {
				wxMessageBox(_("Unable to reprocess this series. This series hasn't been dicomized with Ginkgo CADx."), _("Info"),
					 wxOK | wxICON_INFORMATION, GNC::Entorno::Instance()->GetVentanaRaiz());
				GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pManager);
				return;
			}
			GNC::Entorno::Instance()->GetPACSController()->LiberarInstanciaDeDICOMManager(pManager);

			try {
				GIL::IntegrationModelList listaModelos;
				GIL::IntegrationController::Instance()->ParsearModeloIntegracion(listaModelos,xmlString);
				GIL::IntegrationController::Instance()->ReProcess(pModulo, m_clave, listaModelos);
			}
			catch (GIL::IntegrationException& ex) {
				LOG_ERROR("GIL/WF", "Semantic/Sintactic error parsing integration XML: " << ex.GetFullCause());
				wxMessageBox(_("Semantic/Sintactic error parsing integration XML (see log for details):\n") + wxString::FromUTF8(ex.GetCause().c_str()),_("Error"),wxICON_INFORMATION);
			}
			catch (std::exception& ex4) {
				LOG_ERROR("GIL/WF", "Error executing WorkFlow: " << ex4.what());
				wxMessageBox(_("Error executing WorkFlow\n") + wxString::FromUTF8(ex4.what()),_("Error"),wxICON_INFORMATION);
			}
			catch (...) {
				LOG_ERROR("GIL/WF", "Error executing WorkFlow: Internal error.");
				wxMessageBox(_("Error executing WorkFlow\nInternal Error"), _("Error"),wxICON_INFORMATION);
			}
		}

		void PanelSerie::Detach(wxWindow* ){}

		void PanelSerie::Eliminar()
		{
			m_pPadre->Detach(this);
			if(m_pPadre->Eliminar(this)) {
				this->Destroy();
				//GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoLayoutHistorial());
			}
		}

		void PanelSerie::OnTimerParpadeo()
		{
			if (m_pBWin != NULL) {
				m_pBWin->Show();
				m_pBWin = NULL;
			}
		}

		void PanelSerie::OnPaint(wxPaintEvent &event)
		{
			if (!m_dibujada) {
				//la primera vez que se pinta se lanza el timer que generara el thumbnail (bajo demanda)
				float random = (((float)rand() / RAND_MAX) * 300) + 50;
				if (m_pTimer->IsRunning()) {
					m_pTimer->Stop();
				}
				m_pTimer->Start(random, true);
				m_dibujada = true;
			}
			PanelSerieBase::OnPaint(event);
			wxPaintDC dc(this);
			if (m_seleccionado) {
				dc.SetBrush(wxBrush(FONDO_ACTIVO,wxTRANSPARENT));
				dc.SetPen(wxPen(FONDO_ACTIVO, 1, wxSOLID));
			} else {
				dc.SetBrush(wxBrush(FONDO_INACTIVO,wxTRANSPARENT));
				dc.SetPen(wxPen(FONDO_INACTIVO, 1, wxSOLID));
			}
			dc.DrawRectangle(wxRect(wxPoint(0,0), wxPoint(dc.GetSize().x-1, dc.GetSize().y-1)));
		}

		std::string PanelSerie::GetModalidad()
		{
			return m_idModalidad;
		}
	}
}

