/*
*  
*  $Id: iherramientalayoutventana.h 3696 2011-04-14 08:40:28Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include <api/icontrato.h>
#include <export/icontratoscore.h>
#include "iherramientascore.h"

namespace GNC {
	namespace GCS {

		class EXTAPI IHerramientaLayoutVentana: public GNC::GCS::IHerramienta, public GNC::GCS::IContratable<IContratoLayoutVentana> {
		public:
			typedef GNC::GCS::IContratoLayoutVentana                      TContratoLayoutVentana;
			typedef GNC::GCS::IContratable<TContratoLayoutVentana> TContratableLayoutVentana;

			static const IHerramienta::UID ID = HCore_LayoutVentana;
			IHerramientaLayoutVentana() : IHerramienta(HCore_LayoutVentana,TMenuImagen, "Layout de la ventana",SubFamiliaImagenDisposicion) {};
			virtual ~IHerramientaLayoutVentana() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return GNC::GCS::IContratable<TContratoLayoutVentana>::ValidaContrato(pVista);
			}
		};

	};
}
