/*
*  
*  $Id: addficherohistorial.h 3698 2011-04-14 12:38:49Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

#include <string>
#include <vector>
#include <yasper/yasper.h>
#include <api/imodelointegracion.h>


namespace GNC {
	namespace GCS {
		namespace Eventos {

			class EXTAPI EventoAddFicheroHistorial: public GNC::GCS::Eventos::IEvento
			{
			public:

				typedef std::list<std::string> ListaRutas;

				EventoAddFicheroHistorial():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_AddFicheroHistorial)
				{
					m_Nombre = "AddFicheroHistorial";
				}

				EventoAddFicheroHistorial(ListaRutas lista, bool abrirDespuesDeCargar = true, bool isTmp = false ):GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_AddFicheroHistorial)
				{
					m_listaRutas = lista;
					m_abrirDespuesDeCargar = abrirDespuesDeCargar;
					m_isTmp = isTmp;
					m_Nombre = "AddFicheroHistorial";
				}

				~EventoAddFicheroHistorial()
				{
					m_listaRutas.clear();
				}

				void SetListaRutas(ListaRutas lista)
				{
					m_listaRutas=lista;
				}

				ListaRutas &GetListaRutas()
				{
					return m_listaRutas;
				}

				bool GetIsTmp(){
					return m_isTmp;
				}

				bool GetAbrirDespuesDeCargar(){
					return m_abrirDespuesDeCargar;
				}

				virtual void pushInfo(std::ostream& out) const {
					out << "Temp = " << m_isTmp << " Rutas = [ ";
					int i = 0;
					for (ListaRutas::const_iterator it = m_listaRutas.begin(); it != m_listaRutas.end(); it++) {
						if (i != 0) {
							out << ", ";
						}
						out << (*it).c_str();
					}
					out << " ]";
				}

				void SetModeloIntegracion(GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion) {
					m_pModeloIntegracion=pModeloIntegracion;
				}

				GnkPtr<GIL::IModeloIntegracion> GetModeloIntegracion() {
					return m_pModeloIntegracion;
				}

			protected:
				bool                m_isTmp;
				bool                m_abrirDespuesDeCargar;
				ListaRutas          m_listaRutas;
				GnkPtr<GIL::IModeloIntegracion> m_pModeloIntegracion;
			};
		}
	}
}
