/*
 *  
 *  $Id: ipacscontroller.cpp 4848 2012-04-18 09:43:41Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#include <list>
#include <map>

#ifdef verify
#define MACRO_QUE_ESTORBA verify
#undef verify
#endif
#include <api/controllers/ipacscontroller.h>
#include "dcmtk/dcmdata/dcdict.h"
#include <dcmtk/dcmdata/dctk.h>
#include "dcmtk/dcmimgle/dcmimage.h"
#include <api/icontextoestudio.h>

#ifdef MACRO_QUE_ESTORBA
#define verify MACRO_QUE_ESTORBA
#endif



namespace GIL {
	namespace DICOM {

		ICustomAssociation::ICustomAssociation() { }

		ICustomAssociation::~ICustomAssociation() { }

		void ICustomAssociation::addPresentationContext(const std::string& sopClass, const std::list<std::string>& transferSyntaxes)
		{
			std::map<std::string, std::list<std::string> > sop;
			sop[sopClass] = transferSyntaxes;
			presentationContexts.push_back(sop);
		}

		void ICustomAssociation::mapClassForPresentationContext(const std::string& src, const std::string& dest)
		{
			presentationContextMap[src] = dest;
		}

		const std::string& ICustomAssociation::getErrorMessage() const
		{
			return errorMsg;
		}

		/*------------------------------*/
		DcmElement* TagPrivadoString::ToElement(unsigned int group, unsigned int element)
		{
			OFCondition cond;
			DcmVR vr(EVR_LT);
			DcmTagKey key(group,element);
			DcmTag tag(key,vr);
			if (tag.error() != EC_Normal) {
				std::cerr << "error al almacenar los tags privados, tag desconocido: (" << group << ","<<element<<")" <<std::endl;
				return NULL;
			}

			DcmElement* pElement = newDicomElement(tag);

			if(pElement==NULL){
				std::cerr << "error al almacenar los tags privados, error al crear el elemento: (" << group << ","<<element<<") " <<std::endl;
				return NULL;
			}

			cond=pElement->putString(Valor.c_str());
			
			if (cond.bad()) {
				std::cerr << "error al almacenar los tags privados, error al escribir los datos: (" << group << ","<<element<<")" << cond.text() <<std::endl;
				return NULL;
			}

			return pElement;
		}
		/*------------------------------*/
		TagPrivadoUndefined::TagPrivadoUndefined()
		{
			Valor = NULL;
			Size = 0;
		}

		TagPrivadoUndefined::TagPrivadoUndefined(unsigned int size)
		{
			Size = size;
			Valor = new unsigned char[Size];
		}

		TagPrivadoUndefined::TagPrivadoUndefined(unsigned char* valor, unsigned int size)
		{
			Size = size;
			Valor = new unsigned char[Size];
			memcpy(Valor,valor,Size*sizeof(unsigned char));
		}

		TagPrivadoUndefined::~TagPrivadoUndefined() 
		{
			if (Valor != NULL) {
				delete [] Valor;
			}
			Valor = NULL;
			Size = 0;
		}

		TagPrivadoUndefined::TagPrivadoUndefined(const TagPrivadoUndefined& otro) 
		{
			this->Size = otro.Size;
			this->Valor = new unsigned char[Size];
			memcpy(otro.Valor,this->Valor,Size*sizeof(unsigned char));
		}

		TagPrivadoUndefined& TagPrivadoUndefined::operator = (const TagPrivadoUndefined& otro) 
		{
			this->Size = otro.Size;
			this->Valor = new unsigned char[Size];
			memcpy(otro.Valor,this->Valor,Size*sizeof(unsigned char));
			return *this;
		}

		void TagPrivadoUndefined::Copiar(void* ptrCopia, int size) 
		{
			if(this->Valor != NULL) {
				delete[] this->Valor;
			}
			this->Size = size;
			this->Valor = new unsigned char [Size];
			memcpy(this->Valor,ptrCopia,Size*sizeof(unsigned char));
		}

		std::string TagPrivadoUndefined::ToString() 
		{
			return std::string ((char*)Valor,Size);
		}

		unsigned char* TagPrivadoUndefined::GetValor()
		{
			return Valor;
		}

		unsigned int TagPrivadoUndefined::GetSize()
		{
			return Size;
		}

		DcmElement* TagPrivadoUndefined::ToElement(unsigned int group, unsigned int element)
		{
			OFCondition cond;
			DcmVR vr(EVR_UN);
			DcmTagKey key(group,element);
			DcmTag tag(key,vr);
			if (tag.error() != EC_Normal) {
				std::cerr << "error al almacenar los tags privados, tag desconocido: (" << group << ","<<element<<")" <<std::endl;
				return NULL;
			}

			DcmElement* pElement = newDicomElement(tag);

			if(pElement==NULL){
				std::cerr << "error al almacenar los tags privados, error al crear el elemento: (" << group << ","<<element<<")" <<std::endl;
				return NULL;
			}

			cond=pElement->putUint8Array(Valor,Size);
			
			if (cond.bad()) {
				std::cerr << "error al almacenar los tags privados, error al escribir los datos: (" << group << ","<<element<<")" <<std::endl;
				return NULL;
			}

			return pElement;
		}

		/*------------------------------*/
		TipoPrivateTags::~TipoPrivateTags()
		{
			Vaciar();
		}
	}
}

