/*
** 1998-07-05 -	The Split command, handy for, er, splitting files into parts. Mucho GUI.
** 1999-03-07 -	Altered for the new selection/generic handler. Hum, I really should finish
**		this command off some day...
** 1999-06-19 -	Adapted for the new dialog module. Sheesh, I really should finish this command
**		some day!
*/

#include "gentoo.h"

#include <fcntl.h>

#include "cmd_delete.h"
#include "dialog.h"
#include "dirpane.h"
#include "errors.h"
#include "fileutil.h"
#include "guiutil.h"
#include "overwrite.h"
#include "sizeutil.h"

#include "cmd_generic.h"
#include "cmd_split.h"

#define	CMD_ID	"split"

#define	NFORMAT_LIMIT	(MAXNAMLEN + 16)

#define	THRESH_KB	(1.0)
#define	THRESH_MB	(0.5)
#define	THRESH_GB	(0.5)

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	GtkWidget	*vbox;		/* This really is required. */
	GtkWidget	*label;		/* Tells the user what's up. */
	GtkWidget	*mode;		/* Option menu for selecting mode of split. */
	GtkWidget	*mvbox;		/* Sub-vbox for the mode-specific widgets. */
	GtkWidget	*nhbox;		/* Hbox for the naming issue. */
	GtkWidget	*nformat;	/* Entry widget for name formatter. */
	GtkObject	*nbadj;		/* Adjustment for index base. */
	GtkWidget	*nbase;		/* Spin widget for index base. */
	GtkObject	*nsadj;		/* Adjustment for index step. */
	GtkWidget	*nstep;		/* Spin widget for index step. */

	GtkWidget	*ssframe;	/* Frame for "split to fixed size". */
	GtkWidget	*sssize;	/* Combo holding the wanted size. */
	GtkWidget	*snframe;	/* Frame for "split to fixed number". */

	MainInfo	*min;
	guint		curr_mode;	/* 0 for fixed size, 1 for fixed amount. */
	const gchar	*name;		/* Source file being split. */
} SplitInfo;

/* ----------------------------------------------------------------------------------------- */

/* 1998-09-01 -	Pretty much rewrote this function, now that the sizeutil module exists. */
static void spt_body(MainInfo *min, DirPane *src, DirRow *row, gpointer user)
{
	gchar		buf[2 * MAXNAMLEN], siz1[32], siz2[32];
	SplitInfo	*spi = user;

	sze_put_size(siz1, sizeof siz1, DP_ROW_LSTAT(row).st_size, SZE_BYTES);
	sze_put_size(siz2, sizeof siz2, DP_ROW_LSTAT(row).st_size, SZE_AUTO);
	if(strcmp(siz1, siz2) != 0)
		g_snprintf(buf, sizeof buf, _("Split \"%s\".\nFile is %s (%s)."), DP_ROW_NAME(row), siz1, siz2);
	else
		g_snprintf(buf, sizeof buf, _("Split \"%s\".\nFile is %s."), DP_ROW_NAME(row), siz1);
	gtk_label_set_text(GTK_LABEL(spi->label), buf);
	gtk_entry_set_text(GTK_ENTRY(spi->nformat), DP_ROW_NAME(row));
	gtk_entry_append_text(GTK_ENTRY(spi->nformat), ".%03d");
	spi->name = DP_ROW_NAME(row);
}

/* 1998-09-01 -	Construct destination file name for piece number <piece> in a split. */
static void build_name(SplitInfo *spi, DirPane *dst, gchar *buf, gint piece)
{
	gchar	fmt[sizeof G_DIR_SEPARATOR_S + NFORMAT_LIMIT + 8];
	gint	base = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spi->nbase)),
		step = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spi->nstep)),
		num  = base + step * piece;

	g_snprintf(fmt, sizeof fmt, "%%s%s%s", G_DIR_SEPARATOR_S, gtk_entry_get_text(GTK_ENTRY(spi->nformat)));
	g_snprintf(buf, PATH_MAX, fmt, dst->dir.path, num);
}

/* 1998-09-01 -	Split file on row <row> of <src>, producing a bunch of segment files in <dst>.
**		Each segment will have the same size.
** 1998-09-12 -	Didn't have any closing of the output files. I really should be shot. Also
**		fixed the protection bits for the output; now same as the source file.
** 1999-11-13 -	Adapted to use new fut_copy_partial() function, fixed bug with closing output
**		file on failed write.
*/
static gint size_split(SplitInfo *spi, DirPane *src, DirPane *dst, DirRow *row)
{
	gchar	inname[PATH_MAX], outname[PATH_MAX];
	gsize	seg_size, to_go, chunk;
	gint	ifd, ofd, piece = 0;
	OvwRes	ores;

	ovw_overwrite_begin(spi->min, _("\"%s\" Already Exists - Continue With Split?"), 0UL);

	if((seg_size = sze_get_size(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(spi->sssize)->entry)))) > 0)
	{
		g_snprintf(inname, sizeof inname, "%s%s%s", src->dir.path, G_DIR_SEPARATOR_S, DP_ROW_NAME(row));
		if((ifd = open(inname, O_RDONLY)) > 0)
		{
			to_go = DP_ROW_LSTAT(row).st_size;
			while(to_go > 0)
			{
				gboolean	doit = FALSE;

				build_name(spi, dst, outname, piece++);
				ores  = ovw_overwrite_file(spi->min, outname, dp_full_name(src, DP_ROW_INDEX(src, row)));
				chunk = (to_go > seg_size) ? seg_size : to_go;
				if(ores == OVW_CANCEL)
					break;
				else if(ores == OVW_SKIP)
				{
					if(lseek(ifd, chunk, SEEK_CUR) != (off_t) -1)
						to_go -= chunk;
					else
						break;
				}
				else if(ores == OVW_PROCEED)
					doit = TRUE;
				else if(ores == OVW_PROCEED_FILE)
					doit = del_delete_file(spi->min, outname);
				else if(ores == OVW_PROCEED_DIR)
					doit = del_delete_dir(spi->min, outname, FALSE);
				if(doit)
				{
					if((ofd = open(outname, O_WRONLY | O_CREAT | O_TRUNC, DP_ROW_LSTAT(row).st_mode | S_IWUSR)) >= 0)
					{
						gsize	put;

						put = fut_copy_partial(ifd, ofd, 1 << 18, chunk);
						close(ofd);
						if(put == 0)
							break;
						to_go -= put;
					}
					else
						break;
				}
			}
			close(ifd);
		}
	}
	ovw_overwrite_end(spi->min);

	if(errno)
		err_set(spi->min, errno, CMD_ID, spi->name);
	
	return to_go == 0;
}

static gint spt_action(MainInfo *min, DirPane *src, DirPane *dst, DirRow *row, gpointer user)
{
	SplitInfo	*spi = user;
	gint		ret = 0;

	if(spi->curr_mode == 0)		/* Fixed-size split? */
		ret = size_split(spi, src, dst, row);
	else				/* Fixed amount split. */
		dlg_dialog_async_new_simple(_("This splitting mode has not been\nimplemented yet... Sorry."), _("Beta Software"), _("Next Version?"), NULL, NULL);

	if(ret)
		dp_unselect(src, DP_ROW_INDEX(src, row));

	return ret;
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-07-09 -	Build widgetry needed to support splitting to fixed part size. */
static void build_ss(SplitInfo *spi)
{
	GtkWidget	*hbox, *vbox, *label;
	GList		*list = NULL;

	list = g_list_append(list, _("  1457000 bytes (3.5\" floppy)"));
	list = g_list_append(list, _("100431360 bytes (Zip disk)"));

	spi->ssframe = gtk_frame_new(_("Fixed Size Split"));
	vbox  = gtk_vbox_new(FALSE, 0);
	hbox  = gtk_hbox_new(FALSE, 0);
	label = gtk_label_new(_("Segment Size"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	spi->sssize = gtk_combo_new();
	gtk_combo_set_popdown_strings(GTK_COMBO(spi->sssize), list);
	gtk_box_pack_start(GTK_BOX(hbox), spi->sssize, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

	gtk_container_add(GTK_CONTAINER(spi->ssframe), vbox);
	gtk_box_pack_start(GTK_BOX(spi->vbox), spi->ssframe, TRUE, TRUE, 0);
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-09-01 -	Callback for mode option menu. */
static gint evt_mode_select(GtkWidget *wid, gpointer user)
{
	SplitInfo	*spi = user;

	spi->curr_mode = GPOINTER_TO_UINT(gtk_object_get_user_data(GTK_OBJECT(wid)));

	return TRUE;
}

/* ----------------------------------------------------------------------------------------- */

gint cmd_split(MainInfo *min, DirPane *src, DirPane *dst, const CmdArg *ca)
{
	static SplitInfo	spi;
	const gchar		*mode[] = { N_("Fixed size, variable number of parts"),
					    N_("Fixed number of parts, variable sizes"),
					    NULL };
	GtkWidget	*hbox, *label;
	GtkWidget	*hsep;

	spi.min	      = min;
	spi.curr_mode = 0;
	spi.vbox = gtk_vbox_new(FALSE, 0);
	spi.label = gtk_label_new(_("Split"));

	hbox = gtk_hbox_new(FALSE, 0);
	label = gtk_label_new(_("Mode"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	spi.mode = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(spi.vbox), spi.label, FALSE, FALSE, 0);
	hsep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(spi.vbox), hsep, FALSE, FALSE, 4);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(spi.mode), gui_build_menu(mode, GTK_SIGNAL_FUNC(evt_mode_select), &spi));
	gtk_box_pack_start(GTK_BOX(hbox), spi.mode, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(spi.vbox), hbox, FALSE, FALSE, 0);
	spi.nhbox = gtk_hbox_new(FALSE, 0);
	label = gtk_label_new(_("Name Format"));
	gtk_box_pack_start(GTK_BOX(spi.nhbox), label, FALSE, FALSE, 2);
	spi.nformat = gtk_entry_new_with_max_length(NFORMAT_LIMIT);
	gtk_box_pack_start(GTK_BOX(spi.nhbox), spi.nformat, TRUE, TRUE, 0);
	label = gtk_label_new(_("Base"));
	gtk_box_pack_start(GTK_BOX(spi.nhbox), label, FALSE, FALSE, 0);
	spi.nbadj   = gtk_adjustment_new(0, 0, 31, 1, 16, 16);
	spi.nbase   = gtk_spin_button_new(GTK_ADJUSTMENT(spi.nbadj), 0, 0);
	gtk_box_pack_start(GTK_BOX(spi.nhbox), spi.nbase, FALSE, FALSE, 0);
	label = gtk_label_new(_("Step"));
	gtk_box_pack_start(GTK_BOX(spi.nhbox), label, FALSE, FALSE, 0);
	spi.nsadj = gtk_adjustment_new(1, 1, 31, 1, 16, 16);
	spi.nstep = gtk_spin_button_new(GTK_ADJUSTMENT(spi.nsadj), 0, 0);
	gtk_box_pack_start(GTK_BOX(spi.nhbox), spi.nstep, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(spi.vbox), spi.nhbox, FALSE, FALSE, 2);

	build_ss(&spi);

	return cmd_generic(min, _("Split"), CGF_NOALL | CGF_NODIRS, spt_body, spt_action, NULL, &spi);
}
