Description: <short summary of the patch>
 TODO: Put a short summary on the line above and replace this paragraph
 with a longer explanation of this change. Complete the meta-information
 with other relevant fields (see below for details). To make it easier, the
 information below has been extracted from the changelog. Adjust it or drop
 it.
 .
 gcl (2.6.10-5) unstable; urgency=high
 .
   * 2.6.11pre test 4
Author: Camm Maguire <camm@debian.org>

---
The information above should follow the Patch Tagging Guidelines, please
checkout http://dep.debian.net/deps/dep3/ to learn about the format. Here
are templates for supplementary fields that you might want to add:

Origin: <vendor|upstream|other>, <url of original patch>
Bug: <url in upstream bugtracker>
Bug-Debian: http://bugs.debian.org/<bugnumber>
Bug-Ubuntu: https://launchpad.net/bugs/<bugnumber>
Forwarded: <no|not-needed|url proving that it has been forwarded>
Reviewed-By: <name and email of someone who approved the patch>
Last-Update: <YYYY-MM-DD>

--- gcl-2.6.10.orig/configure
+++ gcl-2.6.10/configure
@@ -8428,6 +8428,16 @@ fi
 rm -f core conftest.err conftest.$ac_objext conftest.$ac_ext
 
 
+for ac_func in sigaltstack
+do :
+  ac_fn_c_check_func "$LINENO" "sigaltstack" "ac_cv_func_sigaltstack"
+if test "x$ac_cv_func_sigaltstack" = xyes; then :
+  cat >>confdefs.h <<_ACEOF
+#define HAVE_SIGALTSTACK 1
+_ACEOF
+
+fi
+done
 
 
 #if test $use = "386-linux" ; then
--- gcl-2.6.10.orig/configure.in
+++ gcl-2.6.10/configure.in
@@ -2410,8 +2410,7 @@ int joe=SIGEMT;
  AC_MSG_RESULT(yes)],
 AC_MSG_RESULT(no))
 
-
-
+AC_CHECK_FUNCS(sigaltstack)
 
 #if test $use = "386-linux" ; then
 	AC_CHECK_HEADERS(asm/sigcontext.h)
--- gcl-2.6.10.orig/gcl-tk/tkMain.c
+++ gcl-2.6.10/gcl-tk/tkMain.c
@@ -55,6 +55,8 @@
 #include <signal.h>
 #include <errno.h>
 
+int writable_malloc=0; /*FIXME, don't wrap fopen here, exclude notcomp.h or equivalent */
+
 #include "guis.h"
 struct connection_state *dsfd;
 /*-------------------------------------------------------------------*/
--- gcl-2.6.10.orig/h/386-bsd.h
+++ gcl-2.6.10/h/386-bsd.h
@@ -50,9 +50,6 @@
 #endif
 /* end listen for input */
 
-/* we dont need to worry about zeroing fp->_base , to prevent  */
-#define FCLOSE_SETBUF_OK 
-
 #define DATA_BEGIN (char *)N_DATADDR(header);
 #define UNIXSAVE "unexlin.c"
 
@@ -81,10 +78,6 @@
 #define DONT_NEED_MALLOC
 #endif
 
-#define INSTALL_SEGMENTATION_CATCHER \
-  	 (void) signal(SIGSEGV,segmentation_catcher); \
-  	 (void) signal(SIGBUS,segmentation_catcher)
-
 /* Begin for cmpinclude */
 
 #define WANT_SGC
--- gcl-2.6.10.orig/h/386-macosx.h
+++ gcl-2.6.10/h/386-macosx.h
@@ -113,18 +113,6 @@ extern int seek_to_end_ofile (FILE *);
 /* Copied from {Net,Free,Open}BSD.h  */
 /* Modified according to Camm's instructions on April 15, 2004.  */
 #define HAVE_SIGPROCMASK
-/* #define SIG_STACK_SIZE (SIGSTKSZ/sizeof(double)) */
-#define SETUP_SIG_STACK                                \
-{                                                      \
-static stack_t estack;                                 \
-static double estack_buf [SIG_STACK_SIZE];             \
-bzero(estack_buf, sizeof(estack_buf));                 \
-estack.ss_sp = (char *) &estack_buf[SIG_STACK_SIZE-1]; \
-estack.ss_flags = 0;                                   \
-estack.ss_size = SIGSTKSZ;                             \
-if (sigaltstack(&estack, 0) < 0)                       \
-    perror("sigaltstack");                             \
-}
 
 /* until the sgc/save problem can be fixed.  20050114 CM*/
 /* #define SGC */
@@ -141,10 +129,6 @@ do {
   sigaction (SIGSEGV, &sact, 0);                        \
 } while (0);
 
-#define INSTALL_SEGMENTATION_CATCHER                \
-  (void) signal (SIGSEGV, segmentation_catcher);    \
-  (void) signal (SIGBUS, segmentation_catcher)
-
 /* si_addr not containing the faulting address is a bug in Darwin.
    Work around this by looking at the dar field of the exception state.  */
 #define GET_FAULT_ADDR(sig,code,sv,a) ((siginfo_t *)code)->si_addr
@@ -190,9 +174,6 @@ do {int c=0;
         return(FALSE);                                                  \
 } while (0)
 
-/* We (hopefully) dont need to worry about zeroing fp->_base.  */
-#define FCLOSE_SETBUF_OK 
-
 #define GET_FULL_PATH_SELF(a_)                              \
 do {                                                        \
 extern int _NSGetExecutablePath (char *, unsigned long *);  \
--- gcl-2.6.10.orig/h/FreeBSD.h
+++ gcl-2.6.10/h/FreeBSD.h
@@ -79,23 +79,6 @@ do {								\
 #define HAVE_SIGPROCMASK
 #define SIG_STACK_SIZE (SIGSTKSZ/sizeof(double))
 
-#undef SETUP_SIG_STACK
-#define SETUP_SIG_STACK {					\
-	static struct sigaltstack estack;			\
-	if (estack.ss_sp == NULL &&				\
-	    (estack.ss_sp = malloc(SIGSTKSZ)) == NULL)		\
-		perror("malloc");				\
-	estack.ss_size = SIGSTKSZ;				\
-	estack.ss_flags = 0;					\
-	if (sigaltstack(&estack, 0) < 0)			\
-		perror("sigaltstack");				\
-}
-
-#undef INSTALL_SEGMENTATION_CATCHER
-#define INSTALL_SEGMENTATION_CATCHER				\
-  	 (void) gcl_signal(SIGSEGV, segmentation_catcher);	\
-  	 (void) gcl_signal(SIGBUS, segmentation_catcher)
-
 /*
  * The next two defines are for SGC,
  *	one of which needs to go in cmpinclude.h.
--- gcl-2.6.10.orig/h/NetBSD.h
+++ gcl-2.6.10/h/NetBSD.h
@@ -76,18 +76,6 @@
 
 /* end stuff for dumping and reloading */
 
-/* begin setup alternate signal stack */
-#define SIG_STACK_SIZE SIGSTKSZ
-#define SETUP_SIG_STACK \
-{ static struct sigaltstack estack ; \
-  estack.ss_size = sizeof(estack_buf) ; \
-  estack.ss_flags = 0; \
-  estack.ss_base = (char *) &estack_buf[SIG_STACK_SIZE-1]; \
-  if (sigaltstack(&estack, (struct sigaltstack *)0) < 0) \
-               perror("sigaltstack");} \
-
-/* end setup signal stack  */
-
 #define HZ		60
 
 /* begin  for GC */
@@ -114,13 +102,3 @@
 	fflush(save);
 
 /* end read header */
-
-#define INSTALL_SEGMENTATION_CATCHER \
-  	 (void) signal(SIGSEGV,segmentation_catcher); \
-  	 (void) signal(SIGBUS,segmentation_catcher)
-
-
-
-
-
-
--- gcl-2.6.10.orig/h/OpenBSD.h
+++ gcl-2.6.10/h/OpenBSD.h
@@ -19,9 +19,6 @@
 #define I386
 #define	IEEEFLOAT
 
-/* we don't need to worry about zeroing fp->_base, to prevent what??? */
-#define FCLOSE_SETBUF_OK 
-
 /* #undef HAVE_XDR */
 
 #define USE_ATT_TIME
@@ -59,21 +56,6 @@
 #define PAGEWIDTH 12		/* i386 sees 4096 byte pages */
 /* end for GC */
 
-#define SIG_STACK_SIZE (SIGSTKSZ/sizeof(double))
-#define SETUP_SIG_STACK \
-{ \
-	static struct sigaltstack estack; \
-	estack.ss_sp = estack_buf; \
-	estack.ss_size = SIGSTKSZ; \
-	estack.ss_flags = 0; \
-	if (sigaltstack(&estack, 0) < 0) \
-	  perror("sigaltstack"); \
-}
-
-#define INSTALL_SEGMENTATION_CATCHER \
-  	 (void) gcl_signal(SIGSEGV, segmentation_catcher); \
-  	 (void) gcl_signal(SIGBUS, segmentation_catcher)
-
 /*
  * The next two defines are for SGC,
  *	one of which needs to go in cmpinclude.h.
--- gcl-2.6.10.orig/h/gclincl.h.in
+++ gcl-2.6.10/h/gclincl.h.in
@@ -180,6 +180,9 @@
 /* have setenv call */
 #undef HAVE_SETENV
 
+/* Define to 1 if you have the `sigaltstack' function. */
+#undef HAVE_SIGALTSTACK
+
 /* have sigcontext */
 #undef HAVE_SIGCONTEXT
 
--- gcl-2.6.10.orig/h/gnuwin95.h
+++ gcl-2.6.10/h/gnuwin95.h
@@ -50,7 +50,6 @@ extern DBEGIN_TY _dbegin;
 
 #define HAVE_SIGACTION
 /* a noop */
-#define SETUP_SIG_STACK
 #define SA_ONSTACK 0
 
 #define brk(x) printf("not doing break\n");
@@ -82,8 +81,6 @@ extern DBEGIN_TY _dbegin;
 	ungetc(i, fp); \
     } while (0)
 		
-#define FCLOSE_SETBUF_OK 
-
 #define RUN_PROCESS
 
 #define	IEEEFLOAT
--- gcl-2.6.10.orig/h/hp300-bsd.h
+++ gcl-2.6.10/h/hp300-bsd.h
@@ -47,13 +47,6 @@
  */
 #define GET_FAULT_ADDR(sig,code,sv,a) ((char *) code)
 
-#define INSTALL_SEGMENTATION_CATCHER \
-  	 (void) signal(SIGSEGV,segmentation_catcher); \
-  	 (void) signal(SIGBUS,segmentation_catcher)
-
-
-
-
 /* Begin for cmpinclude */
 
 
--- gcl-2.6.10.orig/h/linux.h
+++ gcl-2.6.10/h/linux.h
@@ -79,8 +79,6 @@ do {static struct sigaction action; \
 
 #undef HAVE_SIGVEC
 #define HAVE_SIGACTION
-/* make this a noop */
-/* #define SETUP_SIG_STACK */
 #ifndef HAVE_SV_ONSTACK
 #define SV_ONSTACK 0
 #endif
@@ -109,9 +107,6 @@ do { int c = 0; \
      && (ioctl((fp)->_fileno, FIONREAD, &c),c<=0)) \
      return 0;} while (0)
 
-/* we dont need to worry about zeroing fp->_base , to prevent  */
-#define FCLOSE_SETBUF_OK 
-
 /* #define DATA_BEGIN((TXTRELOC+header.a_text+(SEGSIZ-1)) & ~(SEGSIZ-1)); */
 #define DATA_BEGIN (char *)(char *)N_DATADDR(header);
 
@@ -123,11 +118,6 @@ do { int c = 0; \
 #define GETPATHNAME
 #define PATHNAME_CACHE	10
 
-
-#define INSTALL_SEGMENTATION_CATCHER \
-  	 (void) gcl_signal(SIGSEGV,segmentation_catcher)
-
-
 /* get the fileno of a FILE* */
 #define FILENO(x) fileno(x)
 
--- gcl-2.6.10.orig/h/mingw.h
+++ gcl-2.6.10/h/mingw.h
@@ -95,7 +95,6 @@ extern DBEGIN_TY _stacktop, _stackbottom
 #define NEED_TO_REINSTALL_SIGNALS
 
 /*#define HAVE_SIGACTION*/
-#define SETUP_SIG_STACK
 #define SV_ONSTACK 0
 #define SA_RESTART 0
 
@@ -141,7 +140,6 @@ extern DBEGIN_TY _stacktop, _stackbottom
         ungetc(i, fp); \
     } while (0)
 		
-#define FCLOSE_SETBUF_OK 
 #define	IEEEFLOAT
 #define I386
 
--- gcl-2.6.10.orig/h/notcomp.h
+++ gcl-2.6.10/h/notcomp.h
@@ -284,3 +284,7 @@ gcl_init_cmp_anon(void);
 #include "gmp_wrappers.h"
 
 #define massert(a_) if (!(a_)) assert_error(#a_,__LINE__,__FILE__,__FUNCTION__)
+
+extern bool writable_malloc;
+#define writable_malloc_wrap(f_,rt_,a_...) ({rt_ v;bool w=writable_malloc;writable_malloc=1;v=f_(a_);writable_malloc=w;v;})
+#define fopen(a_,b_) writable_malloc_wrap(fopen,FILE *,a_,b_)
--- gcl-2.6.10.orig/h/powerpc-macosx.h
+++ gcl-2.6.10/h/powerpc-macosx.h
@@ -98,18 +98,6 @@ do {
 /* Copied from {Net,Free,Open}BSD.h  */
 /* Modified according to Camm's instructions on April 15, 2004.  */
 #define HAVE_SIGPROCMASK
-/* #define SIG_STACK_SIZE (SIGSTKSZ/sizeof(double)) */
-#define SETUP_SIG_STACK                                \
-{                                                      \
-static struct sigaltstack estack;                      \
-static double estack_buf [SIG_STACK_SIZE];             \
-bzero(estack_buf, sizeof(estack_buf));                 \
-estack.ss_sp = (char *) &estack_buf[SIG_STACK_SIZE-1]; \
-estack.ss_flags = 0;                                   \
-estack.ss_size = SIGSTKSZ;                             \
-if (sigaltstack(&estack, 0) < 0)                       \
-    perror("sigaltstack");                             \
-}
 
 /* until the sgc/save problem can be fixed.  20050114 CM*/
 /* #define SGC */
@@ -126,10 +114,6 @@ do {
   sigaction (SIGSEGV, &sact, 0);                        \
 } while (0);
 
-#define INSTALL_SEGMENTATION_CATCHER                \
-  (void) signal (SIGSEGV, segmentation_catcher);    \
-  (void) signal (SIGBUS, segmentation_catcher)
-
 /* si_addr not containing the faulting address is a bug in Darwin.
    Work around this by looking at the dar field of the exception state.  */
 #define GET_FAULT_ADDR(sig,code,scp,addr) ((char *) (((ucontext_t *) scp)->uc_mcontext->es.dar))
@@ -174,9 +158,6 @@ do {int c=0;
         return(FALSE);                                                  \
 } while (0)
 
-/* We (hopefully) dont need to worry about zeroing fp->_base.  */
-#define FCLOSE_SETBUF_OK 
-
 #define GET_FULL_PATH_SELF(a_)                              \
 do {                                                        \
 extern int _NSGetExecutablePath (char *, unsigned long *);  \
--- gcl-2.6.10.orig/h/protoize.h
+++ gcl-2.6.10/h/protoize.h
@@ -1899,3 +1899,7 @@ object
 number_dpb(object,object,object);
 object
 number_dpf(object,object,object);
+
+#if defined(DARWIN)
+void init_darwin_zone_compat ();
+#endif
--- gcl-2.6.10.orig/h/rios-aix3.h
+++ gcl-2.6.10/h/rios-aix3.h
@@ -225,11 +225,6 @@ for the kernel.   See aix3_mprotect dire
 #undef VSSIZE
 #define VSSIZE 81520
 
-
-#define INSTALL_SEGMENTATION_CATCHER \
-        sigstack(&estack,0); \
-        (void) gcl_signal(SIGSEGV,segmentation_catcher);
-
 #if defined(IN_SOCKETS) || defined(IN_GUIS)
 #include <sys/select.h>
 #undef bzero
--- gcl-2.6.10.orig/h/rios.h
+++ gcl-2.6.10/h/rios.h
@@ -235,10 +235,6 @@ for the kernel.   See aix3_mprotect dire
 #define VSSIZE 81520
 
 
-#define INSTALL_SEGMENTATION_CATCHER \
-        sigstack(&estack,0); \
-        (void) gcl_signal(SIGSEGV,segmentation_catcher);
-
 #if defined(IN_SOCKETS) || defined(IN_GUIS)
 #include <sys/select.h>
 #undef bzero
--- gcl-2.6.10.orig/h/sun4.h
+++ gcl-2.6.10/h/sun4.h
@@ -22,14 +22,6 @@
 #define GET_FAULT_ADDR(sig,code,scp,addr) \
   (code ? ((siginfo_t *)code )->si_addr : error("no address info"))
 
-#define SETUP_SIG_STACK \
-{ static stack_t estack ; \
-  estack.ss_size = sizeof(estack_buf) ; \
-  estack.ss_flags = 0; \
-  estack.ss_sp = (char *) &estack_buf[SIG_STACK_SIZE-1]; \
-  if (sigaltstack(&estack, (stack_t *)0) < 0) \
-               perror("sigaltstack");} \
-  
 #undef HAVE_AOUT
 #define HAVE_AOUT <elf.h>
 #define HAVE_ELF
--- gcl-2.6.10.orig/o/alloc.c
+++ gcl-2.6.10/o/alloc.c
@@ -1063,33 +1063,27 @@ gcl_init_alloc(void *cs_start) {
   cs_limit = cs_org + CSTACK_DIRECTION*cssize;
 
 #ifdef __ia64__
-    {
-      extern void * __libc_ia64_register_backing_store_base;
-      cs_org2=cs_base2=__libc_ia64_register_backing_store_base;
-    }
+  {
+    extern void * __libc_ia64_register_backing_store_base;
+    cs_org2=cs_base2=__libc_ia64_register_backing_store_base;
+  }
 #endif
-
-#ifdef SETUP_SIG_STACK
-  SETUP_SIG_STACK
-#else
-#if defined(HAVE_SIGACTION) || defined(HAVE_SIGVEC)
-    {
-      /* make sure the stack is 8 byte aligned */
-      static double estack_buf[32*SIGSTKSZ];
-      static struct sigaltstack estack;
-      
-      bzero(estack_buf,sizeof(estack_buf));
-      estack.ss_sp = estack_buf;
-      estack.ss_flags = 0;                                   
-      estack.ss_size = sizeof(estack_buf);                             
-      massert(sigaltstack(&estack, 0)>=0);
-      
-    }
-#endif	
+  
+#ifdef HAVE_SIGALTSTACK
+  {
+    /* make sure the stack is 8 byte aligned */
+    static double estack_buf[32*SIGSTKSZ];
+    static stack_t estack;
+    
+    estack.ss_sp = estack_buf;
+    estack.ss_flags = 0;                                   
+    estack.ss_size = sizeof(estack_buf);                             
+    massert(sigaltstack(&estack, 0)>=0);
+  }
 #endif	
-
+  
   install_segmentation_catcher();
-
+  
 #ifdef SGC
 
   massert(getpagesize()<=PAGESIZE);
@@ -1592,6 +1586,8 @@ static char *baby_malloc(n)
 /*  } */
 /*  #endif */
 
+bool writable_malloc=0;
+
 void *
 malloc(size_t size) {
 
@@ -1609,7 +1605,8 @@ malloc(size_t size) {
   malloc_list = make_cons(Cnil, malloc_list);
   malloc_list->c.c_car = alloc_simple_string(size);
   malloc_list->c.c_car->st.st_self = alloc_contblock(size);
-  
+  malloc_list->c.c_car->st.st_adjustable=writable_malloc;
+
   /* FIXME: this is just to handle clean freeing of the
      monstartup memory allocated automatically on raw image
      startup.  In saved images, monstartup memory is only
--- gcl-2.6.10.orig/o/file.d
+++ gcl-2.6.10/o/file.d
@@ -309,34 +309,27 @@ BEGIN:
 
 void
 setup_stream_buffer(object x) {
-#ifndef NO_SETBUF
-  char *buf=alloc_contblock(BUFSIZ);
-  x->sm.sm_buffer = buf;
-  setbuf(x->sm.sm_fp, buf);
+#ifdef NO_SETBUF
+  massert(!setvbuf(x->sm.sm_fp,x->sm.sm_buffer=NULL,_IONBF,0));
 #else
-  setvbuf(x->sm.sm_fp,NULL,_IONBF,0);
-  x->sm.sm_buffer=0;
+  massert(!setvbuf(x->sm.sm_fp,x->sm.sm_buffer=writable_malloc_wrap(malloc,void *,BUFSIZ),_IOFBF,BUFSIZ));
 #endif
 }	
 
 static void
 deallocate_stream_buffer(object strm) {
 
+  if (strm->sm.sm_buffer==NULL)
+    return;
+
 /* SGC contblock pages: Its possible this is on an old page CM 20030827 */
-  if (strm->sm.sm_buffer) {
 #ifdef SGC
-    insert_maybe_sgc_contblock(strm->sm.sm_buffer, BUFSIZ); 
+  insert_maybe_sgc_contblock(strm->sm.sm_buffer,BUFSIZ); 
 #else
-    insert_contblock(strm->sm.sm_buffer, BUFSIZ); 
+  insert_contblock(strm->sm.sm_buffer,BUFSIZ); 
 #endif
-    if (strm->sm.sm_fp)
-      setvbuf(strm->sm.sm_fp,NULL,_IONBF,0);
-    strm->sm.sm_buffer = 0;
-  } 
 
-#ifndef FCLOSE_SETBUF_OK
-  strm->sm.sm_fp->_base = NULL;
-#endif
+  massert(!setvbuf(strm->sm.sm_fp,strm->sm.sm_buffer=NULL,_IONBF,0));
 
 }
 
--- gcl-2.6.10.orig/o/main.c
+++ gcl-2.6.10/o/main.c
@@ -105,15 +105,6 @@ int sgc_enabled;
 #endif
 void install_segmentation_catcher(void);
 
-#ifndef SIG_STACK_SIZE
-#define SIG_STACK_SIZE 1000
-#endif
-#ifndef SETUP_SIG_STACK
-#if defined(HAVE_SIGACTION) || defined(HAVE_SIGVEC)
-        struct sigstack estack;
-#endif
-#endif
-
 int
 cstack_dir(fixnum j) {
   static fixnum n;
@@ -362,13 +353,8 @@ main(int argc, char **argv, char **envp)
 /* catch certain signals */
 void install_segmentation_catcher(void)
 {
-#ifdef INSTALL_SEGMENTATION_CATCHER
-  INSTALL_SEGMENTATION_CATCHER;
-#else
-#ifdef SIGSEGV
-       (void) gcl_signal(SIGSEGV,segmentation_catcher);
-#endif
-#endif
+  (void) gcl_signal(SIGSEGV,segmentation_catcher);
+  (void) gcl_signal(SIGBUS,segmentation_catcher);
 }
 
 int catch_fatal=1;
@@ -585,13 +571,6 @@ ihs_overflow(void) {
 
 void
 segmentation_catcher(int i) {
-#ifndef SIG_STACK_SIZE 
-  int x;
-  if (&x < cs_limit)
-    cs_overflow();
-  else 
-    printf("Segmentation violation: c stack ok:signalling error");
-#endif
   error("Segmentation violation.");
 }
 
--- gcl-2.6.10.orig/o/sfaslcoff.c
+++ gcl-2.6.10/o/sfaslcoff.c
@@ -59,7 +59,8 @@ struct reloc {
 } __attribute__ ((packed));
 #define R_ABS         0x0000  /* absolute, no relocation is necessary */
 #define R_DIR32       0x0006  /* Direct 32-bit reference to the symbols virtual address */
-#define R_PCRLONG     0x0014  /* 32-bit reference pc relative  to the symbols virtual address */
+#define R_SECREL32    0x000B  /* Currently ignored, used only for debugging strings FIXME */
+#define R_PCRLONG     0x0014  /* 32-bit reference pc relative to the symbols virtual address */
 
 struct syment {
   union {
@@ -113,6 +114,7 @@ relocate(struct scnhdr *sec,struct reloc
   switch(rel->r_type) {
 
   case R_ABS:
+  case R_SECREL32:
     break;
 
   case R_DIR32:
--- gcl-2.6.10.orig/o/sgbc.c
+++ gcl-2.6.10/o/sgbc.c
@@ -415,7 +415,7 @@ sgc_mark_object1(object x) {
       sgc_mark_object(x->sm.sm_object1);
       if (saving_system) {
 	FILE *fp = x->sm.sm_fp;
-	if (fp != 0 && fp != stdin && fp !=stdout) {
+	if (fp != 0 /* && fp != stdin && fp !=stdout */) {
 	  fclose(fp);
 	  x->sm.sm_fp=0;
 	}
@@ -1309,19 +1309,6 @@ sgc_start(void) {
 	SET_WRITABLE(page(pi));
       else
 	tm_of(pi->type)->tm_alt_npage++;
-#ifndef NO_SETBUF /*FIXME, implement restartable getc with read in readc_stream*/
-      {
-	void *v,*ve;
-	if (pi->type!=(tm=tm_of(t_stream))->tm_type) continue;
-	for (v=pagetochar(page(pi)),ve=v+tm->tm_nppage*tm->tm_size;v<ve;v+=tm->tm_size) {
-	  object x=v;
-	  if (type_of(x)!=t_stream || is_free(x)) continue;
-	  if (x->sm.sm_buffer) 
-	    for (i=page(x->sm.sm_buffer);i<=page(x->sm.sm_buffer+BUFSIZ-1);i++)
-	      SET_WRITABLE(i);
-	}
-      }
-#endif
     }
     for (pi=contblock_list_head;pi;pi=pi->next)/*FIXME*/
       if (pi->sgc_flags&SGC_WRITABLE)
@@ -1329,14 +1316,16 @@ sgc_start(void) {
 	  SET_WRITABLE(page(pi)+i);
       else
 	tm_of(t_contiguous)->tm_alt_npage+=pi->in_use;
-#ifdef GCL_GPROF
     {
-      extern object gprof_array;
-      if (gprof_array!=Cnil)
-	for (i=0;i<(gprof_array->st.st_fillp +PAGESIZE-1)/PAGESIZE;i++)
-	  SET_WRITABLE(page(gprof_array->st.st_self)+i);
+      extern object malloc_list;
+      object x;
+
+      for (x=malloc_list;x!=Cnil;x=x->c.c_cdr)
+	if (x->c.c_car->st.st_adjustable)
+	  for (i=page(x->c.c_car->st.st_self);i<=page(x->c.c_car->st.st_self+x->c.c_car->st.st_fillp-1);i++)
+	    SET_WRITABLE(i);
     }
-#endif
+
     for (i=page(heap_end);i<page(old_rb_start);i++)
 	SET_WRITABLE(i);
     tm_of(t_relocatable)->tm_alt_npage=page(rb_start)-page(old_rb_start);
--- gcl-2.6.10.orig/o/unixsave.c
+++ gcl-2.6.10/o/unixsave.c
@@ -140,33 +140,19 @@ char *original_file, *save_file;
 
 extern void _cleanup();
 
-LFD(Lsave)()
-{
-	char filename[256];
-
-	check_arg(1);
-	check_type_or_pathname_string_symbol_stream(&vs_base[0]);
-	coerce_to_filename(vs_base[0], filename);
-
-	_cleanup();
-/*
-	{
-		FILE *p;
-		int nfile;
-
-
-		nfile = NUMBER_OPEN_FILES;
-
-		for (p = &_iob[3];  p < &_iob[nfile];  p++)
-			fclose(p);
-	}
-*/
-	memory_save(kcl_self, filename);
-/*
-	_exit(0);
-*/
-	exit(0);
-	/*  no return  */
+LFD(Lsave)() {
+  char filename[256];
+  
+  check_arg(1);
+  check_type_or_pathname_string_symbol_stream(&vs_base[0]);
+  coerce_to_filename(vs_base[0], filename);
+  malloc_list=Cnil;
+  
+  _cleanup();
+  
+  memory_save(kcl_self, filename);
+  exit(0);
+  /*  no return  */
 }
 
 #endif /* UNIXSAVE include */
