/* do not edit automatically generated by mc from StrCase.  */
/* StrCase.mod provides procedure to convert between text case.

Copyright (C) 2001-2020 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#include <string.h>
#include <limits.h>
#define _StrCase_H
#define _StrCase_C

#   include "GASCII.h"
#   include "GStrLib.h"


/*
   StrToUpperCase - converts string, a, to uppercase returning the
                    result in, b.
*/

void StrCase_StrToUpperCase (char *a_, unsigned int _a_high, char *b, unsigned int _b_high);

/*
   StrToLowerCase - converts string, a, to lowercase returning the
                    result in, b.
*/

void StrCase_StrToLowerCase (char *a_, unsigned int _a_high, char *b, unsigned int _b_high);

/*
   Cap - converts a lower case character into a capital character.
         If the character is not a lower case character 'a'..'z'
         then the character is simply returned unaltered.
*/

char StrCase_Cap (char ch);

/*
   Lower - converts an upper case character into a lower case character.
           If the character is not an upper case character 'A'..'Z'
           then the character is simply returned unaltered.
*/

char StrCase_Lower (char ch);


/*
   StrToUpperCase - converts string, a, to uppercase returning the
                    result in, b.
*/

void StrCase_StrToUpperCase (char *a_, unsigned int _a_high, char *b, unsigned int _b_high)
{
  unsigned int higha;
  unsigned int highb;
  unsigned int i;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  higha = StrLib_StrLen ((char *) a, _a_high);
  highb = _b_high;
  i = 0;
  while (((i < higha) && (a[i] != ASCII_nul)) && (i < highb))
    {
      b[i] = StrCase_Cap (a[i]);
      i += 1;
    }
  if (i < highb)
    {
      b[i] = ASCII_nul;
    }
}


/*
   StrToLowerCase - converts string, a, to lowercase returning the
                    result in, b.
*/

void StrCase_StrToLowerCase (char *a_, unsigned int _a_high, char *b, unsigned int _b_high)
{
  unsigned int higha;
  unsigned int highb;
  unsigned int i;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  higha = StrLib_StrLen ((char *) a, _a_high);
  highb = _b_high;
  i = 0;
  while (((i < higha) && (a[i] != ASCII_nul)) && (i < highb))
    {
      b[i] = StrCase_Lower (a[i]);
      i += 1;
    }
  if (i < highb)
    {
      b[i] = ASCII_nul;
    }
}


/*
   Cap - converts a lower case character into a capital character.
         If the character is not a lower case character 'a'..'z'
         then the character is simply returned unaltered.
*/

char StrCase_Cap (char ch)
{
  if ((ch >= 'a') && (ch <= 'z'))
    {
      ch = ((char) (( ((unsigned int) (ch))- ((unsigned int) ('a')))+ ((unsigned int) ('A'))));
    }
  return ch;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Lower - converts an upper case character into a lower case character.
           If the character is not an upper case character 'A'..'Z'
           then the character is simply returned unaltered.
*/

char StrCase_Lower (char ch)
{
  if ((ch >= 'A') && (ch <= 'Z'))
    {
      ch = ((char) (( ((unsigned int) (ch))- ((unsigned int) ('A')))+ ((unsigned int) ('a'))));
    }
  return ch;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

void _M2_StrCase_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}

void _M2_StrCase_finish (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}
