;; Pipeline descriptions of Andes NDS32 cpu for GNU compiler
;; Copyright (C) 2012-2018 Free Software Foundation, Inc.
;; Contributed by Andes Technology Corporation.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.


;; ------------------------------------------------------------------------
;; Define N10 pipeline settings.
;; ------------------------------------------------------------------------

(define_automaton "nds32_n10_machine")

;; ------------------------------------------------------------------------
;; Pipeline Stages
;; ------------------------------------------------------------------------
;; IF - Instruction Fetch
;; II - Instruction Issue / Instruction Decode
;; EX - Instruction Execution
;; MM - Memory Execution
;; WB - Instruction Retire / Result Write-Back

(define_cpu_unit "n10_ii" "nds32_n10_machine")
(define_cpu_unit "n10_ex" "nds32_n10_machine")
(define_cpu_unit "n10_mm" "nds32_n10_machine")
(define_cpu_unit "n10_wb" "nds32_n10_machine")
(define_cpu_unit "n10f_iq" "nds32_n10_machine")
(define_cpu_unit "n10f_rf" "nds32_n10_machine")
(define_cpu_unit "n10f_e1" "nds32_n10_machine")
(define_cpu_unit "n10f_e2" "nds32_n10_machine")
(define_cpu_unit "n10f_e3" "nds32_n10_machine")
(define_cpu_unit "n10f_e4" "nds32_n10_machine")

(define_insn_reservation "nds_n10_unknown" 1
  (and (eq_attr "type" "unknown")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_misc" 1
  (and (eq_attr "type" "misc")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_mmu" 1
  (and (eq_attr "type" "mmu")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_alu" 1
  (and (eq_attr "type" "alu")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_alu_shift" 1
  (and (eq_attr "type" "alu_shift")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ii+n10_ex, n10_ex+n10_mm, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_pbsad" 1
  (and (eq_attr "type" "pbsad")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex*3, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_pbsada" 1
  (and (eq_attr "type" "pbsada")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex*3, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_load" 1
  (and (match_test "nds32::load_single_p (insn)")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_store" 1
  (and (match_test "nds32::store_single_p (insn)")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_load_multiple_1" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "load_multiple")
	    (eq_attr "combo" "1")))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_load_multiple_2" 1
  (and (eq_attr "pipeline_model" "n10")
       (ior (and (eq_attr "type" "load_multiple")
		 (eq_attr "combo" "2"))
	    (match_test "nds32::load_double_p (insn)")))
  "n10_ii, n10_ii+n10_ex, n10_ex+n10_mm, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_load_multiple_3" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "load_multiple")
	    (eq_attr "combo" "3")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_load_multiple_4" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "load_multiple")
	    (eq_attr "combo" "4")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, n10_ii+n10_ex+n10_mm+n10_wb, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_load_multiple_5" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "load_multiple")
	    (eq_attr "combo" "5")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, (n10_ii+n10_ex+n10_mm+n10_wb)*2, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_load_multiple_6" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "load_multiple")
	    (eq_attr "combo" "6")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, (n10_ii+n10_ex+n10_mm+n10_wb)*3, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_load_multiple_7" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "load_multiple")
	    (eq_attr "combo" "7")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, (n10_ii+n10_ex+n10_mm+n10_wb)*4, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_load_multiple_N" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "load_multiple")
	    (match_test "get_attr_combo (insn) >= 8")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, (n10_ii+n10_ex+n10_mm+n10_wb)*5, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_store_multiple_1" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "store_multiple")
	    (eq_attr "combo" "1")))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_store_multiple_2" 1
  (and (eq_attr "pipeline_model" "n10")
       (ior (and (eq_attr "type" "store_multiple")
		 (eq_attr "combo" "2"))
       (match_test "nds32::store_double_p (insn)")))
  "n10_ii, n10_ii+n10_ex, n10_ex+n10_mm, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_store_multiple_3" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "store_multiple")
	    (eq_attr "combo" "3")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_store_multiple_4" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "store_multiple")
	    (eq_attr "combo" "4")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, n10_ii+n10_ex+n10_mm+n10_wb, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_store_multiple_5" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "store_multiple")
	    (eq_attr "combo" "5")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, (n10_ii+n10_ex+n10_mm+n10_wb)*2, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_store_multiple_6" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "store_multiple")
	    (eq_attr "combo" "6")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, (n10_ii+n10_ex+n10_mm+n10_wb)*3, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_store_multiple_7" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "store_multiple")
	    (eq_attr "combo" "7")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, (n10_ii+n10_ex+n10_mm+n10_wb)*4, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_store_multiple_N" 1
  (and (eq_attr "pipeline_model" "n10")
       (and (eq_attr "type" "store_multiple")
	    (match_test "get_attr_combo (insn) >= 8")))
  "n10_ii, n10_ii+n10_ex, n10_ii+n10_ex+n10_mm, (n10_ii+n10_ex+n10_mm+n10_wb)*5, n10_ex+n10_mm+n10_wb, n10_mm+n10_wb, n10_wb")

(define_insn_reservation "nds_n10_mul" 1
  (and (eq_attr "type" "mul")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_mac" 1
       (and (eq_attr "type" "mac")
	    (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_div" 1
  (and (eq_attr "type" "div")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex*34, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_branch" 1
  (and (eq_attr "type" "branch")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_alu" 1
  (and (eq_attr "type" "dalu")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_alu64" 1
  (and (eq_attr "type" "dalu64")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_alu_round" 1
  (and (eq_attr "type" "daluround")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_cmp" 1
  (and (eq_attr "type" "dcmp")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_clip" 1
  (and (eq_attr "type" "dclip")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_mul" 1
  (and (eq_attr "type" "dmul")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_mac" 1
  (and (eq_attr "type" "dmac")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_insb" 1
  (and (eq_attr "type" "dinsb")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_pack" 1
  (and (eq_attr "type" "dpack")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_bpick" 1
  (and (eq_attr "type" "dbpick")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_dsp_wext" 1
  (and (eq_attr "type" "dwext")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ex, n10_mm, n10_wb")

(define_insn_reservation "nds_n10_fpu_alu" 4
  (and (eq_attr "type" "falu")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_muls" 4
  (and (eq_attr "type" "fmuls")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_muld" 4
  (and (eq_attr "type" "fmuld")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2*2, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_macs" 4
  (and (eq_attr "type" "fmacs")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2*3, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_macd" 4
  (and (eq_attr "type" "fmacd")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2*4, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_divs" 4
  (and (ior (eq_attr "type" "fdivs")
	    (eq_attr "type" "fsqrts"))
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2*14, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_divd" 4
  (and (ior (eq_attr "type" "fdivd")
	    (eq_attr "type" "fsqrtd"))
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2*28, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_fast_alu" 2
  (and (ior (eq_attr "type" "fcmp")
	    (ior (eq_attr "type" "fabs")
		 (ior (eq_attr "type" "fcpy")
		      (eq_attr "type" "fcmov"))))
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_fmtsr" 4
  (and (eq_attr "type" "fmtsr")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_fmtdr" 4
  (and (eq_attr "type" "fmtdr")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ii+n10f_iq, n10f_iq+n10f_rf, n10f_rf+n10f_e1, n10f_e1+n10f_e2, n10f_e2+n10f_e3, n10f_e3+n10f_e4, n10f_e4")

(define_insn_reservation "nds_n10_fpu_fmfsr" 2
  (and (eq_attr "type" "fmfsr")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_fmfdr" 2
  (and (eq_attr "type" "fmfdr")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10_ii+n10f_iq, n10f_iq+n10f_rf, n10f_rf+n10f_e1, n10f_e1+n10f_e2, n10f_e2+n10f_e3, n10f_e3+n10f_e4, n10f_e4")

(define_insn_reservation "nds_n10_fpu_load" 3
  (and (eq_attr "type" "fload")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2, n10f_e3, n10f_e4")

(define_insn_reservation "nds_n10_fpu_store" 1
  (and (eq_attr "type" "fstore")
       (eq_attr "pipeline_model" "n10"))
  "n10_ii, n10f_iq, n10f_rf, n10f_e1, n10f_e2, n10f_e3, n10f_e4")

;; ------------------------------------------------------------------------
;; Comment Notations and Bypass Rules
;; ------------------------------------------------------------------------
;; Producers (LHS)
;;   LD
;;     Load data from the memory and produce the loaded data. The result is
;;     ready at MM.
;;   LMW(N, M)
;;     There are N micro-operations within an instruction that loads multiple
;;     words. The result produced by the M-th micro-operation is sent to
;;     consumers. The result is ready at MM.
;;   MUL, MAC
;;     Compute data in the multiply-adder and produce the data. The result
;;     is ready at MM.
;;   DIV
;;     Compute data in the divider and produce the data. The result is ready
;;     at MM.
;;
;; Consumers (RHS)
;;   ALU, MOVD44, PBSAD, PBSADA_RaRb, MUL, MAC, DIV, MMU
;;     Require operands at EX.
;;   ALU_SHIFT_Rb
;;     An ALU-SHIFT instruction consists of a shift micro-operation followed
;;     by an arithmetic micro-operation. The operand Rb is used by the first
;;     micro-operation, and there are some latencies if data dependency occurs.
;;   MAC_RaRb
;;     A MAC instruction does multiplication at EX and does accumulation at MM,
;;     so the operand Rt is required at MM, and operands Ra and Rb are required
;;     at EX.
;;   ADDR_IN
;;     If an instruction requires an address as its input operand, the address
;;     is required at EX.
;;   ST
;;     A store instruction requires its data at MM.
;;   SMW(N, M)
;;     There are N micro-operations within an instruction that stores multiple
;;     words. Each M-th micro-operation requires its data at MM.
;;   BR
;;     If a branch instruction is conditional, its input data is required at EX.

;; FPU_ADDR_OUT -> FPU_ADDR_IN
;; Main pipeline rules don't need this because those default latency is 1.
(define_bypass 1
  "nds_n10_fpu_load, nds_n10_fpu_store"
  "nds_n10_fpu_load, nds_n10_fpu_store"
  "nds32_n10_ex_to_ex_p"
)

;; LD, MUL, MAC, DIV, DALU64, DMUL, DMAC, DALUROUND, DBPICK, DWEXT
;;   -> ALU, ALU_SHIFT_Rb, PBSAD, PBSADA_RaRb, MOVD44, MUL, MAC_RaRb, DIV, ADDR_IN, BR, MMU,
;;      DALU, DALUROUND, DMUL, DMAC_RaRb, DPACK, DINSB, DCMP, DCLIP, WEXT_O, BPICK_RaRb
(define_bypass 2
  "nds_n10_load, nds_n10_mul, nds_n10_mac, nds_n10_div,\
   nds_n10_dsp_alu64, nds_n10_dsp_mul, nds_n10_dsp_mac,\
   nds_n10_dsp_alu_round, nds_n10_dsp_bpick, nds_n10_dsp_wext"
  "nds_n10_alu, nds_n10_alu_shift,\
   nds_n10_pbsad, nds_n10_pbsada,\
   nds_n10_mul, nds_n10_mac, nds_n10_div,\
   nds_n10_branch,\
   nds_n10_load, nds_n10_store,\
   nds_n10_load_multiple_1, nds_n10_load_multiple_2, nds_n10_load_multiple_3,\
   nds_n10_load_multiple_4, nds_n10_load_multiple_5, nds_n10_load_multiple_6,\
   nds_n10_load_multiple_7, nds_n10_load_multiple_N,\
   nds_n10_store_multiple_1, nds_n10_store_multiple_2, nds_n10_store_multiple_3,\
   nds_n10_store_multiple_4, nds_n10_store_multiple_5, nds_n10_store_multiple_6,\
   nds_n10_store_multiple_7, nds_n10_store_multiple_N,\
   nds_n10_mmu,\
   nds_n10_dsp_alu, nds_n10_dsp_alu_round,\
   nds_n10_dsp_mul, nds_n10_dsp_mac, nds_n10_dsp_pack,\
   nds_n10_dsp_insb, nds_n10_dsp_cmp, nds_n10_dsp_clip,\
   nds_n10_dsp_wext, nds_n10_dsp_bpick"
  "nds32_n10_mm_to_ex_p"
)

;; LMW(N, N)
;;   -> ALU, ALU_SHIFT_Rb, PBSAD, PBSADA_RaRb, MOVD44, MUL, MAC_RaRb, DIV, ADDR_IN, BR, MMU
;;      DALU, DALUROUND, DMUL, DMAC_RaRb, DPACK, DINSB, DCMP, DCLIP, WEXT_O, BPICK_RaRb
(define_bypass 2
  "nds_n10_load_multiple_1, nds_n10_load_multiple_2, nds_n10_load_multiple_3,\
   nds_n10_load_multiple_4, nds_n10_load_multiple_5, nds_n10_load_multiple_6,\
   nds_n10_load_multiple_7, nds_n10_load_multiple_N"
  "nds_n10_alu, nds_n10_alu_shift,\
   nds_n10_pbsad, nds_n10_pbsada,\
   nds_n10_mul, nds_n10_mac, nds_n10_div,\
   nds_n10_branch,\
   nds_n10_load, nds_n10_store,\
   nds_n10_load_multiple_1, nds_n10_load_multiple_2, nds_n10_load_multiple_3,\
   nds_n10_load_multiple_4, nds_n10_load_multiple_5, nds_n10_load_multiple_6,\
   nds_n10_load_multiple_7, nds_n10_load_multiple_N,\
   nds_n10_store_multiple_1, nds_n10_store_multiple_2, nds_n10_store_multiple_3,\
   nds_n10_store_multiple_4, nds_n10_store_multiple_5, nds_n10_store_multiple_6,\
   nds_n10_store_multiple_7, nds_n10_store_multiple_N,\
   nds_n10_mmu,\
   nds_n10_dsp_alu, nds_n10_dsp_alu_round,\
   nds_n10_dsp_mul, nds_n10_dsp_mac, nds_n10_dsp_pack,\
   nds_n10_dsp_insb, nds_n10_dsp_cmp, nds_n10_dsp_clip,\
   nds_n10_dsp_wext, nds_n10_dsp_bpick"
  "nds32_n10_last_load_to_ex_p"
)
