// { dg-options "-std=gnu++0x" }

// Copyright (C) 2007 Free Software Foundation
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
// USA.

#include <ostream>
#include <sstream>
#include <system_error>
#include <algorithm>
#include <testsuite_hooks.h>

//   Effects: os << ec.category().name() << ':' << ec.value();
void test()
{
  using namespace std;
  bool test __attribute__((unused)) = true;

  char buf[64];
  error_code e1;
  error_code e2(bad_address);
  string s, s1, s2;

  {
    ostringstream ostr;
    ostr << e1 << endl;
    s1 = ostr.str();

    if (ostr.rdstate() & ios_base::eofbit) 
      test = false;
  }
  VERIFY( test );
  VERIFY( find(s1.begin(), s1.end(), ':') != s1.end() );

  sprintf(buf, "%i", e1.value());
  s = buf;
  VERIFY( s1.find(s) != string::npos);

  {
    ostringstream ostr;
    ostr << e2 << endl;
    s2 = ostr.str();

    if (ostr.rdstate() & ios_base::eofbit) 
      test = false;
  }
  VERIFY( test );
  VERIFY( find(s2.begin(), s2.end(), ':') != s2.end() );

  sprintf(buf, "%i", e2.value());
  s = buf;
  VERIFY( s2.find(s) != string::npos);
}

int 
main()
{
  test(); 
  return 0;
}
