/***************************************************************************

  limit.h

  Compiler  and interpreter limits

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __GB_LIMIT_H
#define __GB_LIMIT_H

/* Nombre maximum de paramtres d'une fonction */
#define MAX_PARAM_FUNC      63

/* Nombre maximum de paramtres d'une sous-routine */
#define MAX_PARAM_SUBR      63

/* Nombre maximum de paramtres d'une opration */
#define MAX_PARAM_OP        63

/* Nombre maximum de paramtres pour l'interprteur */
#define MAX_PARAM           127

/* Nombre maximum d'imbrication dans une expression */
#define MAX_EXPR_LEVEL      255

/* Nombre maximum de patterns dans une expression */
#define MAX_EXPR_PATTERN    1023

/* Longueur maximale d'un symbole */
#define MAX_SYMBOL_LEN      255

/* Nombre maximum de symboles d'un objet pour un type donn: statique, dynamique, ou mthode */
#define MAX_CLASS_SYMBOL    1024

/* Nombre maximum de variables locales d'une fonction */
#define MAX_LOCAL_SYMBOL    127

/* Nombre maximum de structures de controles imbriques */
#define MAX_CTRL_LEVEL      16

/* Nombre maximum de dimensions d'un tableau */
#define MAX_ARRAY_DIM       8

/* Longueur maximale d'un nom de chemin */
#define MAX_PATH            256

/* Nombre maximum d'imbrications de conteneurs dans un formulaire */
#define MAX_FORM_PARENT     32

/* Nombre maximum de comparaisons dans un CASE */
#define MAX_CASE_EXPR       32

/* Nombre maximal de points d'arrets */
#define MAX_BREAKPOINT      255

/* Nombre d'octets maximum d'une entre/sortie */
#define MAX_IO              4096

/* Nombre maximum de niveaux d'hritages */
#define MAX_INHERITANCE     8

/* Taille maximale d'un message d'erreur */
#define MAX_ERROR_MSG       511

#endif

