/***************************************************************************

  CFont.h

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __CFONT_H
#define __CFONT_H

#include <qfont.h>

#include "gambas.h"
#include "main.h"
#include "CWidget.h"

#ifndef __CFONT_CPP
extern GB_DESC CFontDesc[];
extern GB_DESC CFontsDesc[];
extern int CFONT_dpi;
#else

#define THIS OBJECT(CFONT)

#endif

typedef
  struct {
    GB_BASE ob;
    QString *family;
    }
  CFONTINFO;

typedef
  struct {
    GB_BASE ob;
    QFont *font;
    CWIDGET *control;
    enum { Name, Size, Bold, Italic, Underline, StrikeOut };
    }
  CFONT;

#define CFONT_NORMAL        0
#define CFONT_APPLICATION   1
#define CFONT_DRAW          2
  
CFONT *CFONT_create(const QFont &font, int type = CFONT_NORMAL);
CFONT *CFONT_create_control(CWIDGET *control);
double CFONT_size_real_to_virtual(double);
double CFONT_size_virtual_to_real(double);

#define SIZE_REAL_TO_VIRTUAL(_size) CFONT_size_real_to_virtual((double)(_size))
#define SIZE_VIRTUAL_TO_REAL(_size) CFONT_size_virtual_to_real((double)(_size))

#endif
