/***************************************************************************

  trace.h

  The debugger

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __GBX_TRACE_H
#define __GBX_TRACE_H


#include "gb_pcode.h"
#include "gbx_value.h"

typedef
  struct {
    int id;
    FUNCTION *func;
    PCODE *addr;
    CLASS *class;
    ushort line;
    /*PCODE value;*/
    VALUE *bp;
    FUNCTION *fp;
    }
  TRACE_BREAK;

typedef
  struct {
    boolean stop;
    FUNCTION *fp;
    VALUE *bp;
    void *op;
    CLASS *cp;
    PCODE *ec;
    VALUE *ep;
    }
  TRACE_GLOBAL;

typedef
  enum {
    TC_NONE     = 0,
    TC_STEP     = 1,
    TC_NEXT     = 2,
    TC_GO       = 3,
    TC_FROM     = 4
    }
  TRACE_TYPE;

typedef
  struct {
    char *pattern;
    TRACE_TYPE type;
    void (*func)(const char *);
    boolean loop;
    }
  TRACE_COMMAND;


#ifndef __GBX_TRACE_C

EXTERN TRACE_GLOBAL TRACE;

/*
EXTERN boolean TRACE_stop_at_next_break;
EXTERN FUNCTION *TRACE_stop_in_function;
*/

/*EXTERN FUNCTION *TRACE_start_function;*/

#endif


#define TRACE_WELCOME \
  "Welcome to the Gambas Debugger.\n"

PUBLIC void TRACE_breakpoint(int id);
PUBLIC void TRACE_next(void);
PUBLIC void TRACE_main(boolean error);

PUBLIC const char *TRACE_get_position(CLASS *cp, FUNCTION *fp, PCODE *pc);
PUBLIC const char *TRACE_get_current_position(void);

PUBLIC void TRACE_break_on_next_line(void);

PUBLIC void TRACE_init(void);
PUBLIC void TRACE_exit(void);
PUBLIC void TRACE_welcome(void);

#endif
