/***************************************************************************

  CError.c

  The native class Error

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __GBX_C_ERROR_C

#include "gb_common.h"
#include "gbx_class.h"
#include "gbx_trace.h"

#include "gambas.h"
#include "gbx_api.h"

#include "gbx_object.h"
#include "gbx_string.h"

#include "gbx_c_error.h"


BEGIN_PROPERTY(error_code)

  GB_ReturnInt(ERROR_info.code);

END_PROPERTY


BEGIN_PROPERTY(error_text)

  GB_ReturnNewZeroString(ERROR_info.msg);

END_PROPERTY


BEGIN_PROPERTY(error_class)

  GB_ReturnObject(ERROR_info.cp);

END_PROPERTY


BEGIN_PROPERTY(error_where)

  GB_ReturnNewZeroString(TRACE_get_position(ERROR_info.cp, ERROR_info.fp, ERROR_info.pc));

END_PROPERTY


BEGIN_METHOD_VOID(error_clear)

  ERROR_clear();

END_METHOD


BEGIN_METHOD(error_raise, GB_STRING msg)

  ERROR_define(GB_ToZeroString(ARG(msg)), NULL);
  GAMBAS_Error = TRUE;

END_METHOD


PUBLIC GB_DESC NATIVE_Error[] =
{
  GB_DECLARE("Error", 0), GB_VIRTUAL_CLASS(),

  GB_STATIC_PROPERTY_READ("Code", "i", error_code),
  GB_STATIC_PROPERTY_READ("Text", "s", error_text),
  GB_STATIC_PROPERTY_READ("Class", "Class", error_class),
  GB_STATIC_PROPERTY_READ("Where", "s", error_where),

  GB_STATIC_METHOD("Clear", NULL, error_clear, NULL),
  GB_STATIC_METHOD("Raise", NULL, error_raise, "(Message)s"),

  GB_END_DECLARE
};


