/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "functions.h"
#include "populate_users.h"
#include "show_info.h"
#include "commands.h"


extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];
extern char global_user_name[1024];



void populate_users(struct w *widgets)
{
    /* Lists all the users in the userlist */
    FILE *fp;
    char *line;
    long file_size;
    GtkTreeIter iter;
    GtkTreePath *path;
    gboolean edit=0;
    gchar *username, *user_item, *group_name;
    gchar *utf8=NULL;
    int x = 0, found_user = 0;
//    char tempname[4096]="";

    gtk_list_store_clear(widgets->user_store);

    if((fp=fopen(GS_PASSWD,"r"))==NULL)
    {
	return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);
    line = allocate(file_size);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
	for(x=0; line[x]!='\0'; x++)
        {
    	    if(line[x]==':')
            {
		found_user = 1;
		gtk_list_store_append(GTK_LIST_STORE(widgets->user_store), &iter);
		
//                snprintf(tempname, 4000, "%s", line);
//                tempname[x]='\0';
                
                username = g_strdup_printf("%s", line);
                username[x]='\0';

		/* Insert username */
    		utf8 = g_locale_to_utf8(username, strlen(username), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->user_store), &iter, 0, utf8, -1);
		if( utf8!=NULL )
	    	  g_free(utf8);

		/* Insert groupname, first get the group number */
		user_item = get_user_setting(username, "group");
		/* Get group name from the group number */
		group_name = get_group_name(user_item);

    		utf8 = g_locale_to_utf8(group_name, strlen(group_name), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->user_store), &iter, 1, utf8, -1);
		if( user_item!=NULL )
	    	  g_free(user_item);
		if( group_name!=NULL )
	    	  g_free(group_name);
		if( utf8!=NULL )
	    	  g_free(utf8);

		/* Insert comment */
		user_item = get_user_setting(username, "comment");
    		utf8 = g_locale_to_utf8(user_item, strlen(user_item), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->user_store), &iter, 2, utf8, -1);
		if( user_item!=NULL )
	    	  g_free(user_item);
		if( utf8!=NULL )
	    	  g_free(utf8);

		/* Insert home directory */
		user_item = get_user_setting(username, "homedir");
    		utf8 = g_locale_to_utf8(user_item, strlen(user_item), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->user_store), &iter, 3, utf8, -1);
		if( user_item!=NULL )
	    	  g_free(user_item);
		if( utf8!=NULL )
	    	  g_free(utf8);

		g_free(username);
		break;
    	    }
        }
    }
    free(line);
    fclose(fp);


    /* Unset global user name if no user was found */
    if( ! found_user )
    {
	strcat(global_user_name, "");
        return;
    }
    
    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->user_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
